/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.internal;

import com.adobe.aemds.guide.service.GuideCaptchaValidator;
import com.adobe.aemds.guide.service.GuideException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false, label="Adaptive Form Captcha validator provider Service", description="Service to provide GuideCaptchaValidator impl class object.")
@Service(value={GuideCaptchaValidatorProvider.class})
public class GuideCaptchaValidatorProvider {
    private static final Logger logger = LoggerFactory.getLogger(GuideCaptchaValidatorProvider.class);
    @Reference(referenceInterface=GuideCaptchaValidator.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindCaptchaValidatorProviderMap", unbind="unbindCaptchaValidatorProviderMap")
    private Map<String, Map<Comparable<Object>, GuideCaptchaValidator>> captchaValidatorProviderMap = new ConcurrentHashMap<String, Map<Comparable<Object>, GuideCaptchaValidator>>();

    protected void bindCaptchaValidatorProviderMap(GuideCaptchaValidator validator, Map<String, Object> config) {
        String validatorName = validator.getCaptchaValidatorName();
        if (this.captchaValidatorProviderMap.containsKey(validatorName)) {
            ConcurrentSkipListMap innerMap = (ConcurrentSkipListMap)this.captchaValidatorProviderMap.get(validatorName);
            innerMap.put(ServiceUtil.getComparableForServiceRanking(config), validator);
        } else {
            ConcurrentSkipListMap<Comparable<Object>, GuideCaptchaValidator> innerMap = new ConcurrentSkipListMap<Comparable<Object>, GuideCaptchaValidator>();
            innerMap.put(ServiceUtil.getComparableForServiceRanking(config), validator);
            this.captchaValidatorProviderMap.put(validatorName, innerMap);
        }
    }

    protected void unbindCaptchaValidatorProviderMap(GuideCaptchaValidator validator, Map<String, Object> config) {
        String validatorName = validator.getCaptchaValidatorName();
        if (this.captchaValidatorProviderMap.containsKey(validatorName)) {
            ConcurrentSkipListMap innerMap = (ConcurrentSkipListMap)this.captchaValidatorProviderMap.get(validatorName);
            innerMap.remove(ServiceUtil.getComparableForServiceRanking(config));
        }
    }

    public GuideCaptchaValidator getGuideCaptchaValidator(String validatorName) throws GuideException {
        if (StringUtils.isEmpty(validatorName)) {
            throw new GuideException("captcha validator name is required");
        }
        GuideCaptchaValidator captchaValidator = null;
        if (!StringUtils.isEmpty(validatorName)) {
            ConcurrentSkipListMap innerMap = (ConcurrentSkipListMap)this.captchaValidatorProviderMap.get(validatorName);
            if (innerMap != null && innerMap.firstEntry() != null) {
                captchaValidator = (GuideCaptchaValidator)innerMap.firstEntry().getValue();
            } else {
                logger.error("Captcha validator impl object not found.");
            }
        } else {
            logger.error("Captcha service provider name is required to validate the captcha");
        }
        if (captchaValidator == null) {
            throw new GuideException("No validator is available for given validator name : " + validatorName);
        }
        return captchaValidator;
    }
}

