/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.progressive;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideProgressiveStrategy;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import com.adobe.aemds.guide.utils.GuideProgressiveUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.sightly.WCMUsePojo;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class GuideProgressiveDataCapture
extends WCMUsePojo {
    private static final String DEFAULT_HEIGHT = "400";
    private static final String DEFAULT_WIDTH = "300";
    private GuideContainer guideContainer;
    private String allSectionJson = null;
    private String afLocale;
    private String afRuntimeLocale;
    private String tmpRoot;
    private Boolean enableAutoSave;
    private Boolean addTestData = false;

    @Override
    public void activate() throws Exception {
        Map<String, String> paramMap;
        SlingHttpServletRequest request = this.getRequest();
        RequestParameterMap requestParams = request.getRequestParameterMap();
        if (GuideUtils.paramToString(requestParams.getValue("addTestData")) != null) {
            this.addTestData = Boolean.valueOf(GuideUtils.paramToString(requestParams.getValue("addTestData")));
        }
        ValueMap properties = this.getProperties();
        String type = properties.get("guideStrategyType", "");
        String progressiveStrategyName = properties.get("strategyName", "");
        if (progressiveStrategyName.length() == 0) {
            progressiveStrategyName = properties.get("guideStrategy", "");
        }
        String progressiveStrategyJcrPath = properties.get("strategyJcrPath", "");
        String progressiveStrategyParams = properties.get("guideProgressiveStrategyParams", "");
        if (progressiveStrategyParams.length() == 0) {
            progressiveStrategyParams = properties.get("guideStrategyParams", "");
        }
        if ((paramMap = GuideUtils.convertStringToMap(progressiveStrategyParams)).get("strategyJcrPath") == null) {
            paramMap.put("strategyJcrPath", progressiveStrategyJcrPath);
        }
        String afAssetPath = properties.get("guideRef", "");
        String afResourcePath = GuideUtils.guideRefToGuidePath(afAssetPath);
        Resource afResource = this.getResourceResolver().getResource(afResourcePath);
        this.guideContainer = GuideContainer.from(request, afResource);
        this.afLocale = "guides.I18N." + GuideUtils.getLocale(request, afResource);
        this.afRuntimeLocale = GuideUtils.getGuideRuntimeLocale(request, afResource);
        this.tmpRoot = UUID.randomUUID().toString();
        this.enableAutoSave = properties.get("enableAutoSave", false);
        if ("service".equals(type) && progressiveStrategyName.length() > 0) {
            GuideProgressiveStrategyManager guideProgressiveStrategyManager = this.getSlingScriptHelper().getService(GuideProgressiveStrategyManager.class);
            GuideProgressiveStrategy guideProgressiveStrategy = guideProgressiveStrategyManager.getGuideProgressiveStrategyService(progressiveStrategyName);
            List<Object> allSections = guideProgressiveStrategy.getAllSections(paramMap);
            this.allSectionJson = GuideProgressiveUtils.convertToJson(allSections);
        }
    }

    public String getAllSectionsJson() {
        return this.allSectionJson;
    }

    public String getProgressiveGuideInitializationState() {
        if (this.addTestData.booleanValue()) {
            return this.guideContainer.getGuideInitializationState();
        }
        return "";
    }

    public GuideContainer getGuideContainer() {
        return this.guideContainer;
    }

    public String getAfLocale() {
        return this.afLocale;
    }

    public String getAfRuntimeLocale() {
        return this.afRuntimeLocale;
    }

    public String getTmpRoot() {
        return this.tmpRoot;
    }

    public Boolean getEnableAutoSave() {
        return this.enableAutoSave;
    }

    public String getHeight() {
        return this.getProperties().get("height", DEFAULT_HEIGHT);
    }

    public String getWidth() {
        return this.getProperties().get("width", DEFAULT_WIDTH);
    }
}

