/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aemds.guide.model.BreakPointResponsiveConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class ResponsiveConfiguration {
    @Inject
    @Optional
    @Named(value="./default")
    private BreakPointResponsiveConfiguration defaultConfiguration;
    @Inject
    @Optional
    @Named(value="./tablet")
    private BreakPointResponsiveConfiguration tabletConfiguration;
    @Inject
    @Optional
    @Named(value="./phone")
    private BreakPointResponsiveConfiguration phoneConfiguration;
    @Inject
    @Optional
    @Named(value="./smallScreen")
    private BreakPointResponsiveConfiguration smallScreenConfiguration;
    private static String CSS_CLASS_SEPARATOR = " ";
    private static String CSS_FD_PREFIX = "fd";
    private static String CSS_CLASS_PREFIX = CSS_FD_PREFIX + "-col";
    private static String OFFSET_PREFIX = "offset-";
    private static String SCREEN_SIZE_LARGE = "-lg-";
    private static String SCREEN_SIZE_MEDIUM = "-md-";
    private static String SCREEN_SIZE_SMALL = "-sm-";
    private static String SCREEN_SIZE_EXTRA_SMALL = "-xs-";
    private static String NEWLINE_BEHAVIOR = "newline";
    private static String DEFAULT_OFFSET = "0";
    private static Integer DEFAULT_WIDTH = 12;
    private static String NEWLINE_CLASS = "newline";
    private static Logger logger = LoggerFactory.getLogger(ResponsiveConfiguration.class);

    public BreakPointResponsiveConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public BreakPointResponsiveConfiguration getTabletConfiguration() {
        return this.tabletConfiguration;
    }

    public BreakPointResponsiveConfiguration getPhoneConfiguration() {
        return this.phoneConfiguration;
    }

    public BreakPointResponsiveConfiguration getSmallScreenConfiguration() {
        return this.smallScreenConfiguration;
    }

    public String getResponsiveClasses() {
        StringBuilder responsiveClassBuilder = new StringBuilder();
        String defaultClass = this.getCssClass(this.defaultConfiguration, null, SCREEN_SIZE_LARGE);
        String mediumClass = this.getCssClass(this.tabletConfiguration, this.defaultConfiguration, SCREEN_SIZE_MEDIUM);
        String smallClass = this.getCssClass(this.phoneConfiguration, null, SCREEN_SIZE_SMALL);
        String extraSmallClass = this.getCssClass(this.smallScreenConfiguration, this.phoneConfiguration, SCREEN_SIZE_EXTRA_SMALL);
        responsiveClassBuilder.append(defaultClass).append(CSS_CLASS_SEPARATOR).append(mediumClass).append(CSS_CLASS_SEPARATOR).append(smallClass).append(CSS_CLASS_SEPARATOR).append(extraSmallClass);
        return responsiveClassBuilder.toString();
    }

    private String getCssClass(BreakPointResponsiveConfiguration input, BreakPointResponsiveConfiguration fallback, String screenSize) {
        String fallbackWidth = null;
        String fallbackOffset = null;
        String fallbackBehavior = null;
        if (fallback != null) {
            fallbackWidth = fallback.getWidth();
            fallbackOffset = fallback.getOffset();
            fallbackBehavior = fallback.getBehavior();
        }
        String inputWidth = null;
        String inputOffset = null;
        String inputBehavior = null;
        if (input != null) {
            inputWidth = input.getWidth();
            inputOffset = input.getOffset();
            inputBehavior = input.getBehavior();
        }
        String width = this.getOrElse(inputWidth, fallbackWidth);
        String offset = this.getOrElse(inputOffset, fallbackOffset);
        String behavior = this.getOrElse(inputBehavior, fallbackBehavior);
        return this.getCssClass(screenSize, width, offset, behavior);
    }

    private String getCssClass(String screenSize, String width, String offset, String behavior) {
        StringBuilder cssClassBuilder = new StringBuilder();
        String cssScreenPrefix = CSS_CLASS_PREFIX + screenSize;
        if (width == null) {
            Integer widthValue = DEFAULT_WIDTH;
            if (offset != null) {
                try {
                    Integer offsetValue = Integer.parseInt(offset);
                    widthValue = widthValue - offsetValue;
                }
                catch (NumberFormatException nfe) {
                    logger.error("Ignoring offset: " + offset + ", as it can't be parsed as number : ", nfe);
                }
            }
            width = widthValue.toString();
        }
        cssClassBuilder.append(cssScreenPrefix).append(width);
        if (offset == null) {
            offset = DEFAULT_OFFSET;
        }
        cssClassBuilder.append(CSS_CLASS_SEPARATOR).append(cssScreenPrefix).append(OFFSET_PREFIX).append(offset);
        if (NEWLINE_BEHAVIOR.equals(behavior)) {
            cssClassBuilder.append(CSS_CLASS_SEPARATOR).append(CSS_FD_PREFIX).append(screenSize).append(NEWLINE_CLASS);
        }
        return cssClassBuilder.toString();
    }

    private String getOrElse(String inputValue, String fallbackValue) {
        String returnValue = null;
        if (StringUtils.isNotEmpty(inputValue)) {
            returnValue = inputValue;
        } else if (StringUtils.isNotEmpty(fallbackValue)) {
            returnValue = fallbackValue;
        }
        return returnValue;
    }
}

