/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.internal.impl.taglibs;

import com.adobe.aemds.guide.common.GuideLayoutContext;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import javax.script.SimpleBindings;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeBean
extends TagSupport {
    private static final Logger logger = LoggerFactory.getLogger(InitializeBean.class);
    private String name;
    private String className;
    private boolean restoreOnExit = false;
    private String resourcePath = null;
    private boolean manageFragmentContext = false;
    private boolean fragmentContextResetRequired = false;
    private GuideFragmentHolder guideFragmentHolderOriginal = null;
    private String guideContainerPathOriginal = null;
    private WCMMode modeOriginal = null;
    private GuideNode originalGuideNode = null;
    private GuideLayoutContext originalLayoutContext = null;

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isRestoreOnExit() {
        return this.restoreOnExit;
    }

    public void setRestoreOnExit(boolean restoreOnExit) {
        this.restoreOnExit = restoreOnExit;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public int doStartTag() throws JspException {
        this.originalLayoutContext = (GuideLayoutContext)this.pageContext.getAttribute("guideLayoutContext", 2);
        if (this.restoreOnExit) {
            this.originalGuideNode = (GuideNode)this.pageContext.getAttribute(this.name, 2);
        }
        GuideNode guidenode = null;
        SlingHttpServletRequest request = (SlingHttpServletRequest)this.pageContext.getAttribute("slingRequest");
        Resource resource = null;
        resource = this.resourcePath != null ? request.getResourceResolver().getResource(this.resourcePath) : (Resource)this.pageContext.getAttribute("resource");
        if (resource != null) {
            try {
                SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
                ClassLoader dynamicClassLoader = bindings.getSling().getService(DynamicClassLoaderManager.class).getDynamicClassLoader();
                guidenode = (GuideNode)dynamicClassLoader.loadClass(this.className).newInstance();
                if (this.manageFragmentContext) {
                    this.setFragmentContext(request, resource);
                }
                SimpleBindings BindingObj = new SimpleBindings();
                BindingObj.put("resource", (Object)resource);
                BindingObj.put("request", (Object)request);
                guidenode.init(BindingObj);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), ex);
                throw new JspException((Throwable)ex);
            }
        } else {
            logger.error("Not a valid Adaptive Form path");
            throw new GuideException("Not a valid Adaptive Form Path");
        }
        this.pageContext.setAttribute(this.name, (Object)guidenode, 2);
        this.pageContext.setAttribute("guideLayoutContext", (Object)new GuideLayoutContext(), 2);
        return 1;
    }

    public int doEndTag() throws JspException {
        this.reset(this.pageContext);
        return 6;
    }

    public void reset(PageContext pageContext) {
        pageContext.setAttribute("guideLayoutContext", (Object)this.originalLayoutContext, 2);
        if (this.restoreOnExit) {
            pageContext.setAttribute(this.name, (Object)this.originalGuideNode, 2);
        }
        if (this.fragmentContextResetRequired) {
            this.resetFragmentContext(pageContext.getRequest());
        }
        this.name = null;
        this.className = null;
        this.restoreOnExit = false;
        this.resourcePath = null;
        this.originalGuideNode = null;
        this.originalLayoutContext = null;
        this.guideFragmentHolderOriginal = null;
        this.fragmentContextResetRequired = false;
        this.manageFragmentContext = false;
        this.guideContainerPathOriginal = null;
        this.modeOriginal = null;
    }

    private void setFragmentContext(SlingHttpServletRequest slingRequest, Resource resource) {
        try {
            ValueMap valueMap = resource.getValueMap();
            String fragRef = valueMap.get("fragRef", "");
            String guideNodeClass = valueMap.get("guideNodeClass", "");
            if (fragRef.length() > 0 && guideNodeClass.equals("guidePanel")) {
                this.guideFragmentHolderOriginal = GuideContainerThreadLocal.getGuideFragmentHolder();
                this.guideContainerPathOriginal = GuideContainerThreadLocal.getGuideContainerPath();
                Resource fragRefContainer = slingRequest.getResourceResolver().getResource(GuideUtils.convertFMAssetPathToContainerPath(fragRef));
                if (fragRefContainer != null) {
                    String prevPrefixId = null;
                    if (this.guideFragmentHolderOriginal != null) {
                        prevPrefixId = this.guideFragmentHolderOriginal.getFragPrefixID();
                    }
                    String fragRefPrefix = prevPrefixId;
                    if (!fragRefContainer.getPath().equals(this.guideContainerPathOriginal)) {
                        fragRefPrefix = NodeStructureUtils.getFragPrefixString(resource, prevPrefixId);
                    }
                    I18n i18nFragment = GuideELUtils.getI18n(slingRequest, fragRefContainer);
                    GuideContainerThreadLocal.setGuideFragmentHolder(fragRefPrefix, null, null, i18nFragment);
                    GuideContainerThreadLocal.setGuideContainerPath(fragRefContainer.getPath());
                    this.modeOriginal = WCMMode.fromRequest(slingRequest);
                    WCMMode.DISABLED.toRequest(slingRequest);
                    this.fragmentContextResetRequired = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in settting guide Fragment context", e);
        }
    }

    private void resetFragmentContext(ServletRequest request) {
        this.modeOriginal.toRequest(request);
        GuideContainerThreadLocal.setGuideContainerPath(this.guideContainerPathOriginal);
        if (this.guideFragmentHolderOriginal != null) {
            GuideContainerThreadLocal.setGuideFragmentHolder(this.guideFragmentHolderOriginal.getFragPrefixID(), null, null, this.guideFragmentHolderOriginal.getI18n());
        } else {
            GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
        }
    }

    public void setManageFragmentContext(boolean manageFragmentContext) {
        this.manageFragmentContext = manageFragmentContext;
    }
}

