/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideValidationResult {
    private GuideSubmitErrorCause errorCausedBy;
    private List<GuideError> guideErrorList;
    private static Logger logger = LoggerFactory.getLogger(GuideValidationResult.class);

    public GuideValidationResult() {
    }

    public GuideValidationResult(List<GuideError> guideErrorList) {
        this(guideErrorList, GuideSubmitErrorCause.SERVER_SIDE_VALIDATION);
    }

    public GuideValidationResult(List<GuideError> guideErrorList, GuideSubmitErrorCause errorCausedBy) {
        this.guideErrorList = guideErrorList;
        this.errorCausedBy = errorCausedBy;
    }

    public List<GuideError> getGuideErrorList() {
        return this.guideErrorList;
    }

    public void setGuideErrorList(List<GuideError> guideErrorList) {
        this.setGuideErrorList(guideErrorList, GuideSubmitErrorCause.SERVER_SIDE_VALIDATION);
    }

    public void setGuideErrorList(List<GuideError> guideErrorList, GuideSubmitErrorCause errorCausedBy) {
        this.guideErrorList = guideErrorList;
        this.errorCausedBy = errorCausedBy;
    }

    public GuideSubmitErrorCause getErrorCause() {
        return this.errorCausedBy;
    }

    public boolean hasErrors() {
        return this.guideErrorList != null && this.guideErrorList.size() > 0;
    }

    public JSONObject getValidationPayload() {
        return this.getErrorJsonObject();
    }

    private JSONObject getErrorJsonObject() {
        JSONObject errorJson = new JSONObject();
        try {
            errorJson.put("errorCausedBy", (Object)this.errorCausedBy);
            errorJson.put("errors", this.getErrors(this.guideErrorList));
        }
        catch (JSONException e) {
            logger.error("Error while writing JSON.", e);
        }
        return errorJson;
    }

    private JSONArray getErrors(List<GuideError> errorList) {
        JSONArray errors = null;
        if (errorList != null) {
            errors = new JSONArray();
            for (GuideError guideError : errorList) {
                JSONObject object = new JSONObject();
                try {
                    object.putOpt("somExpression", guideError.getSomExpression());
                    object.putOpt("errorMessage", guideError.getErrorMessage());
                }
                catch (JSONException e) {
                    logger.error("Error while converting into JSON.", e);
                }
                errors.put(object);
            }
        }
        return errors;
    }
}

