/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class GuideTermsAndConditions
extends GuideField {
    @Override
    public String getStyles() {
        String style = super.getStyles();
        style = style + (this.getHeight().length() > 0 ? "max-height:none;" : "");
        return style;
    }

    public String getTncTextContent() {
        return this.externalize((String)((Object)this.resourceProps.get("tncTextContent", String.class)));
    }

    public List<String> getLinkText() {
        String[] arr = this.resourceProps.get("linkText", new String[0]);
        return Arrays.asList(arr);
    }

    public Boolean getShowLink() {
        return (Boolean)((Object)this.resourceProps.get("showLink", Boolean.class));
    }

    public Boolean getShowApprovalOption() {
        Boolean showAsPopUp = this.getShowAsPopUp();
        return showAsPopUp != false || this.resourceProps.get("showApprovalOption", false) != false;
    }

    public Boolean getShowAsPopUp() {
        return this.resourceProps.get("showAsPopUp", false);
    }

    public String getTncCheckBoxContent() {
        return this.externalize((String)((Object)this.resourceProps.get("tncCheckBoxContent", String.class)));
    }

    public String getAssistProperty() {
        return this.externalize((String)((Object)this.resourceProps.get("assistPriority", String.class)));
    }

    public String getScreenReaderText() {
        String screenReaderText = null;
        String assistPriority = this.getAssistProperty();
        if (assistPriority != null) {
            String customText;
            if ("label".equals(assistPriority)) {
                String title = (String)((Object)this.resourceProps.get("jcr:title", String.class));
                if (title != null) {
                    screenReaderText = title;
                }
            } else if ("custom".equals(assistPriority) && (customText = (String)((Object)this.resourceProps.get("custom", String.class))) != null) {
                screenReaderText = customText;
            }
        }
        return this.externalize(screenReaderText);
    }

    @Override
    public String getGuideFieldType() {
        return "guideTermsAndConditions";
    }

    @Override
    public boolean isMandatory() {
        String tncReviewStatusPath = "items/reviewStatus";
        Resource tncReviewStatusResource = this.getResource().getChild(tncReviewStatusPath);
        if (tncReviewStatusResource != null) {
            ValueMap reviewStatusProp = tncReviewStatusResource.adaptTo(ValueMap.class);
            return reviewStatusProp.get("mandatory", false);
        }
        return false;
    }
}

