/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import java.util.ArrayList;
import java.util.List;
import javax.script.SimpleBindings;

public class GuideTable
extends GuidePanel {
    public int getColumns(GuideNode row) {
        GuidePanel panel = new GuidePanel();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)this.slingRequest.getResourceResolver().getResource(row.getPath()));
        bindings.put("request", (Object)this.slingRequest);
        panel.init(bindings);
        return panel.getItems().size();
    }

    public ArrayList<Boolean> getSortingAllowedHeader() {
        List<GuideNode> elements = this.getItems();
        ArrayList<Boolean> sortableHeaderList = new ArrayList<Boolean>();
        int currColumn = 0;
        int totalColumns = this.getColumns();
        Boolean isSortingAllowed = "true".equals(this.isSortingEnabled());
        for (currColumn = 0; currColumn < totalColumns; ++currColumn) {
            sortableHeaderList.add(isSortingAllowed);
        }
        if (isSortingAllowed.booleanValue()) {
            try {
                for (GuideNode guideNode : elements) {
                    if (guideNode.getResourceType().equals("fd/ccm/web-channel/components/tableHeader/v1/tableHeader") || guideNode.getResourceType().equals("fd/af/components/tableHeader")) continue;
                    List<GuideNode> tableCellNode = this.getTableRowItems(guideNode);
                    for (currColumn = 0; currColumn < tableCellNode.size(); ++currColumn) {
                        String guideNodeClass;
                        if (!sortableHeaderList.get(currColumn).booleanValue() || !this.isTableCellPrimitiveComponent(guideNodeClass = tableCellNode.get(currColumn).getNodeClass()).booleanValue()) continue;
                        sortableHeaderList.set(currColumn, false);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error in updating tableHeader info", e);
            }
        }
        return sortableHeaderList;
    }

    private List<GuideNode> getTableRowItems(GuideNode row) {
        GuidePanel panel = new GuidePanel();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)row.getResource());
        bindings.put("request", (Object)this.slingRequest);
        panel.init(bindings);
        return panel.getItems();
    }

    private Boolean isTableCellPrimitiveComponent(String guideNodeClass) {
        return guideNodeClass != null && !guideNodeClass.equals("guideTextBox") && !guideNodeClass.equals("guideNumericBox") && !guideNodeClass.equals("guideDatePicker") && !guideNodeClass.equals("guideTextDraw");
    }

    public int getColumns() {
        List<GuideNode> elements = this.getItems();
        int max = -1;
        int size = elements.size();
        for (int j = 0; j < size; ++j) {
            GuideNode par = elements.get(j);
            int columns = this.getColumns(par);
            if (columns <= max) continue;
            max = columns;
        }
        return max;
    }

    public String getMobileLayout() {
        return this.resourceProps.get("./layout/mobileLayout", "");
    }

    public String getSummary() {
        return this.resourceProps.get("./tableSummaryText", "");
    }

    public String isSortingEnabled() {
        return this.resourceProps.get("./sortingEnabled", "false");
    }

    public String getColumnWidth() {
        return this.resourceProps.get("columnWidth", "");
    }
}

