/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.ArrayList;
import java.util.List;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class GuideItemsContainer
extends GuideNode {
    @Override
    public List<GuideNode> getItems() {
        String fragRef = this.getResource().adaptTo(ValueMap.class).get("fragRef", "");
        Resource items = null;
        if (fragRef.length() > 0) {
            GuidePanel fragRefRootPanel;
            fragRef = StringUtils.replace(fragRef, "/content/dam/formsanddocuments/", "/content/forms/af/", 1);
            fragRef = GuideUtils.convertFMAssetPathToContainerPath(fragRef);
            ResourceResolver resourceResolver = this.getResource().getResourceResolver();
            Resource fragRefContainer = resourceResolver.getResource(fragRef);
            if (fragRefContainer != null && (fragRefRootPanel = GuideUtils.getRootPanel(fragRefContainer, this.slingRequest)) != null) {
                Resource fragRefRootPanelResource = fragRefRootPanel.getResource();
                items = fragRefRootPanelResource.getChild("items");
            }
        } else {
            items = this.getResource().getChild("items");
        }
        ArrayList<GuideNode> panelItems = new ArrayList<GuideNode>();
        if (items != null) {
            for (Resource itemChild : items.getChildren()) {
                GuideNode newNode = null;
                String normalizedNodeType = GuideUtils.getNormalizedNodeType(itemChild.getResourceType(), itemChild.getResourceSuperType());
                newNode = itemChild.isResourceType("fd/af/components/panel") || itemChild.isResourceType("fd/ccm/web-channel/components/documentFragmentGroup/v1/documentFragmentGroup") ? new GuidePanel() : new GuideNode();
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("resource", (Object)itemChild);
                bindings.put("request", (Object)this.slingRequest);
                newNode.init(bindings);
                panelItems.add(newNode);
            }
        }
        return panelItems;
    }
}

