/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public abstract class GuideField
extends GuideNode {
    protected String helpQuestionMarkContent = "";
    private String displayNoneStyle = ";display:none";

    public Boolean getIsRequired() {
        return FormsHelper.isRequired(super.getResource());
    }

    public Boolean getIsReadOnly() {
        return FormsHelper.isReadOnly(this.slingRequest, super.getResource());
    }

    public String getLabelForId() throws RepositoryException {
        return this.getId() + "_widget";
    }

    public String getAutofillFieldKeyword() {
        return this.resourceProps.get("autofillFieldKeyword", "off");
    }

    public Boolean getAutocomplete() {
        return this.resourceProps.get("autocomplete", false);
    }

    public boolean getIsOldFieldLayout() {
        String fieldLayout = this.resourceProps.get("fieldLayout", "");
        if (fieldLayout != null && fieldLayout.length() > 0 && !fieldLayout.equals("/libs/fd/af/layouts/field/defaultFieldLayout/defaultFieldLayout.jsp")) {
            return this.checkIfPathIsAbsolute(fieldLayout);
        }
        return false;
    }

    public String getFieldLayout() {
        String fieldLayout = this.resourceProps.get("fieldLayout", "");
        if (fieldLayout != null && fieldLayout.length() > 0 && fieldLayout.indexOf("defaultFieldLayout") < 0) {
            return fieldLayout;
        }
        Resource guideContainerResource = this.getResource().getResourceResolver().getResource(GuideUtils.getGuideContainerPath(this.slingRequest, this.getResource()));
        return GuideUtils.getFieldLayout(guideContainerResource, "fieldLayout", "fd/af/layouts/field/defaultFieldLayout");
    }

    public String getFieldLayoutName() {
        String fieldLayout = this.getFieldLayout();
        String fieldLayoutName = "defaultFieldLayout";
        if (fieldLayout != null && fieldLayout.length() > 0) {
            fieldLayoutName = StringUtils.substringAfterLast(fieldLayout, "/");
            fieldLayoutName = StringUtils.substringBeforeLast(fieldLayoutName, ".jsp");
        }
        return fieldLayoutName;
    }

    public boolean getHideTitle() {
        return this.resourceProps.get("hideTitle", false);
    }

    public String getShortDescription() {
        return this.externalize(this.resourceProps.get("shortDescription", ""));
    }

    public String getLongDescription() {
        return this.externalize(this.resourceProps.get("longDescription", ""));
    }

    public Boolean getDescriptionVisibility() {
        return this.resourceProps.get("shortVisible", false);
    }

    public String getValue() {
        return (String)((Object)this.resourceProps.get("_value", String.class));
    }

    public String getCaptionInlineStyles() {
        if (this.getHideTitle()) {
            return this.getInlineStyles("Caption") + this.displayNoneStyle;
        }
        return this.getInlineStyles("Caption");
    }

    public String getWidgetInlineStyles() {
        return this.getInlineStyles("Widget");
    }

    public void setHelpIndicatorContent(String helpQuestionMarkContent) {
        this.helpQuestionMarkContent = helpQuestionMarkContent != null ? helpQuestionMarkContent : "";
    }

    public String getHelpIndicatorContent() {
        return this.helpQuestionMarkContent;
    }

    public String getShortDescriptionInlineStyles() {
        if (this.getDescriptionVisibility().booleanValue()) {
            return this.getInlineStyles("ShortDescription");
        }
        return this.getInlineStyles("ShortDescription") + this.displayNoneStyle;
    }

    public String getPlaceholderText() {
        return this.resourceProps.get("placeholderText", "");
    }

    public String getErrorSimulatorString() {
        String validatePictureClauseMessage;
        String mandatoryMessageAttribute = null;
        if (this.isMandatory()) {
            String mandatoryMessage = (String)((Object)this.resourceProps.get("mandatoryMessage", String.class));
            mandatoryMessageAttribute = mandatoryMessage != null && !mandatoryMessage.isEmpty() ? mandatoryMessage : "There is an error in this field !";
        } else {
            String validateExpMessage = (String)((Object)this.resourceProps.get("validateExpMessage", String.class));
            if (validateExpMessage != null && !validateExpMessage.isEmpty()) {
                mandatoryMessageAttribute = validateExpMessage;
            }
        }
        if (mandatoryMessageAttribute != null && (validatePictureClauseMessage = (String)((Object)this.resourceProps.get("validatePictureClauseMessage", String.class))) != null) {
            mandatoryMessageAttribute = validatePictureClauseMessage;
        }
        return mandatoryMessageAttribute;
    }

    public boolean isMandatory() {
        return this.resourceProps.get("mandatory", false);
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        Boolean hideTitle = this.getHideTitle();
        if (hideTitle.booleanValue()) {
            authoringConfig.put("hideTitle", hideTitle);
        }
        GuideUtils.setMasterAuthoringConfig(authoringConfig, this.resourceProps);
        return authoringConfig;
    }
}

