/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.service.GuideException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideDatePicker
extends GuideField {
    protected Logger logger = LoggerFactory.getLogger(GuideDatePicker.class);

    @Override
    public String getGuideFieldType() {
        return "guideDatePicker";
    }

    public String getDateInputOptions() {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter(jsonStringWriter);
        try {
            writer.object();
            writer.key("dateFormat").value(this.resourceProps.get("dateDisplayFormat", "date{M/D/YYYY}"));
            writer.key("placeholderMonth").value(this.externalize(this.resourceProps.get("placeholderMonth", "")));
            writer.key("placeholderDay").value(this.externalize(this.resourceProps.get("placeholderDay", "")));
            writer.key("placeholderYear").value(this.externalize(this.resourceProps.get("placeholderYear", "")));
            writer.key("labelMonth").value(this.externalize(this.resourceProps.get("titleMonth", "")));
            writer.key("labelDay").value(this.externalize(this.resourceProps.get("titleDay", "")));
            writer.key("labelYear").value(this.externalize(this.resourceProps.get("titleYear", "")));
            writer.key("hideLabels").value(this.checkIfDateInputTitleHidden());
            writer.endObject();
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
        return jsonStringWriter.toString();
    }

    public Boolean checkIfDateInputTitleHidden() {
        return this.resourceProps.get("hideTitleDate", false);
    }

    public String getHeightOfDiv() {
        if (!this.checkIfDateInputTitleHidden().booleanValue()) {
            return "showDateInputLabels";
        }
        return "";
    }

    public Boolean isMaxDateExcluded() {
        return this.resourceProps.get("exclusiveMaximum", false);
    }

    public Boolean isMinDateExcluded() {
        return this.resourceProps.get("exclusiveMinimum", false);
    }

    public String getMaximumDate() {
        String maxDateInString = this.resourceProps.get("maximum", "");
        if (!maxDateInString.isEmpty() && this.isMaxDateExcluded().booleanValue()) {
            Date maxDate = this.convertStringToDate(maxDateInString);
            maxDate = this.addDaysToDate(maxDate, -1);
            maxDateInString = this.convertDateToString(maxDate);
        }
        return maxDateInString;
    }

    public String getMinimumDate() {
        String minDateInString = this.resourceProps.get("minimum", "");
        if (!minDateInString.isEmpty() && this.isMinDateExcluded().booleanValue()) {
            Date minDate = this.convertStringToDate(minDateInString);
            minDate = this.addDaysToDate(minDate, 1);
            minDateInString = this.convertDateToString(minDate);
        }
        return minDateInString;
    }

    private Date convertStringToDate(String dateInString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = formatter.parse(dateInString);
        }
        catch (ParseException e) {
            this.logger.error("Error in converting date picker string to date" + e.getMessage());
        }
        return date;
    }

    private String convertDateToString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateInString = formatter.format(date);
        return dateInString;
    }

    private Date addDaysToDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }
}

