/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.transaction.core.exception;

import java.util.ResourceBundle;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class TransactionException
extends Exception {
    private static final long serialVersionUID = 1500623108187528483L;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("exceptions");
    private String errorCode;
    private String unresolvedMessage;
    private Object[] arguments;
    private String message;

    public TransactionException(String errorCode, String[] args) {
        this.errorCode = errorCode;
        this.arguments = args;
        this.unresolvedMessage = resourceBundle.getString(errorCode);
        this.message = this.arguments == null ? this.unresolvedMessage : this.replaceString(this.unresolvedMessage, args);
    }

    private String replaceString(String message, String[] args) {
        String formattedMessage = message;
        if (args != null) {
            FormattingTuple s = MessageFormatter.arrayFormat(message, args);
            formattedMessage = s.getMessage();
        }
        return formattedMessage;
    }

    public TransactionException(String message, Throwable cause) {
        super(message, cause);
    }

    public TransactionException(String message) {
        super(message);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (this.errorCode != null) {
            return this.errorCode + ": " + this.message;
        }
        return super.getMessage();
    }
}

