/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.util;

import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aem.formsndocuments.util.TemplateUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.Rendition;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.policies.ContentPolicy;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMUtils {
    private static final Logger log = LoggerFactory.getLogger(FMUtils.class);

    public static Node getMetadataNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node metadataNode = null;
            Node contentNode = FMUtils.getContentNode(formNode, create);
            if (contentNode != null) {
                if (!contentNode.hasNode("metadata")) {
                    if (create) {
                        metadataNode = contentNode.addNode("metadata", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    }
                } else {
                    metadataNode = contentNode.getNode("metadata");
                }
            }
            return metadataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getMetadataNode(Session session, String formPath, boolean create) throws FormsMgrException {
        try {
            Node metadataNode = null;
            if (session != null) {
                Node formNode = session.getNode(FMUtils.getAssetPathFromPage(formPath));
                metadataNode = FMUtils.getMetadataNode(formNode, create);
            }
            return metadataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getAnalyticsDataNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node analyticsDataNode = null;
            Node contentNode = FMUtils.getContentNode(formNode, create);
            if (contentNode != null) {
                if (!contentNode.hasNode("analyticsdatanode")) {
                    if (create) {
                        analyticsDataNode = contentNode.addNode("analyticsdatanode", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    }
                } else {
                    analyticsDataNode = contentNode.getNode("analyticsdatanode");
                }
            }
            return analyticsDataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getContentNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node contentNode = null;
            if (!formNode.hasNode("jcr:content")) {
                if (create) {
                    contentNode = formNode.addNode("jcr:content", "dam:AssetContent");
                }
            } else {
                contentNode = formNode.getNode("jcr:content");
            }
            return contentNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean isFolder(Session session, String path) throws FormsMgrException {
        boolean isFolderNode = false;
        if (session != null) {
            try {
                Property prop;
                Node folderNode = null;
                folderNode = session.getNode(path);
                if (folderNode.isNodeType("sling:Folder") && folderNode.hasProperty("lcFolder") && (prop = folderNode.getProperty("lcFolder")).getLong() == (long)FMConstants.FOLDER_STATE.VALID.ordinal()) {
                    isFolderNode = true;
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isFolderNode;
    }

    public static boolean isApplication(Session session, String path) throws FormsMgrException {
        boolean isApplicationNode = false;
        if (session != null) {
            try {
                Property prop;
                Node applicationNode = null;
                applicationNode = session.getNode(path);
                if (applicationNode.hasProperty("lcApplication") && (prop = applicationNode.getProperty("lcApplication")).getLong() == (long)FMConstants.APPLICATION_STATE.VALID.ordinal()) {
                    isApplicationNode = true;
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isApplicationNode;
    }

    public static boolean isXDPForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("xfaForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isResource(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("lcResource"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isGuide(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("guide"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isPDFForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("pdfForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isPrintForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("printForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isFormset(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("formset"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isAFFragment(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("affragment"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isAdaptiveDocument(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("adaptivedocument"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isTheme(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("theme"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isThemeClientLib(Node assetNode) throws FormsMgrException {
        try {
            return assetNode.isNodeType("cq:ClientLibraryFolder") && assetNode.hasProperty("guideComponentType") && "fd/af/components/guideThemeClientLib".equals(assetNode.getProperty("guideComponentType").getString());
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public static boolean isFDM(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, "type", "formdatamodel");
    }

    public static boolean isMultichannelDocument(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, "type", "mcdocument");
    }

    public static boolean isDocumentChannel(@Nonnull ResourceResolver resourceResolver, String path) {
        Resource contentResource;
        Resource channelResource = resourceResolver.getResource(path);
        return channelResource != null && (contentResource = channelResource.getChild("jcr:content")) != null && contentResource.getValueMap().containsKey("fd:channelType");
    }

    public static String getDocumentPagePath(String channelPath) {
        String documentPath = "";
        if (StringUtils.isNotEmpty(channelPath)) {
            documentPath = Text.getRelativeParent(channelPath, 2);
        }
        return documentPath;
    }

    private static boolean isValidAssetType(Session session, String path, String propertyName, String value) throws FormsMgrException {
        boolean isValid = false;
        if (session != null) {
            try {
                Property prop;
                Node contentNode;
                String primaryType;
                Node assetNode = null;
                assetNode = session.getNode(path);
                if (assetNode != null && (primaryType = assetNode.getPrimaryNodeType().getName()).equals("dam:Asset") && (contentNode = FMUtils.getContentNode(assetNode, false)) != null && contentNode.hasProperty(propertyName) && (prop = contentNode.getProperty(propertyName)).getString().equals(value)) {
                    isValid = true;
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isValid;
    }

    private static boolean isValidAssetType(Session session, String path, List<String> assetTypes, long validValue) throws FormsMgrException {
        if (session != null) {
            try {
                Node assetNode = null;
                assetNode = session.getNode(path);
                if (assetNode == null) {
                    return false;
                }
                String primaryType = assetNode.getPrimaryNodeType().getName();
                if (primaryType.equals("dam:Asset")) {
                    Node contentNode = FMUtils.getContentNode(assetNode, false);
                    if (contentNode == null) {
                        return false;
                    }
                    for (String assetType : assetTypes) {
                        Property prop;
                        if (!contentNode.hasProperty(assetType) || (prop = contentNode.getProperty(assetType)).getLong() != validValue) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                throw FMUtils.getFormsMgrException(e);
            }
        }
        return false;
    }

    public static boolean isXFABasedForm(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("formmodel") && metadataNode.getProperty("formmodel").getString().equals("formtemplates");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasDORTemplate(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null && metadataNode.hasProperty("dorType")) {
                return "select".equals(metadataNode.getProperty("dorType").getString()) && metadataNode.hasProperty("dorTemplateRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasMetaTemplate(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && FMUtils.isGuide(session, path) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("metaTemplateRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasXSDRef(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("xsdRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasSchemaRef(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("schemaRef");
            }
            return false;
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public static boolean hasProperty(Session session, String path, String propertyName) throws FormsMgrException {
        try {
            if (session.nodeExists(path)) {
                Node node = session.getNode(path);
                return node != null && node.hasProperty(propertyName);
            }
            return false;
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public static Property getNodeProperty(String propertyName, Node node) throws FormsMgrException {
        try {
            Property property;
            if (node.hasProperty(propertyName) && (property = node.getProperty(propertyName)) != null) {
                return property;
            }
            return null;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getXDPRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("xdpRef")) {
                return guideContainerNode.getProperty("xdpRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getDORRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("dorTemplateRef")) {
                return guideContainerNode.getProperty("dorTemplateRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getMetaTemplateRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.nodeExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("metaTemplateRef")) {
                return guideContainerNode.getProperty("metaTemplateRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getXSDRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("xsdRef")) {
                return guideContainerNode.getProperty("xsdRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getSchemaRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-011", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("schemaRef")) {
                return guideContainerNode.getProperty("schemaRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-012", new String[]{guidePath});
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public static Map<String, String> createGuideRenderURL(Node guideNode, String sampleDataId, Session session) throws FormsMgrException {
        try {
            HashMap<String, String> renderUrlMap = new HashMap<String, String>();
            String cqPagePath = FMUtils.getPagePathFromAsset(guideNode.getPath());
            if (!session.nodeExists(cqPagePath)) {
                throw new FormsMgrException("CQ Page corresponding to Guide Node does not exists");
            }
            renderUrlMap.put("formUrl", cqPagePath + ".html");
            String completeDataUrl = FMUtils.createDataUrl(sampleDataId, session);
            renderUrlMap.put("dataRef", completeDataUrl);
            return renderUrlMap;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Map<String, String> createMulichannelDocumentRenderURL(Node assetNode, String sampleDataId, Session session, String channelType) throws FormsMgrException {
        try {
            HashMap<String, String> renderUrlMap = new HashMap<String, String>();
            String cqPagePath = FMUtils.getPagePathFromAsset(assetNode.getPath());
            if (!session.nodeExists(cqPagePath)) {
                throw new FormsMgrException("CQ Page corresponding to Guide Node does not exists");
            }
            StringBuilder formUrl = new StringBuilder(cqPagePath);
            formUrl.append("/").append("channels").append("/").append(channelType);
            if ("print".equals(channelType)) {
                formUrl.append(".pdf");
            } else if ("web".equals(channelType)) {
                formUrl.append(".html");
            } else {
                throw new FormsMgrException(new IllegalArgumentException("Unsupported channel type=" + channelType));
            }
            renderUrlMap.put("formUrl", formUrl.toString());
            String completeDataUrl = FMUtils.createDataUrl(sampleDataId, session);
            renderUrlMap.put("dataRef", completeDataUrl);
            return renderUrlMap;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Map<String, String> createFormsetRenderURLParams(Node formNode, String type, String submitUrl, String profile, String sampleDataId, Session session) throws FormsMgrException {
        try {
            HashMap<String, String> renderUrlMap = new HashMap<String, String>();
            Node metadataNode = FMUtils.getMetadataNode(formNode, false);
            if (profile == null || profile.trim().equals("")) {
                profile = metadataNode != null && metadataNode.hasProperty("profile") ? metadataNode.getProperty("profile").getString() : "/content/forms/formsets/profiles/default";
            }
            if (submitUrl == null) {
                submitUrl = metadataNode != null && metadataNode.hasProperty("submitUrl") ? metadataNode.getProperty("submitUrl").getString() : null;
            }
            String templateName = null;
            String contentRoot = null;
            String formsetPath = null;
            String contentUri = formNode.getPath();
            if (contentUri == null) {
                throw new FormsMgrException("Failed to render form. Null ContentRootURI.");
            }
            int index = contentUri.lastIndexOf("/");
            templateName = contentUri.substring(index + 1);
            contentRoot = contentUri.substring(0, index);
            formsetPath = contentRoot + "/" + templateName;
            String completeDataUrl = FMUtils.createDataUrl(sampleDataId, session);
            String formUrl = profile + "." + type;
            renderUrlMap.put("formUrl", formUrl);
            renderUrlMap.put("formsetPath", formsetPath);
            renderUrlMap.put("dataRef", completeDataUrl);
            renderUrlMap.put("submitUrl", submitUrl);
            return renderUrlMap;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private static String createDataUrl(String dataId, Session session) throws FormsMgrException {
        String dataUrl = null;
        String urlPrefix = "crx://";
        if (dataId != null && dataId.trim().length() > 0 && !dataId.contains("://") && !dataId.trim().equals("None")) {
            dataUrl = FMUtils.getSampleDataPath(dataId, session);
        }
        String completeDataUrl = null;
        completeDataUrl = dataUrl != null && !dataUrl.trim().equals("") ? urlPrefix + dataUrl : (dataId != null && !dataId.trim().equals("") && dataId.contains("://") ? dataId : "");
        return completeDataUrl;
    }

    private static String getSampleDataPath(String fileId, Session session) throws FormsMgrException {
        try {
            String fileName = "tempArchive_" + fileId;
            String tempArchiveLocation = "/tmp/fd/fm/upload/" + fileName;
            Node tempNode = null;
            if (!session.nodeExists(tempArchiveLocation)) {
                log.error("temp node doesn't exist " + tempArchiveLocation);
                return null;
            }
            tempNode = session.getNode(tempArchiveLocation);
            return tempNode.getPath();
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean isForm(FMConstants.CoreAssetType assetType) {
        return assetType == FMConstants.CoreAssetType.FORM || assetType == FMConstants.CoreAssetType.PDFFORM || assetType == FMConstants.CoreAssetType.PRINTFORM;
    }

    public static String getFormType(FMConstants.CoreAssetType assetType) {
        if (FMConstants.CoreAssetType.FORM == assetType) {
            return "xfaForm";
        }
        if (FMConstants.CoreAssetType.PDFFORM == assetType) {
            return "pdfForm";
        }
        if (FMConstants.CoreAssetType.PRINTFORM == assetType) {
            return "printForm";
        }
        throw new RuntimeException("Invalid form type");
    }

    public static void deleteTempArchives(Session session) throws FormsMgrException {
        block14: {
            String tempStoragePath = "/tmp/fd/fm";
            try {
                if (!session.nodeExists(tempStoragePath)) break block14;
                Node tempStorageNode = session.getNode(tempStoragePath);
                ArrayList<Node> folderList = new ArrayList<Node>();
                NodeIterator iterator = tempStorageNode.getNodes();
                while (iterator.hasNext()) {
                    Node node = iterator.nextNode();
                    if (node.isNodeType("sling:Folder")) {
                        folderList.add(node);
                        continue;
                    }
                    log.info("Temp file found at unexpected location: " + node.getPath() + ". This file will not be cleaned as it is not present in a folder.");
                }
                for (Node tempStorageFolder : folderList) {
                    NodeIterator iter = tempStorageFolder.getNodes();
                    if (iter != null) {
                        int i = 0;
                        while ((long)i < iter.getSize()) {
                            Node node = iter.nextNode();
                            if (node.hasProperty("jcr:created")) {
                                long creationTime;
                                Calendar cal = Calendar.getInstance();
                                long currentTime = cal.getTime().getTime();
                                if (currentTime - (creationTime = node.getProperty("jcr:created").getDate().getTime().getTime()) > 1800000L) {
                                    log.info("Deleting temp archive : " + node.getPath());
                                    node.remove();
                                    session.save();
                                }
                            } else {
                                long currentTime = System.nanoTime();
                                String name = node.getName();
                                if (name.startsWith("tempArchive_")) {
                                    String creationTimeString = name.substring("tempArchive".length() + 1);
                                    try {
                                        Long creationTime = Long.parseLong(creationTimeString);
                                        if (currentTime - creationTime > 1800000000000L) {
                                            log.info("Deleting temp archive without mixin : " + node.getPath());
                                            node.remove();
                                            session.save();
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        log.warn(node.getName() + " does not have a valid system time name. Failed to delete", e);
                                    }
                                }
                            }
                            ++i;
                        }
                        continue;
                    }
                    log.info("No Temp Archive files.");
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
    }

    public static ResourceResolver getResourceResolver(ResourceResolverFactory resourceResolverFactory, Session session) throws FormsMgrException {
        try {
            HashMap<String, Object> authInfo = new HashMap<String, Object>();
            authInfo.put("user.jcr.session", session);
            return resourceResolverFactory.getResourceResolver(authInfo);
        }
        catch (LoginException e) {
            throw new FormsMgrException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRequestStatusSuccess(SlingHttpServletResponse resp, boolean isIE) throws IOException, JSONException {
        try (PrintWriter writer = null;){
            writer = resp.getWriter();
            JSONObject successJson = new JSONObject();
            successJson.put("requestStatus", "success");
            if (isIE) {
                resp.setContentType("text/html;charset=utf-8");
                writer.write("<textarea>");
            }
            writer.write(successJson.toString());
            if (isIE) {
                writer.write("</textarea>");
            }
        }
    }

    public static Node getFolderNode(Session session, String rootNodePath, boolean create, String folderType) throws FormsMgrException {
        try {
            Node workspaceRootNode;
            Node workingNode = null;
            if (session.nodeExists(rootNodePath)) {
                return session.getNode(rootNodePath);
            }
            if (!create) {
                throw new FormsMgrException("Node " + rootNodePath + " does not exist. Please check logs for more detail.");
            }
            String[] pathElems = rootNodePath.split("/");
            Node parentNode = workspaceRootNode = session.getRootNode();
            String rootPath = rootNodePath;
            if (rootPath.endsWith("/")) {
                rootPath = rootPath.substring(0, rootPath.length() - 1);
            }
            for (String path : pathElems) {
                if (path.equals("")) continue;
                workingNode = !parentNode.hasNode(path) ? parentNode.addNode(path, folderType) : parentNode.getNode(path);
                parentNode = workingNode;
            }
            return workingNode;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getPagePathFromAsset(String assetPath) {
        return assetPath.replace("/content/dam/formsanddocuments", "/content/forms/af");
    }

    public static String getAssetPathFromPage(String pagePath) {
        return pagePath.replace("/content/forms/af", "/content/dam/formsanddocuments");
    }

    public static Resource getClosestNodeUpInHierarchy(ResourceResolver resolver, String path, String inputPropertyName, String inputPropertyValue, boolean includeCurrentNode) throws FormsMgrException {
        try {
            if (resolver == null || path == null || path.isEmpty() || inputPropertyName == null || inputPropertyName.isEmpty() || inputPropertyValue == null || inputPropertyValue.isEmpty()) {
                throw new FormsMgrException("AEM-FMG-700-001");
            }
            Resource res = resolver.getResource(path);
            String propeVal = null;
            ValueMap map = null;
            if (res != null && !includeCurrentNode) {
                res = res.getParent();
            }
            while (res != null && !inputPropertyValue.equals(propeVal = (String)(map = res.getValueMap()).get(inputPropertyName))) {
                res = res.getParent();
            }
            return res;
        }
        catch (FormsMgrException e) {
            log.error("exception while finding node in getClosestNodeUpInHierarchy() : " + e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception while finding node in getClosestNodeUpInHierarchy() : " + e);
            throw new FormsMgrException(e);
        }
    }

    public static long getLastModifiedOrCreated(Session session, String assetPath) throws FormsMgrException {
        try {
            String originalPath = assetPath;
            if (originalPath.startsWith("/content/forms/af") && !session.nodeExists(assetPath = FMUtils.getAssetPathFromPage(originalPath))) {
                assetPath = originalPath;
                log.debug(assetPath + "does not exist");
            }
            Property lastUpdateProperty = null;
            Node assetNode = session.getNode(assetPath);
            Node contentNode = FMUtils.getContentNode(assetNode, false);
            if (assetNode.isNodeType("cq:Template")) {
                return -1L;
            }
            if (assetNode.isNodeType("cq:ClientLibraryFolder")) {
                return -1L;
            }
            if (assetNode.hasProperty("sling:resourceType") && "wcm/core/components/policy/policy".equals(assetNode.getProperty("sling:resourceType").getString())) {
                return -1L;
            }
            if (contentNode != null && contentNode.hasProperty("jcr:lastModified")) {
                lastUpdateProperty = contentNode.getProperty("jcr:lastModified");
            } else if (contentNode != null && contentNode.hasProperty("jcr:created")) {
                lastUpdateProperty = contentNode.getProperty("jcr:created");
            } else if (assetNode.hasProperty("jcr:lastModified")) {
                lastUpdateProperty = assetNode.getProperty("jcr:lastModified");
            }
            if (lastUpdateProperty == null) {
                return -1L;
            }
            return lastUpdateProperty.getDate().getTimeInMillis();
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getNameFromPath(String path) throws FormsMgrException {
        String name = null;
        int nameStartIndex = path.lastIndexOf("/");
        if (nameStartIndex < 0 || nameStartIndex >= path.length() - 1) {
            throw new FormsMgrException("Invalid asset path: " + path);
        }
        name = path.substring(nameStartIndex + 1);
        return name;
    }

    public static FMConstants.CoreAssetType getAssetType(Session session, String nodePath) throws FormsMgrException {
        if (session != null) {
            try {
                if (!session.nodeExists(nodePath)) {
                    Object[] args = new Object[]{nodePath};
                    throw new FormsMgrException("AEM-FMG-700-002", args);
                }
                if (FMUtils.isXDPForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.FORM;
                }
                if (FMUtils.isPDFForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.PDFFORM;
                }
                if (FMUtils.isPrintForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.PRINTFORM;
                }
                if (FMUtils.isFolder(session, nodePath) || FMUtils.isApplication(session, nodePath)) {
                    return FMConstants.CoreAssetType.FOLDER;
                }
                if (FMUtils.isResource(session, nodePath)) {
                    return FMConstants.CoreAssetType.RESOURCE;
                }
                if (FMUtils.isGuide(session, nodePath)) {
                    return FMConstants.CoreAssetType.GUIDE;
                }
                if (FMUtils.isFormset(session, nodePath)) {
                    return FMConstants.CoreAssetType.FORMSET;
                }
                if (FMUtils.isAFFragment(session, nodePath)) {
                    return FMConstants.CoreAssetType.AFFRAGMENT;
                }
                if (FMUtils.isAdaptiveDocument(session, nodePath)) {
                    return FMConstants.CoreAssetType.ADAPTIVEDOCUMENT;
                }
                if (FMUtils.isTheme(session, nodePath)) {
                    return FMConstants.CoreAssetType.THEME;
                }
                if (FMUtils.isFDM(session, nodePath)) {
                    return FMConstants.CoreAssetType.FORMDATAMODEL;
                }
                if (FMUtils.isMultichannelDocument(session, nodePath)) {
                    return FMConstants.CoreAssetType.DOCUMENT_TEMPLATE;
                }
                return FMConstants.CoreAssetType.NONFMASSET;
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        log.error("Unable to get a JCR session");
        throw new FormsMgrException("Invalid session object.");
    }

    public static FormsMgrException getFormsMgrException(Exception e) {
        if (e instanceof FormsMgrException) {
            return (FormsMgrException)e;
        }
        return new FormsMgrException(e);
    }

    public static void unscheduleJob(JobManager jobManager, String formPath, String replicationAtribute) {
        Collection<ScheduledJobInfo> scheduledJobs = jobManager.getScheduledJobs();
        for (ScheduledJobInfo eachJob : scheduledJobs) {
            Map<String, Object> eachJobProps = eachJob.getJobProperties();
            if (!eachJob.getJobTopic().equals("com/adobe/aem/formsndocuments/scheduler/formreplication") || !eachJobProps.get("event.form.path").equals(formPath) || !eachJobProps.get("event.replication.attribute").equals(replicationAtribute)) continue;
            eachJob.unschedule();
            break;
        }
    }

    public static String getRootLevelAssetType(Session session, String assetPath) throws RepositoryException {
        if (assetPath != null && assetPath.startsWith("/content/dam/formsanddocuments")) {
            int endIndex = assetPath.indexOf("/", "/content/dam/formsanddocuments".length() + 1);
            if (endIndex > 0) {
                assetPath = assetPath.substring(0, endIndex);
            }
            if (session.nodeExists(assetPath)) {
                Node rootFolderNode = session.getNode(assetPath);
                if (rootFolderNode.hasProperty("lcApplication")) {
                    return "lcApplication";
                }
                if (rootFolderNode.hasProperty("lcFolder")) {
                    return "lcFolder";
                }
                if (rootFolderNode.hasProperty("xfaForm")) {
                    return "xfaForm";
                }
                if (rootFolderNode.hasProperty("pdfForm")) {
                    return "pdfForm";
                }
                if (rootFolderNode.hasProperty("printForm")) {
                    return "printForm";
                }
                if (rootFolderNode.hasProperty("lcResource")) {
                    return "lcResource";
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream oInpStream) throws IOException {
        byte[] result = new byte[]{};
        if (oInpStream == null) {
            return result;
        }
        BufferedInputStream oStream = new BufferedInputStream(oInpStream);
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        int nRead = 0;
        int nBlkSize = 32768;
        byte[] buffer = new byte[nBlkSize];
        try {
            while ((nRead = oStream.read(buffer, 0, nBlkSize)) != -1) {
                oBAOS.write(buffer, 0, nRead);
            }
            result = oBAOS.toByteArray();
        }
        catch (IOException e) {
            log.debug("Error while generating a byte array from input stream.", e);
        }
        finally {
            try {
                if (oStream != null) {
                    oStream.close();
                }
                if (oBAOS != null) {
                    oBAOS.close();
                }
                if (oInpStream != null) {
                    oInpStream.close();
                }
            }
            catch (IOException e) {
                log.debug("Error while attempting to close input/output stream.", e);
            }
        }
        return result;
    }

    public static Session getFnDServiceUserSession(SlingRepository repository) throws RepositoryException {
        Session session = repository.loginService(null, null);
        return session;
    }

    public static ResourceResolver getFnDServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory) throws LoginException {
        ResourceResolver resourceResolver = resourceResolverFactory.getServiceResourceResolver(null);
        return resourceResolver;
    }

    public static JSONObject convertSetOfFormInfoToJSONObject(Set<AssetInfo> formInfoList) throws FormsMgrException {
        try {
            JSONObject rootJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (AssetInfo formInfo : formInfoList) {
                JSONObject formInfoJSON = new JSONObject();
                Resource resource = formInfo.getResource();
                if (resource != null) {
                    Session session = resource.getResourceResolver().adaptTo(Session.class);
                    String title = FMUtils.getResourceTitle(resource);
                    if (title != null && !title.isEmpty()) {
                        formInfoJSON.put("name", title);
                    } else {
                        formInfoJSON.put("name", resource.getName());
                    }
                    formInfoJSON.put("type", formInfo.getPublishAssetType());
                    formInfoJSON.put("path", resource.getPath());
                    ReplicationStatus replStatus = resource.adaptTo(ReplicationStatus.class);
                    long lastModified = FMUtils.getLastModifiedOrCreated(session, resource.getPath());
                    formInfoJSON.put("lastModified", lastModified);
                    if (replStatus != null) {
                        boolean published = replStatus.isDelivered() || replStatus.isActivated();
                        formInfoJSON.put("published", published);
                        if (published) {
                            long lastPublished = replStatus.getLastPublished().getTimeInMillis();
                            formInfoJSON.put("lastPublished", lastPublished);
                            boolean outdated = lastModified < 0L || lastPublished < lastModified;
                            formInfoJSON.put("outdated", outdated);
                            formInfoJSON.put("status", outdated ? "outdated" : "not available");
                        }
                    }
                    formInfoJSON.put("disabled", !FMUtils.canReplicate(resource.getPath(), session));
                }
                jsonArray.put(formInfoJSON);
            }
            rootJson.put("assets", jsonArray);
            return rootJson;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean canReplicate(String path, Session session) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
    }

    public static void prepareJsonToCreateDAMAsset(ResourceResolver resourceResolver, JSONObject inOutAssetJSON, FMConstants.CoreAssetType assetType, String formPath, String formName) throws FormsMgrException {
        if (resourceResolver == null || inOutAssetJSON == null || formPath == null || formName == null) {
            log.error("invalid input parametrs in prepareJsonToCreateDAMAsset()");
            throw new FormsMgrException("AEM-FMG-700-001");
        }
        try {
            String[] tags;
            formName = formName.replaceAll("[^a-zA-Z0-9_-]", "-");
            Session session = resourceResolver.adaptTo(Session.class);
            if (!session.nodeExists(formPath)) {
                log.error("DAM Asset to be created at non existant path : " + formPath);
                Object[] args = new Object[]{formPath};
                throw new FormsMgrException("AEM-FMG-700-002", args);
            }
            String assetPath = ResourceUtil.normalize(formPath + "/" + formName);
            inOutAssetJSON.put("path", assetPath);
            JSONObject assetJcrProperties = new JSONObject();
            switch (assetType) {
                case GUIDE: {
                    inOutAssetJSON.put("assetType", "guide");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/af/render");
                    break;
                }
                case AFFRAGMENT: {
                    inOutAssetJSON.put("assetType", "affragment");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/af/render");
                    break;
                }
                case FORMSET: {
                    inOutAssetJSON.put("assetType", "formset");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/formset/render");
                    break;
                }
                case DOCUMENT_TEMPLATE: {
                    inOutAssetJSON.put("assetType", "mcdocument");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/mcdocument/render");
                }
            }
            inOutAssetJSON.put("assetJcrProperties", assetJcrProperties);
            JSONObject metaDataProperties = inOutAssetJSON.getJSONObject("metadataProperties");
            metaDataProperties.put("allowedRenderFormat", "HTML");
            metaDataProperties.put("author", resourceResolver.getUserID());
            metaDataProperties.put("jcr:primaryType", "nt:unstructured");
            if (!metaDataProperties.has("title") || metaDataProperties.getString("title").isEmpty()) {
                metaDataProperties.put("title", formName);
            }
            if (metaDataProperties.has("xdpRef") && metaDataProperties.getString("xdpRef").isEmpty()) {
                metaDataProperties.remove("xdpRef");
            }
            if (metaDataProperties.has("xsdRef") && metaDataProperties.getString("xsdRef").isEmpty()) {
                metaDataProperties.remove("xsdRef");
            }
            if (metaDataProperties.has("schemaRef") && metaDataProperties.getString("schemaRef").isEmpty()) {
                metaDataProperties.remove("schemaRef");
            }
            if (metaDataProperties.has("description") && metaDataProperties.getString("description").isEmpty()) {
                metaDataProperties.remove("description");
            }
            if (metaDataProperties.has("cq:tags") && (tags = (String[])metaDataProperties.get("cq:tags")) != null && tags.length > 0) {
                metaDataProperties.put("cq:tags", new JSONArray(Arrays.asList(tags)));
            }
        }
        catch (FormsMgrException fmException) {
            throw fmException;
        }
        catch (Exception e) {
            log.error("error while creating json to create DAM Asset", e);
            throw new FormsMgrException("AEM-FMG-800-005");
        }
    }

    public static Resource createCQPageResource(ResourceResolver resourceResolver, String cqPagePath, JSONObject metadataProperties, FMConstants.CoreAssetType assetType, FMConstants.FORM_MODEL form_model, String templatePath) throws FormsMgrException, RepositoryException, PersistenceException, JSONException {
        JcrUtils.getOrCreateByPath(cqPagePath, "sling:Folder", "sling:Folder", resourceResolver.adaptTo(Session.class), false);
        AssetManager assetManager = resourceResolver.adaptTo(AssetManager.class);
        if (assetType == FMConstants.CoreAssetType.GUIDE || assetType == FMConstants.CoreAssetType.DOCUMENT_TEMPLATE) {
            String folderPath = assetType == FMConstants.CoreAssetType.DOCUMENT_TEMPLATE ? FMUtils.getAssetPathFromPage(Text.getRelativeParent(cqPagePath, 3)) : FMUtils.getAssetPathFromPage(Text.getRelativeParent(cqPagePath, 1));
            Template afTemplate = FMUtils.getValidAFTemplate(resourceResolver, templatePath, folderPath);
            if (afTemplate == null) {
                throw new FormsMgrException("AEM-FMG-900-018", new String[]{templatePath});
            }
            if (afTemplate.hasStructureSupport()) {
                assetManager.copyAsset(templatePath + "/initial", cqPagePath);
            } else {
                assetManager.copyAsset(templatePath, cqPagePath);
            }
        } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
            assetManager.copyAsset("/libs/fd/af/templateForFragment/defaultFragmentTemplate", cqPagePath);
        }
        Resource cqPageResource = resourceResolver.getResource(cqPagePath);
        Resource thumbnailResource = resourceResolver.getResource(cqPageResource, "thumbnail.png");
        if (thumbnailResource != null) {
            resourceResolver.delete(thumbnailResource);
        }
        FMUtils.addMetaDataToCQPage(cqPageResource, resourceResolver, cqPagePath, metadataProperties, assetType, templatePath);
        Resource guideContainerResource = resourceResolver.getResource(cqPageResource, "jcr:content/guideContainer");
        if (assetType != FMConstants.CoreAssetType.DOCUMENT_TEMPLATE) {
            Resource guideRootPanelItemResource = resourceResolver.getResource(guideContainerResource, "rootPanel/items");
            if (guideContainerResource != null) {
                Node itemNode = guideRootPanelItemResource.adaptTo(Node.class);
                NodeIterator Iter2 = itemNode.getNodes();
                while (Iter2.hasNext()) {
                    Iter2.nextNode().remove();
                }
            }
        }
        return cqPageResource;
    }

    public static void addMetaDataToCQPage(Resource cqPageResource, ResourceResolver resourceResolver, String cqPagePath, JSONObject metadataProperties, FMConstants.CoreAssetType assetType, String templatePath) throws JSONException {
        if (cqPageResource != null) {
            ModifiableValueMap mvm = cqPageResource.adaptTo(ModifiableValueMap.class);
            mvm.remove("jcr:title");
            mvm.remove("jcr:description");
            mvm.remove("allowedPaths");
            mvm.put("jcr:primaryType", "cq:Page");
            Resource jcrContentResource = resourceResolver.getResource(cqPageResource, "jcr:content");
            mvm = jcrContentResource.adaptTo(ModifiableValueMap.class);
            if (assetType == FMConstants.CoreAssetType.GUIDE) {
                mvm.put("cq:template", templatePath);
            } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
                mvm.put("cq:template", "/libs/fd/af/templateForFragment/defaultFragmentTemplate");
            }
            mvm.put("jcr:language", "en");
            mvm.put("cq:lastModifiedBy", resourceResolver.getUserID());
            mvm.put("cq:lastModified", Calendar.getInstance());
            mvm.remove("guideComponentType");
            if (assetType != FMConstants.CoreAssetType.DOCUMENT_TEMPLATE) {
                mvm.put("jcr:title", metadataProperties.getString("title"));
            }
        } else {
            log.error("Error. Unable to add metadata to CQ Page while form generation as CQ Page resource should not be null. Path: " + cqPagePath);
        }
    }

    public static void handleViewPrintNodeForDOR(String dorType, Resource guideContainerResource) {
        if ("generate".equals(dorType)) {
            Node guideContainerNode = guideContainerResource.adaptTo(Node.class);
            try {
                Node viewNode = guideContainerNode.addNode("view", "nt:unstructured");
                Node printNode = viewNode.addNode("print", "nt:unstructured");
                Calendar cal = Calendar.getInstance();
                printNode.setProperty("metaTemplateRef", "/libs/fd/af/dor/templates/defaultTemplate.xdp");
                printNode.setProperty("sling:resourceType", "fd/af/authoring/components/dor/dorProperties");
                printNode.setProperty("jcr:created", cal);
                printNode.setProperty("jcr:lastModified", cal);
            }
            catch (RepositoryException e) {
                log.error("Unable to create view/print node for DOR Type generate", e);
            }
        }
    }

    public static void addMetaDataToGuideContainer(ResourceResolver resourceResolver, String cqPagePath, JSONObject metadataProperties, FMConstants.CoreAssetType assetType, FMConstants.FORM_MODEL form_model) throws JSONException {
        Resource guideContainerResource = resourceResolver.getResource(cqPagePath + "/" + "jcr:content/guideContainer");
        if (guideContainerResource != null) {
            ModifiableValueMap mvm = guideContainerResource.adaptTo(ModifiableValueMap.class);
            if (assetType != FMConstants.CoreAssetType.DOCUMENT_TEMPLATE) {
                mvm.put("fd:version", metadataProperties.getString("fd:version"));
            } else {
                mvm.put("fd:version", "1.1");
            }
            if ((assetType == FMConstants.CoreAssetType.DOCUMENT_TEMPLATE || assetType == FMConstants.CoreAssetType.GUIDE) && metadataProperties != null) {
                if (metadataProperties.has("themeRef")) {
                    mvm.put("themeRef", metadataProperties.getString("themeRef"));
                }
                if (metadataProperties.has("dorTemplateRef")) {
                    mvm.put("dorTemplateRef", metadataProperties.getString("dorTemplateRef"));
                }
                if (metadataProperties.has("dorType")) {
                    String dorType = metadataProperties.getString("dorType");
                    mvm.put("dorType", dorType);
                    FMUtils.handleViewPrintNodeForDOR(dorType, guideContainerResource);
                }
            }
            if (assetType == FMConstants.CoreAssetType.GUIDE) {
                Resource signerInfoResource;
                switch (form_model) {
                    case FORM_TEMPLATE: {
                        mvm.put("xdpRef", metadataProperties.getString("xdpRef"));
                        break;
                    }
                    case XML_SCHEMA: {
                        mvm.put("xsdRef", metadataProperties.getString("xsdRef"));
                        mvm.put("xsdRootElement", metadataProperties.getString("xsdRootElement"));
                        mvm.put("schemaType", "xmlschema");
                        break;
                    }
                    case JSON_SCHEMA: {
                        mvm.put("schemaRef", metadataProperties.getString("schemaRef"));
                        mvm.put("schemaType", "jsonschema");
                        break;
                    }
                    case FORM_DATA_MODEL: {
                        mvm.put("schemaRef", metadataProperties.getString("schemaRef"));
                        mvm.put("schemaType", "formdatamodel");
                    }
                }
                mvm.put("_useSignedPdf", metadataProperties.optBoolean("_useSignedPdf"));
                if (StringUtils.isNotBlank(metadataProperties.optString("signConfigPath")) && (signerInfoResource = resourceResolver.getResource(guideContainerResource, "signerInfo")) != null) {
                    ModifiableValueMap signvm = signerInfoResource.adaptTo(ModifiableValueMap.class);
                    signvm.put("signConfigPath", metadataProperties.getString("signConfigPath"));
                }
            } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
                switch (form_model) {
                    case FORM_TEMPLATE: {
                        mvm.put("xdpRef", metadataProperties.getString("xdpRef"));
                        mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                        break;
                    }
                    case XML_SCHEMA: {
                        mvm.put("xsdRef", metadataProperties.getString("xsdRef"));
                        mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                        mvm.put("schemaType", "xmlschema");
                        break;
                    }
                    case JSON_SCHEMA: {
                        mvm.put("schemaRef", metadataProperties.getString("schemaRef"));
                        mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                        mvm.put("schemaType", "jsonschema");
                        break;
                    }
                    case FORM_DATA_MODEL: {
                        mvm.put("schemaRef", metadataProperties.getString("schemaRef"));
                        mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                        mvm.put("schemaType", "formdatamodel");
                    }
                }
            }
        } else {
            log.error("Error. Unable to add metadata to guide container while form generation as guide container resource should not be null. Path: " + cqPagePath);
        }
    }

    public static Node createCQPageNode(ResourceResolver resourceResolver, JSONObject paramsJson, FMConstants.CoreAssetType assetType, FMConstants.FORM_MODEL form_model, String templatePath) throws FormsMgrException {
        try {
            String cqPagePath = FMUtils.getPagePathFromAsset(paramsJson.getString("path"));
            JSONObject metadataProperties = paramsJson.getJSONObject("metadataProperties");
            Resource cqPageResource = FMUtils.createCQPageResource(resourceResolver, cqPagePath, metadataProperties, assetType, form_model, templatePath);
            return cqPageResource.adaptTo(Node.class);
        }
        catch (FormsMgrException e) {
            log.error("Error while creating cq page Node : ", e);
            throw e;
        }
        catch (Exception e) {
            log.error("Error while creating cq page Node : ", e);
            throw new FormsMgrException("AEM-FMG-900-005");
        }
    }

    public static Template getValidAFTemplate(ResourceResolver resourceResolver, String afTemplatePath, String assetPathSuffix) throws RepositoryException {
        Template afTemplate;
        Resource afTemplateResource;
        if (afTemplatePath != null && !afTemplatePath.isEmpty() && (afTemplateResource = resourceResolver.getResource(afTemplatePath)) != null && (afTemplate = afTemplateResource.adaptTo(Template.class)) != null) {
            if (afTemplate.hasStructureSupport()) {
                ValueMap templateProperties = afTemplate.getProperties();
                String status = (String)((Object)templateProperties.get("status", String.class));
                if (status != null && "enabled".equals(status) && TemplateUtils.isTemplateAllowed(resourceResolver.adaptTo(Session.class), afTemplatePath, assetPathSuffix)) {
                    return afTemplate;
                }
                log.error("Invalid Adaptive Form Template {}. This authored template is not enabled.", (Object)afTemplatePath);
            } else {
                return afTemplate;
            }
        }
        return null;
    }

    public static void JsonToJcrNode(Node node, JSONObject jsonObject) throws JSONException, RepositoryException {
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object property = jsonObject.get(key);
            FMUtils.handleProperty(node, key, property);
        }
    }

    private static void handleProperty(Node node, String name, Object property) throws JSONException, RepositoryException {
        if (JSONObject.class.isAssignableFrom(property.getClass())) {
            JSONObject nodeJson = (JSONObject)property;
            if (nodeJson.has("jcr:primaryType") && nodeJson.getString("jcr:primaryType").equals("nt:file")) {
                return;
            }
            Node childNode = node.hasNode(name) ? node.getNode(name) : node.addNode(name, "nt:unstructured");
            FMUtils.JsonToJcrNode(childNode, (JSONObject)property);
        } else {
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes")) {
                return;
            }
            String[] propertyValue = property;
            if (property instanceof String) {
                propertyValue = StringUtils.trim((String)property);
            } else if (property instanceof JSONArray) {
                JSONArray arrJson = (JSONArray)property;
                int len = arrJson.length();
                String[] strArr = new String[len];
                for (int i = 0; i < len; ++i) {
                    strArr[i] = arrJson.getString(i);
                }
                propertyValue = strArr;
            }
            if (("minOccur".equals(name) || "maxOccur".equals(name) || "leadDigits".equals(name)) && propertyValue instanceof Integer) {
                propertyValue = ((Integer)propertyValue).longValue();
            }
            JcrUtil.setProperty(node, name, propertyValue);
        }
    }

    public static void moveNode(ResourceResolver resolver, String sourceLocation, String destinationLocation) throws FormsMgrException {
        if (sourceLocation == null || "".equals(sourceLocation)) {
            log.error("Exception in moveNode() as source path is not valid");
            Object[] args = new Object[]{"sourceLocation", sourceLocation};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        if (destinationLocation == null || "".equals(destinationLocation)) {
            log.error("Exception in moveNode() as destination path is not valid");
            Object[] args = new Object[]{"destinationLocation", destinationLocation};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        Session session = resolver.adaptTo(Session.class);
        int index = sourceLocation.lastIndexOf("/");
        String nodeName = sourceLocation.substring(index);
        try {
            if (!session.nodeExists(sourceLocation)) {
                log.error("Exception in moveNode() as source location" + sourceLocation + "does not exist");
                Object[] args = new Object[]{"sourceLocation", sourceLocation};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (session.nodeExists(destinationLocation + nodeName)) {
                log.error("Exception in moveNode() as resource already exist at destination");
                Object[] args = new Object[]{nodeName, destinationLocation};
                throw new FormsMgrException("AEM-FMG-900-002", args);
            }
            session.move(sourceLocation, destinationLocation + nodeName);
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception in moveNode() while moving node from" + sourceLocation + "to" + destinationLocation, e);
            throw new FormsMgrException(e);
        }
    }

    public static String getClientlibPath(Node resourceNode) throws FormsMgrException {
        String clientLibProperty = "./jcr:content/metadata/clientlibRef";
        String clientLibPath = "";
        try {
            if (resourceNode != null && resourceNode.hasProperty(clientLibProperty)) {
                clientLibPath = resourceNode.getProperty(clientLibProperty).getString() + "/" + resourceNode.getName();
            }
        }
        catch (ValueFormatException e) {
            log.error("Exception in getClientlibNode()", e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getClientlibNode()", e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getClientlibNode()", e);
            throw new FormsMgrException(e);
        }
        return clientLibPath;
    }

    public static String getThemeRef(Session session, String path) throws FormsMgrException {
        String themeRefPath = null;
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null && metadataNode.hasProperty("themeRef")) {
                themeRefPath = metadataNode.getProperty("themeRef").getString();
            }
            return themeRefPath;
        }
        catch (ValueFormatException e) {
            log.error("Exception in getThemeRef() due to ValueFormatException", e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getThemeRef() due to PathNotFoundException", e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getThemeRef() due to RepositoryException", e);
            throw new FormsMgrException(e);
        }
    }

    public static String getPropertyAsString(Session session, String nodePath, String propertyName) throws FormsMgrException {
        String propertyValue = null;
        try {
            if (session.nodeExists(nodePath)) {
                Node node = session.getNode(nodePath);
                propertyValue = node != null && node.hasProperty(propertyName) ? node.getProperty(propertyName).getString() : propertyValue;
            }
            return propertyValue;
        }
        catch (RepositoryException e) {
            log.error("Exception in getPropertyAsString() due to " + e.getClass().getSimpleName(), e);
            throw new FormsMgrException(e);
        }
    }

    public static String getCategoryNameFromClientLibPath(String clientLibPath) {
        String categoryName = "fdtheme";
        clientLibPath = clientLibPath.replace("/etc/clientlibs/fd/themes", "");
        clientLibPath = clientLibPath.replaceAll("\\s+", "");
        categoryName = categoryName + clientLibPath.replace("/", ".");
        return categoryName;
    }

    public static Node getRenditionNode(Node formNode, boolean create) throws FormsMgrException {
        Node renditionNode = null;
        Node contentNode = FMUtils.getContentNode(formNode, create);
        if (contentNode != null) {
            try {
                if (!contentNode.hasNode("renditions")) {
                    if (create) {
                        renditionNode = contentNode.addNode("renditions", "{http://www.jcp.org/jcr/nt/1.0}folder");
                    }
                } else {
                    renditionNode = contentNode.getNode("renditions");
                }
            }
            catch (RepositoryException e) {
                throw new FormsMgrException(e);
            }
        }
        return renditionNode;
    }

    public static String getResourceTitle(Resource resource) throws FormsMgrException {
        try {
            String title = null;
            Template template = resource.adaptTo(Template.class);
            if (template != null) {
                return template.getTitle();
            }
            ContentPolicy contentPolicy = resource.adaptTo(ContentPolicy.class);
            if (contentPolicy != null) {
                ValueMap contentPolicyProps = contentPolicy.getProperties();
                return contentPolicyProps.get("jcr:title", null);
            }
            Node resourceNode = resource.adaptTo(Node.class);
            Node metadataNode = FMUtils.getMetadataNode(resourceNode, false);
            if (metadataNode != null && metadataNode.hasProperty("title")) {
                title = metadataNode.getProperty("title").getString();
            }
            return title;
        }
        catch (ValueFormatException e) {
            log.error("Exception in getResourceTitle() due to ValueFormatException", e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getResourceTitle() due to PathNotFoundException", e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getResourceTitle() due to RepositoryException", e);
            throw new FormsMgrException(e);
        }
    }

    public static FormsAssetType getFormsFoundationAssetType(FMConstants.CoreAssetType coreAssetType) throws FormsMgrException {
        FormsAssetType formsAssetType = null;
        switch (coreAssetType) {
            case FORM: {
                formsAssetType = FormsAssetType.XDP;
                break;
            }
            case RESOURCE: {
                formsAssetType = FormsAssetType.FM_RESOURCE;
                break;
            }
            case GUIDE: {
                formsAssetType = FormsAssetType.ADAPTIVE_FORM;
                break;
            }
            case FORMSET: {
                formsAssetType = FormsAssetType.FORMSET;
                break;
            }
            case AFFRAGMENT: {
                formsAssetType = FormsAssetType.ADAPTIVE_FORM_FRAGMENT;
                break;
            }
            case ADAPTIVEDOCUMENT: {
                formsAssetType = FormsAssetType.ADAPTIVE_DOCUMENT;
                break;
            }
            case THEME: {
                formsAssetType = FormsAssetType.THEME;
                break;
            }
            case PDFFORM: {
                formsAssetType = FormsAssetType.PDF;
                break;
            }
            case PRINTFORM: {
                formsAssetType = FormsAssetType.PRINT_FORM;
                break;
            }
            case FOLDER: {
                formsAssetType = FormsAssetType.FOLDER;
                break;
            }
            case DOCUMENT_TEMPLATE: {
                formsAssetType = FormsAssetType.MCDOCUMENT;
                break;
            }
            case NONFMASSET: 
            case ALL: {
                log.error("FM Asset Type " + (Object)((Object)coreAssetType) + " cannot be converted into FormsAssetType.");
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"FM Asset Type", coreAssetType.toString()});
            }
            default: {
                log.error("If there is any new addition in FM CoreAssetType, it should be handled here.");
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"FM Asset Type", coreAssetType.toString()});
            }
        }
        log.debug("FM Core Asset type : " + (Object)((Object)coreAssetType) + "converted into Forms Foundation Asset Type : " + (Object)((Object)formsAssetType));
        return formsAssetType;
    }

    public static boolean hasMixin(Node node, String mixinName) throws RepositoryException {
        if (node == null || mixinName == null) {
            return false;
        }
        NodeType[] nodeTypes = node.getMixinNodeTypes();
        if (nodeTypes != null) {
            for (NodeType nodeType : nodeTypes) {
                if (!mixinName.equals(nodeType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void addMixin(Node node, String[] mixinNames) throws FormsMgrException {
        if (node == null) {
            Object[] args = new Object[]{"asset path", node};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        if (mixinNames == null) {
            Object[] args = new Object[]{"mixins", mixinNames};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        try {
            for (String mixinName : mixinNames) {
                if (FMUtils.hasMixin(node, mixinName)) continue;
                node.addMixin(mixinName);
            }
        }
        catch (Exception e) {
            throw new FormsMgrException("AEM-FMG-700-026", e);
        }
    }

    public static void cleanUpReplicationInfo(Session session, String path) throws FormsMgrException {
        if (session == null || path == null || path.isEmpty()) {
            Object[] args = new Object[]{session == null ? "session" : "formPath", session == null ? session : path};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        try {
            if (session.nodeExists(path)) {
                Node node = session.getNode(path);
                String val = null;
                node.setProperty("cq:lastReplicated", val);
                node.setProperty("cq:lastReplicatedBy", val);
                node.setProperty("cq:lastReplicationAction", val);
            }
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    public static boolean isValidAssetName(String assetName, String pattern) {
        boolean result = false;
        if (Pattern.matches(pattern, assetName)) {
            result = true;
        }
        return result;
    }

    public static boolean isValidFolderName(String folderName) {
        boolean result = false;
        if (Pattern.matches("[a-zA-Z0-9 ._-]*", folderName)) {
            result = true;
        }
        return result;
    }

    public static boolean checkForExistingForms(String assetPath, Session session, String rootPath) throws FormsMgrException, RepositoryException {
        int index = assetPath.lastIndexOf("/");
        assetPath = assetPath.substring(rootPath.length(), index);
        String[] paths = assetPath.split("/");
        String path = rootPath;
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].isEmpty() || !session.nodeExists(path = path + "/" + paths[i]) || FMUtils.isFolder(session, path) || FMUtils.isApplication(session, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserPartOfGroup(Principal userPrincipal, UserManager um, String groupId) throws RepositoryException {
        boolean isAllowed = false;
        User user = (User)um.getAuthorizable(userPrincipal);
        if (user.isAdmin()) {
            isAllowed = true;
        } else {
            Group group = (Group)um.getAuthorizable(groupId);
            if (group != null) {
                isAllowed = group.isMember(user);
            }
        }
        return isAllowed;
    }

    public static void setLastModifiedTime(String formPath, ResourceResolver resolver) {
        if (formPath == null || resolver == null) {
            log.error("invalid argument - form path : " + formPath + ", resolver : " + resolver);
            return;
        }
        if (formPath.startsWith("/content/dam/formsanddocuments")) {
            try {
                Resource contentResource = resolver.getResource(formPath + "/" + "jcr:content");
                if (contentResource != null) {
                    ModifiableValueMap vm = contentResource.adaptTo(ModifiableValueMap.class);
                    vm.put("jcr:lastModified", Calendar.getInstance());
                    log.info("setting last modified time for : " + formPath);
                }
            }
            catch (Exception e) {
                log.error("exception while setting last modified time for : " + formPath);
            }
        }
    }

    public static <T> T notNulOrDefault(T getValue, T defaultValue) {
        return getValue == null ? defaultValue : getValue;
    }

    public static void setAssetIdentifier(Node node, String assetType, int validOrdinal) throws FormsMgrException {
        try {
            node.setProperty(assetType, validOrdinal);
            node.setProperty("type", assetType);
        }
        catch (ValueFormatException e) {
            throw new FormsMgrException(e);
        }
        catch (VersionException e) {
            throw new FormsMgrException(e);
        }
        catch (LockException e) {
            throw new FormsMgrException(e);
        }
        catch (ConstraintViolationException e) {
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean clientlibExists(String clientlibCategoryName, HtmlLibraryManager htmlLibraryManager) {
        boolean clientLibExists = false;
        Map<String, ClientLibrary> libraries = htmlLibraryManager.getLibraries();
        if (libraries != null) {
            for (ClientLibrary library : libraries.values()) {
                Object[] categories = library.getCategories();
                if (categories == null || !ArrayUtils.contains(categories, clientlibCategoryName)) continue;
                clientLibExists = true;
                break;
            }
        }
        return clientLibExists;
    }

    public static String getRequestParamValue(RequestParameterMap paramMap, String param) {
        String paramValue = null;
        if (paramMap.containsKey(param) && StringUtils.isNotBlank(paramMap.getValue(param).getString())) {
            paramValue = paramMap.getValue(param).getString();
        }
        return paramValue;
    }

    public static String getTitle(Resource resource) {
        String title = "";
        try {
            Node childAsset = resource.adaptTo(Node.class);
            if (childAsset != null) {
                Node metadataNode = FMUtils.getMetadataNode(childAsset, false);
                if (metadataNode != null && metadataNode.hasProperty("title")) {
                    title = metadataNode.getProperty("title").getString();
                } else {
                    Node contentNode = FMUtils.getContentNode(childAsset, false);
                    if (contentNode != null && contentNode.hasProperty("jcr:title")) {
                        title = contentNode.getProperty("jcr:title").getString();
                    }
                }
                if (StringUtils.isEmpty(title)) {
                    title = childAsset.getName();
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching title of resource: " + resource.getPath(), e);
        }
        return title.trim();
    }

    public static String getDisplayType(Resource resource) {
        String displayType = "";
        try {
            Node childAsset = resource.adaptTo(Node.class);
            Session session = resource.getResourceResolver().adaptTo(Session.class);
            if (childAsset != null) {
                if (childAsset.isNodeType("sling:Folder")) {
                    displayType = "Folder";
                    if (childAsset.hasProperty("lcApplication")) {
                        displayType = "Forms Workflow Application";
                    }
                } else {
                    String childPath = childAsset.getPath();
                    FMConstants.CoreAssetType type = FMUtils.getAssetType(session, childPath);
                    AssetInfo assetInfo = new AssetInfo(resource, type);
                    displayType = assetInfo.getPublishAssetType();
                    if ("Theme".equals(displayType)) {
                        displayType = "Folder";
                        if (childAsset.hasProperty("lcApplication")) {
                            displayType = "Forms Workflow Application";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching display type of resource: " + resource.getPath(), e);
        }
        return displayType;
    }

    public static long getSize(Resource resource) {
        long bytes = 0L;
        try {
            Rendition rendition;
            Asset asset = resource.adaptTo(Asset.class);
            if (asset != null && (rendition = asset.getRendition("original")) != null) {
                bytes = rendition.getSize();
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching size of resource: " + resource.getPath(), e);
        }
        return bytes;
    }

    public static String getDescription(Resource resource) {
        String desc = "";
        try {
            Node metadataNode;
            Node childAsset = resource.adaptTo(Node.class);
            if (childAsset != null && (metadataNode = FMUtils.getMetadataNode(childAsset, false)) != null && metadataNode.hasProperty("description")) {
                desc = metadataNode.getProperty("description").getString();
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching description of resource: " + resource.getPath(), e);
        }
        return desc.trim();
    }

    public static String getStatus(Resource resource) {
        String status = "";
        try {
            Node childAsset = resource.adaptTo(Node.class);
            long modificationDateInMillis = -1L;
            long publishDateInMillis = -2L;
            if (childAsset != null) {
                Node contentNode = FMUtils.getContentNode(childAsset, false);
                if (contentNode != null) {
                    Calendar cal;
                    if (contentNode.hasProperty("jcr:lastModified") && (cal = contentNode.getProperty("jcr:lastModified").getDate()) != null) {
                        modificationDateInMillis = cal.getTimeInMillis();
                    }
                    if (contentNode.hasProperty("cq:lastReplicated") && (cal = contentNode.getProperty("cq:lastReplicated").getDate()) != null) {
                        publishDateInMillis = cal.getTimeInMillis();
                    }
                }
                if (modificationDateInMillis > publishDateInMillis && publishDateInMillis > 0L) {
                    status = "Modified";
                } else if (publishDateInMillis > 0L) {
                    status = "Published";
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching status of resource: " + resource.getPath(), e);
        }
        return status;
    }

    public static long getLastModified(Resource resource) {
        long modificationDateInMillis = -1L;
        try {
            Node childAsset = resource.adaptTo(Node.class);
            Session session = resource.getResourceResolver().adaptTo(Session.class);
            if (childAsset != null) {
                modificationDateInMillis = FMUtils.getLastModifiedOrCreated(session, childAsset.getPath());
            }
        }
        catch (Exception e) {
            log.error("Exception while fetching last modified time of resource: " + resource.getPath(), e);
        }
        return modificationDateInMillis;
    }

    public static Resource getPrintChannelResource(Resource resource) throws FormsMgrException {
        String pagepath = FMUtils.getPagePathFromAsset(resource.getPath());
        try {
            ResourceResolver resolver = resource.getResourceResolver();
            Resource pageResource = resolver.getResource(pagepath);
            Resource printChannelResource = pageResource.getChild("channels/print");
            return printChannelResource;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }
}

