/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.rnc;

import com.adobe.aem.formsndocuments.publish.PublishPreprocessor;
import com.adobe.aem.formsndocuments.rnc.ReviewManagementService;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aem.formsndocuments.util.RnCUtil;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={PublishPreprocessor.class})
public class RnCPublishPreprocessor
implements PublishPreprocessor {
    private static final String METADATA_PATH = "/jcr:content/metadata";
    private static Logger logger = LoggerFactory.getLogger(RnCPublishPreprocessor.class);
    @Reference(referenceInterface=SlingRepository.class)
    SlingRepository slingRepository;
    @Reference(referenceInterface=ResourceResolverFactory.class)
    ResourceResolverFactory resourceResolverFactory;
    @Reference(referenceInterface=ReviewManagementService.class)
    ReviewManagementService reviewManagementService;

    @Override
    public void preprocess(Session userSession, String assetPath, Map params) {
        logger.trace("Entering preprocess.");
        try {
            ResourceResolver resourceResolver = FMUtils.getResourceResolver(this.resourceResolverFactory, userSession);
            Node asset = RnCUtil.checkNodeExistance(assetPath + METADATA_PATH, resourceResolver);
            if (asset.hasProperty("underReview") && asset.getProperty("underReview").getBoolean()) {
                this.reviewManagementService.cleanReview(assetPath, userSession, true);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to cleanup the review: ", e);
        }
        logger.trace("Exiting preprocess.");
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReviewManagementService(ReviewManagementService reviewManagementService) {
        this.reviewManagementService = reviewManagementService;
    }

    protected void unbindReviewManagementService(ReviewManagementService reviewManagementService) {
        if (this.reviewManagementService == reviewManagementService) {
            this.reviewManagementService = null;
        }
    }
}

