/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.rnc;

import com.adobe.aem.formsndocuments.exception.FormsNDocumentsException;
import com.adobe.aem.formsndocuments.rnc.ReviewManagementService;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aem.formsndocuments.util.RnCUtil;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.taskmanagement.Task;
import com.adobe.granite.taskmanagement.TaskManager;
import com.adobe.granite.taskmanagement.TaskManagerException;
import com.adobe.granite.workflow.exec.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={ReviewManagementService.class})
public class ReviewManagementServiceImpl
implements ReviewManagementService {
    private static final String REVIEW_CONTAINER_PATH = "/jcr:content/reviewcontainer";
    private static final String REVIEW_GROUPS_PATH = "forms/rnc";
    private static final String METADATA_PATH = "/jcr:content/metadata";
    private static final String EVERYONE = "everyone";
    private static final String REMOVED_REVIEWERS = "removedReviewers";
    private static final String ADDED_REVIEWERS = "addedReviewers";
    private static final String MIXIN_MODIFY = "mix:lastModified";
    private static final String MIXIN_ACESS = "rep:AccessControllable";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    @Reference(referenceInterface=SlingRepository.class)
    SlingRepository slingRepository;
    @Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=ResourceResolverFactory.class)
    ResourceResolverFactory resourceResolverFactory;
    private static Logger logger = LoggerFactory.getLogger(ReviewManagementServiceImpl.class);

    private void createReviewContainer(String assetPath, String initiatorId, Session session, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering createReviewContainer.");
        try {
            Node asset = RnCUtil.checkNodeExistance(assetPath, resourceResolver);
            UserManager um = resourceResolver.adaptTo(UserManager.class);
            if (!asset.hasNode(REVIEW_CONTAINER_PATH.substring(1))) {
                Node reviewContainer = asset.addNode(REVIEW_CONTAINER_PATH.substring(1), "sling:Folder");
                reviewContainer.addMixin(MIXIN_MODIFY);
                Node reviewTasks = asset.addNode("/jcr:content/reviewcontainer/reviewtasks".substring(1), "sling:Folder");
                reviewTasks.addMixin(MIXIN_MODIFY);
                Authorizable formsUserAuth = um.getAuthorizable(EVERYONE);
                AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/jcr:content/reviewcontainer/reviewtasks", formsUserAuth.getPrincipal(), new String[0], new String[]{"{http://www.jcp.org/jcr/1.0}all"}, new String[0], null);
                Authorizable serviceUserAuth = um.getAuthorizable(session.getUserID());
                AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/jcr:content/reviewcontainer/reviewtasks", serviceUserAuth.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}versionManagement", "crx:replicate", "rep:write", "{http://www.jcp.org/jcr/1.0}modifyAccessControl", "{http://www.jcp.org/jcr/1.0}readAccessControl"}, new String[0], new String[0], null);
            }
            Authorizable initiatorAuth = um.getAuthorizable(initiatorId);
            AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/jcr:content/reviewcontainer/reviewtasks", initiatorAuth.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read", "rep:write"}, new String[0], new String[0], null);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error("Exception while creating review container for asset " + assetPath, e);
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-022", args);
        }
        logger.trace("Exiting createReviewContainer.");
    }

    private String createReviewNode(String assetPath, String reviewId, String reviewGroupId, Session session, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering createReviewNode.");
        try {
            Node asset = RnCUtil.checkNodeExistance(assetPath, resourceResolver);
            reviewId = reviewId.replace("\"", "_");
            String reviewNodePath = REVIEW_CONTAINER_PATH.substring(1) + "/" + reviewId;
            Node reviewContainer = asset.addNode(reviewNodePath, NT_UNSTRUCTURED);
            reviewContainer.addMixin(MIXIN_MODIFY);
            reviewContainer.addMixin(MIXIN_ACESS);
            UserManager um = resourceResolver.adaptTo(UserManager.class);
            Authorizable everyoneAuth = um.getAuthorizable(EVERYONE);
            AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/" + reviewNodePath, everyoneAuth.getPrincipal(), new String[0], new String[]{"rep:write"}, new String[0], null);
            Authorizable reviewGrpAuth = um.getAuthorizable(reviewGroupId);
            AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/" + reviewNodePath, reviewGrpAuth.getPrincipal(), new String[]{"rep:write"}, new String[0], new String[0], null);
            Authorizable serviceUserAuth = um.getAuthorizable(session.getUserID());
            AccessControlUtil.replaceAccessControlEntry(session, assetPath + "/" + reviewNodePath, serviceUserAuth.getPrincipal(), new String[]{"rep:write"}, new String[0], new String[0], null);
        }
        catch (RepositoryException e) {
            logger.error("Exception while creating review node for asset " + assetPath + " exception: ", e);
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-009", args);
        }
        logger.trace("Exiting createReviewNode.");
        return reviewId;
    }

    private Task addReviewerTask(String reviewProjectId, String reviewName, String deadline, String reviewer, String assetPath, String reviewGroupId, String reviewDescription, ResourceResolver bundleResourceResolver, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering addReviewerTask.");
        Task task = null;
        try {
            task = RnCUtil.createTask(reviewProjectId, reviewName, deadline, reviewer, assetPath, reviewDescription, bundleResourceResolver, resourceResolver);
        }
        catch (TaskManagerException e) {
            logger.error("Exception while creating Task ", e);
            Object[] args = null;
            throw new FormsNDocumentsException("AEM-FMG-700-006", args);
        }
        logger.trace("Exiting addReviewerTask.");
        return task;
    }

    private void removeReviewerTask(String reviewProjectName, String reviewer, String reviewGroupId, String reviewInitiator, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering removeReviewerTask.");
        if (reviewProjectName == null || reviewer == null || reviewGroupId == null) {
            return;
        }
        if (reviewProjectName.isEmpty() || reviewer.isEmpty() || reviewGroupId.isEmpty()) {
            return;
        }
        try {
            List<Task> subTaskList;
            TaskManager taskManager = resourceResolver.adaptTo(TaskManager.class);
            Task task = taskManager.getTask(reviewProjectName, true);
            if (task != null && (subTaskList = task.getSubTasks()) != null) {
                for (Task subTask : subTaskList) {
                    String assignee = subTask.getCurrentAssignee();
                    if (!assignee.equals(reviewer) || Status.COMPLETE.equals((Object)subTask.getStatus())) continue;
                    taskManager.terminateTask(subTask.getId());
                }
            }
        }
        catch (TaskManagerException e) {
            logger.error("Exception while terminating Task ", e);
            Object[] args = null;
            throw new FormsNDocumentsException("AEM-FMG-700-007", args);
        }
        logger.trace("Exiting removeReviewerTask.");
    }

    private void addAssetReviewInfo(String assetPath, String reviewName, String reviewDescription, String reviewProjectId, String deadline, String reviewGroup, String reviewId, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering addAssetReviewInfo.");
        try {
            Node asset = RnCUtil.getNode(assetPath + METADATA_PATH, resourceResolver);
            if (asset == null) {
                return;
            }
            String initiatorId = this.resourceResolverHelper.getResourceResolverAs(Session.class).getUserID();
            Node review = RnCUtil.getNode(assetPath + REVIEW_CONTAINER_PATH + "/" + reviewId, resourceResolver);
            asset.setProperty("underReview", true);
            asset.setProperty("reviewId", reviewId);
            asset.setProperty("reviewInitiator", initiatorId);
            review.setProperty("reviewProjectName", reviewProjectId);
            review.setProperty("reviewName", reviewName);
            review.setProperty("reviewId", reviewId);
            review.setProperty("reviewInitiator", initiatorId);
            review.setProperty("reviewDescription", reviewDescription);
            review.setProperty("reviewGroup", reviewGroup);
            review.setProperty("reviewDeadline", deadline);
        }
        catch (RepositoryException e) {
            logger.error("Exception while setting Review state ", e);
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-010", args);
        }
        logger.trace("Exiting addAssetReviewInfo.");
    }

    private void removeAssetReviewInfo(String assetPath, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering addAssetReviewInfo.");
        try {
            Node review;
            Node asset = RnCUtil.getNode(assetPath + METADATA_PATH, resourceResolver);
            if (asset == null) {
                return;
            }
            asset.setProperty("underReview", false);
            String reviewId = "";
            if (asset.hasProperty("reviewId")) {
                reviewId = asset.getProperty("reviewId").getString();
                asset.getProperty("reviewId").remove();
            }
            if (asset.hasProperty("reviewInitiator")) {
                asset.getProperty("reviewInitiator").remove();
            }
            if ((review = RnCUtil.getNode(assetPath + REVIEW_CONTAINER_PATH + "/" + reviewId, resourceResolver)) != null && review.hasProperty("reviewGroup")) {
                review.getProperty("reviewGroup").remove();
            }
        }
        catch (RepositoryException e) {
            logger.error("Exception while clearing review state ", e);
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-011", args);
        }
        logger.trace("Exiting addAssetReviewInfo.");
    }

    private void cleanUpPermissions(String assetPath, String reviewGroup, String reviewID, ResourceResolver bundleResourceResolver, ResourceResolver currentResourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering cleanUpPermissions.");
        try {
            String reviewContainerPath = assetPath + REVIEW_CONTAINER_PATH + "/" + reviewID;
            Node reviewContainerNode = RnCUtil.getNode(reviewContainerPath, currentResourceResolver);
            if (reviewContainerNode == null) {
                return;
            }
            UserManager um = bundleResourceResolver.adaptTo(UserManager.class);
            Authorizable authorizable = um.getAuthorizable(EVERYONE);
            Session bundleSession = bundleResourceResolver.adaptTo(Session.class);
            AccessControlUtil.replaceAccessControlEntry(bundleSession, reviewContainerPath, authorizable.getPrincipal(), new String[0], new String[0], new String[]{"rep:write"}, null);
            authorizable = um.getAuthorizable(reviewGroup);
            AccessControlUtil.replaceAccessControlEntry(bundleSession, reviewContainerPath, authorizable.getPrincipal(), new String[0], new String[0], new String[]{"rep:write"}, null);
            if (reviewContainerNode.hasProperty("reviewInitiator")) {
                String initiatorId = reviewContainerNode.getProperty("reviewInitiator").getString();
                Authorizable initiatorAuth = um.getAuthorizable(initiatorId);
                AccessControlUtil.replaceAccessControlEntry(bundleSession, assetPath + "/jcr:content/reviewcontainer/reviewtasks", initiatorAuth.getPrincipal(), new String[0], new String[0], new String[]{"{http://www.jcp.org/jcr/1.0}read", "rep:write"}, null);
            }
        }
        catch (RepositoryException e) {
            logger.error("Exception while removing permissions on comments node for asset " + assetPath, e);
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-016", args);
        }
        logger.trace("Exiting cleanUpPermissions.");
    }

    private Map<String, List<String>> getReviewersDiff(String[] newList, String reviewerGroupId, ResourceResolver bundleResourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering getReviewersDiff.");
        HashMap<String, List<String>> reviewerDiff = new HashMap<String, List<String>>();
        ArrayList<String> reviewersList = new ArrayList<String>();
        ArrayList<String> removedReviewers = new ArrayList<String>();
        ArrayList<String> addedReviewers = new ArrayList<String>();
        try {
            UserManager um = bundleResourceResolver.adaptTo(UserManager.class);
            Group reviewGroup = (Group)um.getAuthorizable(reviewerGroupId);
            Iterator<Authorizable> iterator = reviewGroup.getDeclaredMembers();
            while (iterator.hasNext()) {
                String id = iterator.next().getID();
                reviewersList.add(id);
            }
            for (String id : reviewersList) {
                if (RnCUtil.isInArray(id, newList)) continue;
                removedReviewers.add(id);
            }
            for (String id : newList) {
                if (reviewersList.contains(id)) continue;
                addedReviewers.add(id);
            }
            reviewerDiff.put(REMOVED_REVIEWERS, removedReviewers);
            reviewerDiff.put(ADDED_REVIEWERS, addedReviewers);
        }
        catch (RepositoryException e) {
            logger.error("Exception while retrieving group members for group " + reviewerGroupId, e);
            Object[] args = new Object[]{reviewerGroupId};
            throw new FormsNDocumentsException("AEM-FMG-700-017", args);
        }
        logger.trace("Exiting getReviewersDiff.");
        return reviewerDiff;
    }

    @Override
    public boolean isUnderReview(ResourceResolver resourceResolver, String assetPath) throws FormsNDocumentsException {
        if (resourceResolver != null) {
            try {
                Node asset = RnCUtil.getNode(assetPath + METADATA_PATH, resourceResolver);
                if (asset.hasProperty("underReview") && asset.getProperty("underReview").getBoolean()) {
                    return true;
                }
            }
            catch (ValueFormatException e) {
                logger.error("Illegal Review State.  ", e);
                Object[] args = null;
                throw new FormsNDocumentsException("AEM-FMG-700-008", args);
            }
            catch (RepositoryException e) {
                logger.error("Exception while retrieving bundle context ", e);
                Object[] args = new Object[]{e.getMessage()};
                throw new FormsNDocumentsException("AEM-FMG-700-005", args);
            }
        }
        return false;
    }

    @Override
    public Map<String, String> fetchReviewInfo(ResourceResolver resourceResolver, String assetPath) throws FormsNDocumentsException {
        logger.trace("Entering fetchReviewInfo.");
        RnCUtil.checkAssetPathArgument(assetPath);
        HashMap<String, String> reviewInfo = new HashMap<String, String>();
        try {
            if (resourceResolver != null) {
                Node review;
                Node asset = RnCUtil.checkNodeExistance(assetPath + METADATA_PATH, resourceResolver);
                if (!this.isUnderReview(resourceResolver, assetPath)) {
                    logger.error(" Asset " + assetPath + " is currently not under review.");
                    Object[] args = new Object[]{assetPath};
                    throw new FormsNDocumentsException("AEM-FMG-700-019", args);
                }
                String reviewId = "";
                if (asset.hasProperty("reviewId")) {
                    reviewId = asset.getProperty("reviewId").getString();
                    reviewInfo.put("reviewId", reviewId);
                }
                if ((review = RnCUtil.checkNodeExistance(assetPath + REVIEW_CONTAINER_PATH + "/" + reviewId, resourceResolver)).hasProperty("reviewProjectName")) {
                    reviewInfo.put("reviewProjectName", review.getProperty("reviewProjectName").getString());
                }
                if (review.hasProperty("reviewName")) {
                    reviewInfo.put("reviewName", review.getProperty("reviewName").getString());
                }
                if (review.hasProperty("reviewInitiator")) {
                    reviewInfo.put("reviewInitiator", review.getProperty("reviewInitiator").getString());
                }
                if (review.hasProperty("reviewDescription")) {
                    reviewInfo.put("reviewDescription", review.getProperty("reviewDescription").getString());
                }
                if (review.hasProperty("reviewGroup")) {
                    reviewInfo.put("reviewGroup", review.getProperty("reviewGroup").getString());
                }
                if (review.hasProperty("reviewDeadline")) {
                    reviewInfo.put("reviewDeadline", review.getProperty("reviewDeadline").getString());
                }
            }
        }
        catch (FormsNDocumentsException e) {
            throw e;
        }
        catch (ValueFormatException e) {
            logger.error("Illegal Review State.  ", e);
            Object[] args = null;
            throw new FormsNDocumentsException("AEM-FMG-700-008", args);
        }
        catch (RepositoryException e) {
            logger.error("Exception while retrieving bundle context ", e);
            Object[] args = new Object[]{e.getMessage()};
            throw new FormsNDocumentsException("AEM-FMG-700-005", args);
        }
        logger.trace("Exiting fetchReviewInfo.");
        return reviewInfo;
    }

    @Override
    public void beginReview(String reviewName, String reviewDescription, String deadline, String[] reviewers, String assetPath) throws FormsNDocumentsException {
        logger.trace("Entering beginReview.");
        Session bundleSession = null;
        ResourceResolver bundleResourceResolver = null;
        try {
            bundleSession = FMUtils.getFnDServiceUserSession(this.slingRepository);
            bundleResourceResolver = RnCUtil.getResourceResolver(bundleSession, this.resourceResolverFactory);
            RnCUtil.checkAssetPathArgument(assetPath);
            RnCUtil.checkCreateReviewArguments(reviewName, reviewers, deadline, bundleResourceResolver);
            ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
            String initiatorId = this.resourceResolverHelper.getResourceResolverAs(Session.class).getUserID();
            this.createReviewContainer(assetPath, initiatorId, bundleSession, bundleResourceResolver);
            String underReviewProp = METADATA_PATH.substring(1) + "/" + "underReview";
            Node asset = RnCUtil.checkNodeExistance(assetPath, resourceResolver);
            if (asset.hasProperty(underReviewProp) && asset.getProperty(underReviewProp).getBoolean()) {
                logger.error(" Asset " + assetPath + " is already under review, can not start a new review.");
                Object[] args = new Object[]{assetPath};
                throw new FormsNDocumentsException("AEM-FMG-700-003", args);
            }
            Task task = RnCUtil.createProject(reviewName, assetPath, deadline, initiatorId, bundleResourceResolver, resourceResolver);
            String reviewProjectID = task.getId();
            String reviewProjectName = task.getName();
            Group reviewGroup = RnCUtil.createGroup(reviewProjectName + "_" + System.currentTimeMillis(), REVIEW_GROUPS_PATH, bundleResourceResolver);
            String reviewGroupId = reviewGroup.getID();
            RnCUtil.addUserToGroup(initiatorId, reviewGroupId, bundleResourceResolver);
            String reviewId = this.createReviewNode(assetPath, reviewProjectName, reviewGroupId, bundleSession, bundleResourceResolver);
            this.addAssetReviewInfo(assetPath, reviewName, reviewDescription, reviewProjectID, deadline, reviewGroupId, reviewId, bundleResourceResolver);
            for (String reviewer : reviewers) {
                this.addReviewerTask(reviewProjectID, reviewName, deadline, reviewer, assetPath, reviewGroupId, reviewDescription, bundleResourceResolver, resourceResolver);
                RnCUtil.addUserToGroup(reviewer, reviewGroupId, bundleResourceResolver);
            }
            bundleSession.save();
        }
        catch (RepositoryException e) {
            logger.error("Exception while creation of review ", e);
            Object[] args = null;
            throw new FormsNDocumentsException("AEM-FMG-700-004", args);
        }
        catch (LoginException e) {
            logger.error("Exception while retrieving bundle context ", e);
            Object[] args = new Object[]{e.getMessage()};
            throw new FormsNDocumentsException("AEM-FMG-700-005", args);
        }
        catch (TaskManagerException e) {
            logger.error("Exception while creation of Task ", e);
            Object[] args = null;
            throw new FormsNDocumentsException("AEM-FMG-700-006", args);
        }
        finally {
            if (bundleResourceResolver != null) {
                bundleResourceResolver.close();
            }
            if (bundleSession != null) {
                bundleSession.logout();
            }
        }
        logger.trace("Exiting beginReview.");
    }

    @Override
    public void endReview(String assetPath) throws FormsNDocumentsException {
        logger.trace("Entering endReview.");
        RnCUtil.checkAssetPathArgument(assetPath);
        ResourceResolver currentResourceResolver = this.resourceResolverHelper.getResourceResolver();
        String currentUserID = currentResourceResolver.getUserID();
        RnCUtil.checkNodeExistance(assetPath, currentResourceResolver);
        Map<String, String> reviewInfo = this.fetchReviewInfo(currentResourceResolver, assetPath);
        if (!currentUserID.equals(reviewInfo.get("reviewInitiator"))) {
            logger.error(" Current User " + currentUserID + " is not the initiator of review for asset " + assetPath + " , and only initiator can end the review.");
            Object[] args = new Object[]{currentUserID, assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-020", args);
        }
        String reviewProjectName = reviewInfo.get("reviewProjectName");
        String reviewID = reviewInfo.get("reviewId");
        try (ResourceResolver bundleResourceResolver = null;){
            RnCUtil.terminateProjectActiveTasks(reviewProjectName, currentResourceResolver);
            this.removeAssetReviewInfo(assetPath, currentResourceResolver);
            currentResourceResolver.commit();
            bundleResourceResolver = FMUtils.getFnDServiceUserResourceResolver(this.resourceResolverFactory);
            this.cleanUpPermissions(assetPath, reviewInfo.get("reviewGroup"), reviewID, bundleResourceResolver, currentResourceResolver);
            RnCUtil.removeGroup(reviewInfo.get("reviewGroup"), bundleResourceResolver);
            bundleResourceResolver.commit();
        }
        logger.trace("Exiting endReview.");
    }

    @Override
    public void updateReview(String assetPath, String reviewDescription, String deadline, String[] reviewers) throws FormsNDocumentsException {
        logger.trace("Entering updateReview.");
        try (ResourceResolver bundleResourceResolver = null;){
            bundleResourceResolver = FMUtils.getFnDServiceUserResourceResolver(this.resourceResolverFactory);
            ResourceResolver currentResourceResolver = this.resourceResolverHelper.getResourceResolver();
            RnCUtil.checkUpdateReviewArguments(reviewers, deadline, bundleResourceResolver);
            RnCUtil.checkNodeExistance(assetPath, currentResourceResolver);
            String currentUserID = currentResourceResolver.getUserID();
            Map<String, String> reviewInfo = this.fetchReviewInfo(currentResourceResolver, assetPath);
            if (!currentUserID.equals(reviewInfo.get("reviewInitiator"))) {
                logger.error(" Current User " + currentUserID + " is not the initiator of review for asset " + assetPath + " , and only initiator can end the review.");
                Object[] args = new Object[]{currentUserID, assetPath};
                throw new FormsNDocumentsException("AEM-FMG-700-020", args);
            }
            Node reviewNode = RnCUtil.getNode(assetPath + REVIEW_CONTAINER_PATH + "/" + reviewInfo.get("reviewId"), currentResourceResolver);
            if (reviewNode == null) {
                Object[] args = new Object[]{reviewInfo.get("reviewId"), assetPath};
                throw new FormsNDocumentsException("AEM-FMG-700-023", args);
            }
            if (reviewDescription != null && !reviewDescription.equals(reviewInfo.get("reviewDescription"))) {
                RnCUtil.updateProjectDescription(reviewInfo.get("reviewProjectName"), reviewDescription, currentResourceResolver);
                reviewNode.setProperty("reviewDescription", reviewDescription);
            } else {
                reviewDescription = reviewInfo.get("reviewDescription");
            }
            if (deadline != null && !deadline.equals(reviewInfo.get("reviewDeadline"))) {
                RnCUtil.updateProjectDeadline(reviewInfo.get("reviewProjectName"), deadline, currentResourceResolver);
                reviewNode.setProperty("reviewDeadline", deadline);
            } else {
                deadline = reviewInfo.get("reviewDeadline");
            }
            Map<String, List<String>> reviewersDiff = this.getReviewersDiff(reviewers, reviewInfo.get("reviewGroup"), bundleResourceResolver);
            List<String> removedReviewers = reviewersDiff.get(REMOVED_REVIEWERS);
            List<String> addedReviewers = reviewersDiff.get(ADDED_REVIEWERS);
            for (String reviewer : removedReviewers) {
                this.removeReviewerTask(reviewInfo.get("reviewProjectName"), reviewer, reviewInfo.get("reviewGroup"), reviewInfo.get("reviewInitiator"), currentResourceResolver);
                if (reviewer.equals(reviewInfo.get("reviewInitiator"))) continue;
                RnCUtil.removeUserFromGroup(reviewer, reviewInfo.get("reviewGroup"), bundleResourceResolver);
            }
            for (String reviewer : addedReviewers) {
                this.addReviewerTask(reviewInfo.get("reviewProjectName"), reviewInfo.get("reviewName"), deadline, reviewer, assetPath, reviewInfo.get("reviewGroup"), reviewDescription, bundleResourceResolver, currentResourceResolver);
                RnCUtil.addUserToGroup(reviewer, reviewInfo.get("reviewGroup"), bundleResourceResolver);
            }
            bundleResourceResolver.commit();
            currentResourceResolver.commit();
        }
        logger.trace("Exiting updateReview.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanReview(String assetPath, Session currentSession, boolean updateReviewProperties) throws FormsMgrException {
        logger.trace("Entering cleanReview.");
        RnCUtil.checkAssetPathArgument(assetPath);
        ResourceResolver currentResourceResolver = FMUtils.getResourceResolver(this.resourceResolverFactory, currentSession);
        RnCUtil.checkNodeExistance(assetPath, currentResourceResolver);
        Map<String, String> reviewInfo = this.fetchReviewInfo(currentResourceResolver, assetPath);
        String reviewProjectName = reviewInfo.get("reviewProjectName");
        String reviewID = reviewInfo.get("reviewId");
        try (ResourceResolver bundleResourceResolver = null;){
            bundleResourceResolver = FMUtils.getFnDServiceUserResourceResolver(this.resourceResolverFactory);
            if (updateReviewProperties) {
                try {
                    RnCUtil.terminateProjectActiveTasks(reviewProjectName, bundleResourceResolver);
                }
                catch (Exception e) {
                    logger.error("Exception while terminating task ", e);
                }
                try {
                    this.removeAssetReviewInfo(assetPath, bundleResourceResolver);
                }
                catch (Exception e) {
                    logger.error("Exception while setting asset review state ", e);
                }
                try {
                    this.cleanUpPermissions(assetPath, reviewInfo.get("reviewGroup"), reviewID, bundleResourceResolver, currentResourceResolver);
                }
                catch (Exception e) {
                    logger.error("Exception while removing review ACL ", e);
                }
            }
            try {
                RnCUtil.removeGroup(reviewInfo.get("reviewGroup"), bundleResourceResolver);
            }
            catch (Exception e) {
                logger.error("Exception while removing temporary review group ", e);
            }
            bundleResourceResolver.commit();
        }
        logger.trace("Exiting cleanReview.");
    }

    @Override
    public ResourceResolver getFnDServiceUserResourceResolver() {
        ResourceResolver serviceResourceResolver = null;
        try {
            serviceResourceResolver = FMUtils.getFnDServiceUserResourceResolver(this.resourceResolverFactory);
        }
        catch (LoginException e) {
            logger.error("Error while retrieving service session for system user 'fd-service'", e);
        }
        return serviceResourceResolver;
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

