/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.mojos.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

@Singleton
@Named(value="aemapp")
public class AemAppLifecycleMappingProvider
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private static final Map<String, LifecyclePhase> BINDINGS = new HashMap<String, LifecyclePhase>();
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    public AemAppLifecycleMappingProvider() {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(BINDINGS);
        this.lifecycleMapping = new LifecycleMapping(){

            public Map<String, Lifecycle> getLifecycles() {
                return Collections.singletonMap(AemAppLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY, AemAppLifecycleMappingProvider.this.defaultLifecycle);
            }

            public List<String> getOptionalMojos(String lifecycle) {
                return null;
            }

            public Map<String, String> getPhases(String lifecycle) {
                if (AemAppLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                    return AemAppLifecycleMappingProvider.this.defaultLifecycle.getPhases();
                }
                return null;
            }
        };
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }

    static {
        BINDINGS.put("package", new LifecyclePhase("com.adobe.aem:aemanalyser-maven-plugin:package-app"));
        BINDINGS.put("verify", new LifecyclePhase("com.adobe.aem:aemanalyser-maven-plugin:project-analyse"));
        BINDINGS.put("install", new LifecyclePhase("org.apache.maven.plugins:maven-install-plugin:install"));
        BINDINGS.put("deploy", new LifecyclePhase("org.apache.maven.plugins:maven-deploy-plugin:deploy"));
    }
}

