/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl.granite;

import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow;
import com.adobe.granite.workflow.exec.InboxItem;
import com.adobe.granite.workflow.exec.Status;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowNode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

public class SyntheticWorkItem
implements InvocationHandler {
    private static final String CURRENT_ASSIGNEE = "Synthetic Workflow";
    private final UUID uuid = UUID.randomUUID();
    private Date timeStarted = null;
    private Date timeEnded = null;
    private Date dueTime = null;
    private Date progressBeginTime = null;
    private Workflow workflow;
    private final WorkflowData workflowData;
    private MetaDataMap metaDataMap = new SyntheticMetaDataMap();
    private InboxItem.Priority priority = null;

    private SyntheticWorkItem(WorkflowData workflowData) {
        this.workflowData = workflowData;
        this.timeStarted = new Date();
    }

    public static SyntheticWorkItem createSyntheticWorkItem(WorkflowData workflowData) {
        return new SyntheticWorkItem(workflowData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getTimeStarted": {
                return this.getTimeStarted();
            }
            case "getTimeEnded": {
                return this.getTimeEnded();
            }
            case "getWorkflow": {
                return this.getWorkflow();
            }
            case "getNode": {
                return this.getNode();
            }
            case "getId": {
                return this.getId();
            }
            case "getWorkflowData": {
                return this.getWorkflowData();
            }
            case "getCurrentAssignee": {
                return this.getCurrentAssignee();
            }
            case "setDueTime": {
                if (args.length > 0) {
                    this.setDueTime((Date)args[0]);
                }
                return new Object();
            }
            case "setProgressBeginTime": {
                this.setProgressBeginTime((Date)args[0]);
                return new Object();
            }
            case "setPriority": {
                this.setPriority((InboxItem.Priority)args[0]);
                return new Object();
            }
            case "setTimeEnded": {
                this.setTimeEnded((Date)args[0]);
                return new Object();
            }
            case "getMetaDataMap": {
                return this.getMetaDataMap();
            }
        }
        throw new UnsupportedOperationException("GRANITE SYNTHETICWORKFLOW ITEM >> NO IMPLEMENTATION FOR " + methodName);
    }

    public final String getId() {
        return this.uuid.toString() + "_" + this.getWorkflowData().getPayload();
    }

    public final Date getTimeStarted() {
        return this.timeStarted == null ? null : (Date)this.timeStarted.clone();
    }

    public final Date getTimeEnded() {
        return this.timeEnded == null ? null : (Date)this.timeEnded.clone();
    }

    public Date getDueTime() {
        return this.dueTime == null ? null : (Date)this.dueTime.clone();
    }

    public Date getProgressBeginTime() {
        return this.progressBeginTime == null ? null : (Date)this.progressBeginTime.clone();
    }

    public final void setTimeEnded(Date timeEnded) {
        this.timeEnded = timeEnded == null ? null : (Date)timeEnded.clone();
    }

    public final WorkflowData getWorkflowData() {
        return this.workflowData;
    }

    public final String getCurrentAssignee() {
        return CURRENT_ASSIGNEE;
    }

    public void setDueTime(Date date) {
        this.dueTime = Optional.ofNullable(date).map(date1 -> (Date)date1.clone()).orElse(null);
    }

    public void setProgressBeginTime(Date date) {
        this.progressBeginTime = Optional.ofNullable(date).map(date1 -> (Date)date1.clone()).orElse(null);
    }

    public void setPriority(InboxItem.Priority priority) {
        this.priority = priority;
    }

    public final MetaDataMap getMetaDataMap() {
        return this.metaDataMap;
    }

    public final Workflow getWorkflow() {
        return this.workflow;
    }

    public final void setWorkflow(WorkItem proxy, SyntheticWorkflow workflow) {
        workflow.setActiveWorkItem(proxy);
        this.workflow = workflow;
    }

    public Status getStatus() {
        return Status.ACTIVE;
    }

    public final WorkflowNode getNode() {
        return null;
    }

    public String getItemType() {
        return CURRENT_ASSIGNEE;
    }

    public String getItemSubType() {
        return null;
    }

    public String getContentPath() {
        if ("JCR_PATH".equals(this.workflowData.getPayloadType())) {
            return (String)this.workflowData.getPayload();
        }
        return null;
    }

    public InboxItem.Priority getPriority() {
        return this.priority;
    }
}

