/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static boolean getPropertyBoolean(Resource resource, String namePattern) {
        return (Boolean)resource.getValueMap().get(namePattern, (Object)false);
    }

    public static Calendar getPropertyCalendar(Resource resource, String namePattern) {
        return (Calendar)resource.getValueMap().get(namePattern, Calendar.class);
    }

    public static Date getPropertyDate(Resource resource, String namePattern) {
        return (Date)resource.getValueMap().get(namePattern, Date.class);
    }

    public static BigDecimal getPropertyDecimal(Resource resource, String namePattern) {
        return (BigDecimal)resource.getValueMap().get(namePattern, BigDecimal.class);
    }

    public static Double getPropertyDouble(Resource resource, String namePattern) {
        return (Double)resource.getValueMap().get(namePattern, Double.class);
    }

    public static Long getPropertyLong(Resource resource, String namePattern) {
        return (Long)resource.getValueMap().get(namePattern, Long.class);
    }

    public static Resource getPropertyReference(Resource resource, String namePattern) {
        String referencePath = ResourceUtil.getPropertyString(resource, namePattern);
        if (StringUtils.isNotBlank((CharSequence)referencePath)) {
            return resource.getResourceResolver().getResource(referencePath);
        }
        return null;
    }

    public static String getPropertyString(Resource resource, String namePattern) {
        return (String)resource.getValueMap().get(namePattern, String.class);
    }

    public static List<String> getPropertyStrings(Resource resource, String namePattern) {
        String[] vals = (String[])resource.getValueMap().get(namePattern, String[].class);
        return vals != null ? Arrays.asList(vals) : Collections.EMPTY_LIST;
    }
}

