/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.AbstractAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAce;
import com.adobe.acs.commons.users.impl.EnsureAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import com.adobe.acs.commons.users.impl.Operation;
import com.adobe.acs.commons.users.impl.ServiceUser;
import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Ensure Service User", configurationFactory=true, metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Ensure Service User: {operation} {principalName}"})})
@Service(value={EnsureServiceUser.class, EnsureAuthorizable.class})
public final class EnsureServiceUser
implements EnsureAuthorizable {
    @Property(label="Ensure immediately", boolValue={true}, description="Ensure on activation. When set to false, this must be ensured via the JMX MBean.")
    public static final String PROP_ENSURE_IMMEDIATELY = "ensure-immediately";
    public static final String DEFAULT_OPERATION = "add";
    @Property(label="Operation", description="Defines if the service user (principal name) should be adjusted to align with this config or removed completely", options={@PropertyOption(name="add", value="Ensure existence (add)"), @PropertyOption(name="remove", value="Ensure extinction (remove)")})
    public static final String PROP_OPERATION = "operation";
    @Property(label="Principal Name", description="The service user's principal name")
    public static final String PROP_PRINCIPAL_NAME = "principalName";
    @Property(label="ACEs", description="This field is ignored if the Operation is set to 'Ensure extinction' (remove)", cardinality=0x7FFFFFFF)
    public static final String PROP_ACES = "aces";
    private static final Logger log = LoggerFactory.getLogger(EnsureServiceUser.class);
    private static final String SERVICE_NAME = "ensure-service-user";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "ensure-service-user");
    private static final boolean DEFAULT_ENSURE_IMMEDIATELY = true;
    private ServiceUser serviceUser = null;
    private Operation operation = null;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private EnsureAce ensureAce;

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public ServiceUser getAuthorizable() {
        return this.serviceUser;
    }

    @Override
    public void ensure(Operation operation, AbstractAuthorizable serviceUser) throws EnsureAuthorizableException {
        long start = System.currentTimeMillis();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            if (Operation.ADD.equals((Object)operation)) {
                this.ensureExistance(resourceResolver, (ServiceUser)serviceUser);
            } else if (Operation.REMOVE.equals((Object)operation)) {
                this.ensureRemoval(resourceResolver, (ServiceUser)serviceUser);
            } else {
                throw new EnsureAuthorizableException("Unable to determine Ensure Service User operation Could not create or locate value system user (it is null).");
            }
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
                log.debug("Persisted change to Service User [ {} ]", (Object)serviceUser.getPrincipalName());
            } else {
                log.debug("No changes required for Service User [ {} ]. Skipping...", (Object)serviceUser.getPrincipalName());
            }
            log.info("Successfully ensured [ {} ] of Service User [ {} ] in [ {} ms ]", new Object[]{operation, this.getAuthorizable().getPrincipalName(), String.valueOf(System.currentTimeMillis() - start)});
        }
        catch (Exception e) {
            throw new EnsureAuthorizableException(String.format("Failed to ensure [ %s ] of Service User [ %s ]", operation.toString(), serviceUser.getPrincipalName()), e);
        }
    }

    protected void ensureExistance(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureAuthorizableException {
        User systemUser = this.ensureSystemUser(resourceResolver, serviceUser);
        if (systemUser != null) {
            this.ensureAce.ensureAces(resourceResolver, (Authorizable)systemUser, serviceUser);
        } else {
            log.error("Could not create or locate System User with principal name [ {} ]", (Object)serviceUser.getPrincipalName());
        }
    }

    private void ensureRemoval(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureAuthorizableException {
        User systemUser = this.findSystemUser(resourceResolver, serviceUser.getPrincipalName());
        this.ensureAce.removeAces(resourceResolver, (Authorizable)systemUser, serviceUser);
        if (systemUser != null) {
            systemUser.remove();
        }
    }

    private User ensureSystemUser(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureAuthorizableException {
        User user = this.findSystemUser(resourceResolver, serviceUser.getPrincipalName());
        if (user == null) {
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            log.debug("Requesting creation of system user [ {} ] at [ {} ]", (Object)serviceUser.getPrincipalName(), (Object)serviceUser.getIntermediatePath());
            user = userManager.createSystemUser(serviceUser.getPrincipalName(), serviceUser.getIntermediatePath());
            log.debug("Created system user at [ {} ]", (Object)user.getPath());
        }
        return user;
    }

    private User findSystemUser(ResourceResolver resourceResolver, String principalName) throws RepositoryException, EnsureAuthorizableException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        User user = null;
        Authorizable authorizable = userManager.getAuthorizable(principalName);
        if (authorizable != null) {
            if (authorizable instanceof User) {
                user = (User)authorizable;
                if (!user.isSystemUser()) {
                    throw new EnsureAuthorizableException(String.format("User [ %s ] ensureExistance at [ %s ] but is NOT a system user", principalName, user.getPath()));
                }
            } else {
                throw new EnsureAuthorizableException(String.format("Authorizable [ %s ] at [ %s ] is not a user", principalName, authorizable.getPath()));
            }
        }
        return user;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        boolean ensureImmediately = PropertiesUtil.toBoolean((Object)config.get(PROP_ENSURE_IMMEDIATELY), (boolean)true);
        String operationStr = StringUtils.upperCase((String)PropertiesUtil.toString((Object)config.get(PROP_OPERATION), (String)DEFAULT_OPERATION));
        try {
            this.operation = Operation.valueOf(operationStr);
            this.serviceUser = new ServiceUser(config);
            if (ensureImmediately) {
                this.ensure(this.operation, this.getAuthorizable());
            } else {
                log.info("This Service User is configured to NOT ensure immediately. Please ensure this Service User via the JMX MBean.");
            }
        }
        catch (EnsureAuthorizableException e) {
            log.error("Unable to ensure Service User [ {} ]", (Object)PropertiesUtil.toString((Object)config.get(PROP_PRINCIPAL_NAME), (String)"Undefined Service User Principal Name"), (Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown Ensure Service User operation [ " + operationStr + " ]", e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindEnsureAce(EnsureAce ensureAce) {
        this.ensureAce = ensureAce;
    }

    protected void unbindEnsureAce(EnsureAce ensureAce) {
        if (this.ensureAce == ensureAce) {
            this.ensureAce = null;
        }
    }
}

