/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.throttling;

import com.adobe.acs.commons.throttling.CpuLoadEstimator;
import com.adobe.acs.commons.throttling.ThrottlingConfiguration;
import com.adobe.acs.commons.throttling.ThrottlingDecision;
import com.adobe.acs.commons.throttling.ThrottlingState;
import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"sling.filter.scope=REQUEST"})
@Designate(ocd=Config.class, factory=true)
public class RequestThrottler
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestThrottler.class);
    ThrottlingState state;
    private Config config;
    CpuLoadEstimator loadEstimator;
    List<Pattern> filteredPaths;
    Clock clock;

    @Activate
    @Modified
    protected void activate(Config c) {
        this.config = c;
        ThrottlingConfiguration tc = new ThrottlingConfiguration(c.max_requests_per_minute(), c.start_throttling_percentage());
        this.loadEstimator = new CpuLoadEstimator(tc);
        this.clock = Clock.systemUTC();
        this.state = new ThrottlingState(this.clock, this.loadEstimator);
        this.filteredPaths = Arrays.asList(this.config.filtered_paths()).stream().map(s -> Pattern.compile(s)).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest req = (SlingHttpServletRequest)request;
        SlingHttpServletResponse res = (SlingHttpServletResponse)response;
        if (this.needsFiltering(req.getResource().getPath())) {
            this.doFilterInternal(req, res);
        }
        chain.doFilter(request, response);
    }

    protected void doFilterInternal(SlingHttpServletRequest req, SlingHttpServletResponse res) throws IOException {
        ThrottlingDecision decision = this.state.evaluateThrottling();
        if (decision.getState().equals((Object)ThrottlingDecision.State.THROTTLE)) {
            if (this.config.reject_on_throttle()) {
                String msg = "Request rejected because of throttling: " + decision.message;
                req.getRequestProgressTracker().log(msg);
                LOG.info(msg);
                res.sendError(this.config.http_status_on_reject(), decision.message);
            } else {
                String msg = "Throttling request (" + decision.message + ")";
                req.getRequestProgressTracker().log(msg);
                LOG.info(msg);
                this.delay(decision.delay);
            }
        } else {
            req.getRequestProgressTracker().log("Request not throttled");
        }
    }

    protected boolean needsFiltering(String path) {
        return this.filteredPaths.stream().anyMatch(p -> p.matcher(path).matches());
    }

    protected void delay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.warn("An ACS AEM Commons Fast Action Manager thread running sleep(..) was interrupted.The interruption did NOT come FROM ACS AEM Commons as it's code no longer interrupts ANY thread. ACS AEM Commons is simply alerting you of this interruption in this log message, and will now restore the interrupted status via a call to: Thread.currentThread().interrupt();", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Request Throttler", description="Configuration for the ACS AEM Commons Request Throttler")
    public static @interface Config {
        @AttributeDefinition(name="maximum number of requests per minute", description="The maximum number of requests allowed if the CPU usage exceeds the configured value")
        public int max_requests_per_minute() default 60;

        @AttributeDefinition(name="Start throttling at X percent CPU load", description="The CPU usage in percent when the throttling starts")
        public int start_throttling_percentage() default 70;

        @AttributeDefinition(name="reject request on throttling", description="Check if throttled should be rejected and not be further handled")
        public boolean reject_on_throttle() default false;

        @AttributeDefinition(name="HTTP statuscode on reject", description="the statuscode in case the requests are rejected (e.g. 500")
        public int http_status_on_reject() default 503;

        @AttributeDefinition(name="Filtered paths", description="The paths (regular expressions) which are considered for this service")
        public String[] filtered_paths();

        public String webconsole_configurationFactory_nameHint() default "{filtered.paths}";
    }
}

