/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.notifications.impl;

import com.adobe.acs.commons.notifications.InboxNotification;
import com.adobe.acs.commons.notifications.InboxNotificationSender;
import com.adobe.acs.commons.notifications.impl.InboxNotificationImpl;
import com.adobe.granite.taskmanagement.Task;
import com.adobe.granite.taskmanagement.TaskAction;
import com.adobe.granite.taskmanagement.TaskManager;
import com.adobe.granite.taskmanagement.TaskManagerException;
import com.adobe.granite.taskmanagement.TaskManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class InboxNotificationSenderImpl
implements InboxNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(InboxNotificationSenderImpl.class);
    public static final String NOTIFICATION_TASK_TYPE = "Notification";

    @Override
    public InboxNotification buildInboxNotification() {
        return new InboxNotificationImpl();
    }

    @Override
    public void sendInboxNotification(ResourceResolver resourceResolver, InboxNotification inboxNotification) throws TaskManagerException {
        log.debug("Sending Inbox Notification [ {} ] to [ {} ]", (Object)inboxNotification.getTitle(), (Object)inboxNotification.getAssignee());
        TaskManager taskManager = (TaskManager)resourceResolver.adaptTo(TaskManager.class);
        taskManager.createTask(this.createTask(taskManager, inboxNotification));
    }

    @Override
    public void sendInboxNotifications(ResourceResolver resourceResolver, List<InboxNotification> inboxNotifications) throws TaskManagerException {
        for (InboxNotification notificationDetails : inboxNotifications) {
            this.sendInboxNotification(resourceResolver, notificationDetails);
        }
    }

    private Task createTask(TaskManager taskManager, InboxNotification inboxNotification) throws TaskManagerException {
        Task newTask = taskManager.getTaskManagerFactory().newTask(NOTIFICATION_TASK_TYPE);
        newTask.setName(inboxNotification.getTitle());
        newTask.setContentPath(inboxNotification.getContentPath());
        newTask.setDescription(inboxNotification.getMessage());
        newTask.setInstructions(inboxNotification.getInstructions());
        newTask.setCurrentAssignee(inboxNotification.getAssignee());
        Object[] notificationActions = inboxNotification.getNotificationActions();
        if (ArrayUtils.isNotEmpty((Object[])notificationActions)) {
            List<TaskAction> taskActions = this.createTaskActionsList((String[])notificationActions, taskManager);
            newTask.setActions(taskActions);
        }
        return newTask;
    }

    private List<TaskAction> createTaskActionsList(String[] notificationActions, TaskManager taskManager) {
        TaskManagerFactory taskManagerFactory = taskManager.getTaskManagerFactory();
        ArrayList<TaskAction> taskActions = new ArrayList<TaskAction>();
        for (String action : notificationActions) {
            TaskAction newTaskAction = taskManagerFactory.newTaskAction(action);
            taskActions.add(newTaskAction);
        }
        return taskActions;
    }
}

