/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.commons.Externalizer;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.search.QueryBuilder;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.xss.XSSAPI;

@Component
@Service
@Property(name="service.ranking", intValue={4500})
public final class AemObjectInjector
implements Injector {
    @Reference
    private XSSAPI genericXxsApi;

    public String getName() {
        return "define-objects";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (!(adaptable instanceof Resource) && !(adaptable instanceof SlingHttpServletRequest)) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.getClassOrGenericParam(declaredType);
        ObjectType typeEnum = ObjectType.fromClassAndName(clazz, name);
        if (typeEnum == null) {
            return null;
        }
        switch (typeEnum) {
            case RESOURCE: {
                return InjectorUtils.getResource(adaptable);
            }
            case RESOURCE_RESOLVER: {
                return InjectorUtils.getResourceResolver(adaptable);
            }
            case COMPONENT_CONTEXT: {
                return InjectorUtils.getComponentContext(adaptable);
            }
            case PAGE_MANAGER: {
                return InjectorUtils.getPageManager(adaptable);
            }
            case CURRENT_PAGE: {
                return InjectorUtils.getCurrentPage(adaptable);
            }
            case RESOURCE_PAGE: {
                return InjectorUtils.getResourcePage(adaptable);
            }
            case DESIGNER: {
                return InjectorUtils.getDesigner(adaptable);
            }
            case CURRENT_DESIGN: {
                return InjectorUtils.getCurrentDesign(adaptable);
            }
            case RESOURCE_DESIGN: {
                return InjectorUtils.getResourceDesign(adaptable);
            }
            case CURRENT_STYLE: {
                return InjectorUtils.getCurrentStyle(adaptable);
            }
            case SESSION: {
                return InjectorUtils.getSession(adaptable);
            }
            case XSS_API: {
                return this.resolveXssApi(adaptable);
            }
            case LOCALE: {
                return this.resolveLocale(adaptable);
            }
            case TAG_MANAGER: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, TagManager.class);
            }
            case ASSET_MANAGER: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, com.adobe.granite.asset.api.AssetManager.class);
            }
            case ASSET_MANAGER_OLD: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, AssetManager.class);
            }
            case QUERY_BUILDER: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, QueryBuilder.class);
            }
            case CONTENT_POLICY_MANAGER: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, ContentPolicyManager.class);
            }
            case EXTERNALIZER: {
                return InjectorUtils.adaptFromResourceResolver(adaptable, Externalizer.class);
            }
        }
        return null;
    }

    private Object resolveLocale(Object adaptable) {
        Page page = InjectorUtils.getResourcePage(adaptable);
        if (page != null) {
            return page.getLanguage(false);
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getLocale();
        }
        return null;
    }

    private Object resolveXssApi(Object adaptable) {
        XSSAPI specificApi = InjectorUtils.getXssApi(adaptable);
        if (specificApi != null) {
            return specificApi;
        }
        return this.genericXxsApi;
    }

    protected void bindGenericXxsApi(XSSAPI xSSAPI) {
        this.genericXxsApi = xSSAPI;
    }

    protected void unbindGenericXxsApi(XSSAPI xSSAPI) {
        if (this.genericXxsApi == xSSAPI) {
            this.genericXxsApi = null;
        }
    }

    private static enum ObjectType {
        RESOURCE,
        RESOURCE_RESOLVER,
        COMPONENT_CONTEXT,
        PAGE_MANAGER,
        CURRENT_PAGE,
        RESOURCE_PAGE,
        DESIGNER,
        CURRENT_DESIGN,
        RESOURCE_DESIGN,
        CURRENT_STYLE,
        SESSION,
        LOCALE,
        TAG_MANAGER,
        QUERY_BUILDER,
        CONTENT_POLICY_MANAGER,
        ASSET_MANAGER,
        ASSET_MANAGER_OLD,
        EXTERNALIZER,
        XSS_API;

        private static final String RESOURCE_PAGE_STRING = "resourcePage";
        private static final String RESOURCE_DESIGN_STRING = "resourceDesign";

        public static ObjectType fromClassAndName(Class<?> classOrGenericParam, String name) {
            if (classOrGenericParam.isAssignableFrom(Resource.class)) {
                return RESOURCE;
            }
            if (classOrGenericParam.isAssignableFrom(ResourceResolver.class)) {
                return RESOURCE_RESOLVER;
            }
            if (classOrGenericParam.isAssignableFrom(ComponentContext.class)) {
                return COMPONENT_CONTEXT;
            }
            if (classOrGenericParam.isAssignableFrom(TagManager.class)) {
                return TAG_MANAGER;
            }
            if (classOrGenericParam.isAssignableFrom(PageManager.class)) {
                return PAGE_MANAGER;
            }
            if (classOrGenericParam.isAssignableFrom(Page.class)) {
                return ObjectType.resolvePageFromName(name);
            }
            if (classOrGenericParam.isAssignableFrom(Designer.class)) {
                return DESIGNER;
            }
            if (classOrGenericParam.isAssignableFrom(Design.class)) {
                return ObjectType.resolveDesignFromName(name);
            }
            if (classOrGenericParam.isAssignableFrom(Style.class)) {
                return CURRENT_STYLE;
            }
            if (classOrGenericParam.isAssignableFrom(Session.class)) {
                return SESSION;
            }
            if (classOrGenericParam.isAssignableFrom(XSSAPI.class)) {
                return XSS_API;
            }
            if (classOrGenericParam.isAssignableFrom(Locale.class)) {
                return LOCALE;
            }
            if (classOrGenericParam.isAssignableFrom(com.adobe.granite.asset.api.AssetManager.class)) {
                return ASSET_MANAGER;
            }
            if (classOrGenericParam.isAssignableFrom(AssetManager.class)) {
                return ASSET_MANAGER_OLD;
            }
            if (classOrGenericParam.isAssignableFrom(QueryBuilder.class)) {
                return QUERY_BUILDER;
            }
            if (classOrGenericParam.isAssignableFrom(ContentPolicyManager.class)) {
                return CONTENT_POLICY_MANAGER;
            }
            if (classOrGenericParam.isAssignableFrom(Externalizer.class)) {
                return EXTERNALIZER;
            }
            return null;
        }

        private static ObjectType resolveDesignFromName(String name) {
            if (name.equalsIgnoreCase(RESOURCE_DESIGN_STRING)) {
                return RESOURCE_DESIGN;
            }
            return CURRENT_DESIGN;
        }

        private static ObjectType resolvePageFromName(String name) {
            if (name.equalsIgnoreCase(RESOURCE_PAGE_STRING)) {
                return RESOURCE_PAGE;
            }
            return CURRENT_PAGE;
        }
    }
}

