/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class NamesFilter {
    private List<String> include = new ArrayList<String>();
    private List<String> exclude = new ArrayList<String>();

    NamesFilter() {
    }

    NamesFilter(String filterString) {
        List filterExpressions = Optional.ofNullable(filterString).filter(StringUtils::isNotEmpty).map(str -> str.trim().toLowerCase().split(",")).map(Arrays::asList).orElse(Collections.emptyList());
        for (String filterExpression : filterExpressions) {
            if (filterExpression.startsWith("+")) {
                this.include.add(filterExpression.substring(1));
                continue;
            }
            if (filterExpression.startsWith("-")) {
                this.exclude.add(filterExpression.substring(1));
                continue;
            }
            this.include.add(filterExpression);
        }
        this.include.removeAll(this.exclude);
    }

    boolean isNotValidName(String name) {
        return !this.isValidName(name);
    }

    private boolean isValidName(String name) {
        if (this.isEmptyFilter()) {
            return true;
        }
        if (this.isOnlyIncludeFiler()) {
            return this.isIncluded(name);
        }
        if (this.isOnlyExcludeFilter()) {
            return this.isNotExcluded(name);
        }
        return this.isIncluded(name) && this.isNotExcluded(name);
    }

    private boolean isNotExcluded(String name) {
        return !this.exclude.contains(name);
    }

    private boolean isIncluded(String name) {
        return this.include.contains(name);
    }

    private boolean isOnlyExcludeFilter() {
        return CollectionUtils.isNotEmpty(this.exclude) && CollectionUtils.isEmpty(this.include);
    }

    private boolean isOnlyIncludeFiler() {
        return CollectionUtils.isEmpty(this.exclude) && CollectionUtils.isNotEmpty(this.include);
    }

    private boolean isEmptyFilter() {
        return CollectionUtils.isEmpty(this.exclude) && CollectionUtils.isEmpty(this.include);
    }
}

