/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.impl;

import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={MarketoClientConfiguration.class})
public class MarketoClientConfigurationImpl
implements MarketoClientConfiguration {
    private final String clientId;
    private final String clientSecret;
    private final String endpointHost;
    private final String munchkinId;
    private final String serverInstance;

    @Inject
    public MarketoClientConfigurationImpl(@ValueMapValue @Named(value="clientId") String clientId, @ValueMapValue @Named(value="clientSecret") String clientSecret, @ValueMapValue @Named(value="endpointHost") String endpointHost, @ValueMapValue @Named(value="munchkinId") String munchkinId, @ValueMapValue @Named(value="serverInstance") String serverInstance) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.endpointHost = endpointHost;
        this.munchkinId = munchkinId;
        this.serverInstance = serverInstance;
    }

    private String getHost(String url) {
        String domainName;
        int port;
        int start = url.indexOf("://");
        start = url.startsWith("//") ? 2 : (start < 0 ? 0 : (start += 3));
        int end = url.indexOf(47, start);
        if (end < 0) {
            end = url.length();
        }
        if ((port = (domainName = url.substring(start, end)).indexOf(58)) >= 0) {
            domainName = domainName.substring(0, port);
        }
        return domainName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarketoClientConfigurationImpl other = (MarketoClientConfigurationImpl)obj;
        return !(this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId));
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getEndpointHost() {
        return this.getHost(this.endpointHost);
    }

    @Override
    public String getMunchkinId() {
        return this.munchkinId;
    }

    @Override
    public String getServerInstance() {
        return this.getHost(this.serverInstance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        return result;
    }
}

