/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(name="type", value={"bounded-resize"})
@Service(value={ImageTransformer.class})
public class BoundedResizeTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(BoundedResizeTransformerImpl.class);
    static final String TYPE = "bounded-resize";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_WIDTH_ALIAS = "w";
    private static final String KEY_HEIGHT = "height";
    private static final String KEY_HEIGHT_ALIAS = "h";
    private static final String KEY_UPSCALE = "upscale";

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        int originalWidth = layer.getWidth();
        int originalHeight = layer.getHeight();
        int width = (Integer)properties.get(KEY_WIDTH, (Object)((Integer)properties.get(KEY_WIDTH_ALIAS, (Object)originalWidth)));
        int height = (Integer)properties.get(KEY_HEIGHT, (Object)((Integer)properties.get(KEY_HEIGHT_ALIAS, (Object)originalHeight)));
        boolean upscale = (Boolean)properties.get(KEY_UPSCALE, (Object)false);
        if ((float)width / (float)originalWidth < (float)height / (float)originalHeight) {
            float aspect = (float)width / (float)layer.getWidth();
            height = Math.round((float)layer.getHeight() * aspect);
        } else {
            float aspect = (float)height / (float)layer.getHeight();
            width = Math.round((float)layer.getWidth() * aspect);
        }
        if (upscale || width <= originalWidth && height <= originalHeight) {
            layer.resize(width, height);
        }
        return layer;
    }
}

