/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.adobeio.service.impl;

import com.adobe.acs.commons.adobeio.service.EndpointService;
import com.adobe.acs.commons.adobeio.service.IntegrationService;
import com.google.gson.JsonObject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={HealthCheck.class}, property={"hc.name=ACS AEM Commons - Adobe I/O configuration", "hc.tags=adobeio", "hc.mbean.name=ACS AEM Commons - Adobe I/O health check"})
public class AdobeioHealthcheck
implements HealthCheck {
    @Reference
    private IntegrationService integrationService;
    @Reference
    private volatile Collection<EndpointService> endpoints;

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        boolean integrationOk = true;
        resultLog.debug("Health check for Adobe I/O", new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)this.integrationService.getApiKey())) {
            resultLog.debug("Starting validation for x-api-key {}", new Object[]{this.integrationService.getApiKey()});
        } else {
            resultLog.critical("No api key is specified in the OSGi-config", new Object[0]);
            integrationOk = false;
        }
        resultLog.debug("Obtaining the access token", new Object[0]);
        String accessToken = this.integrationService.getAccessToken();
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            resultLog.info("Access token succesfully obtained {}", new Object[]{accessToken});
        } else {
            resultLog.critical("Could not obtain the access token", new Object[0]);
            integrationOk = false;
        }
        if (!integrationOk) {
            resultLog.info("IntegrationService not healthy; skipping Endpoint checks.", new Object[0]);
        }
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            resultLog.warn("No Endpoint Services found.", new Object[0]);
            return new Result((ResultLog)resultLog);
        }
        for (EndpointService endpoint : this.endpoints) {
            this.execute(resultLog, endpoint);
        }
        resultLog.info("Healthcheck completed", new Object[0]);
        return new Result((ResultLog)resultLog);
    }

    private void execute(FormattingResultLog resultLog, EndpointService endpoint) {
        resultLog.info("Checking Adobe I/O endpoint {}", new Object[]{endpoint.getId()});
        if ("GET".equalsIgnoreCase(endpoint.getMethod())) {
            resultLog.debug("Executing Adobe I/O call to {}", new Object[]{endpoint.getUrl()});
            JsonObject json = endpoint.performIO_Action();
            if (json != null) {
                resultLog.debug("JSON-response {}", new Object[]{json.toString()});
                if (StringUtils.contains((CharSequence)json.toString(), (CharSequence)"error")) {
                    resultLog.critical("Error returned from the API-call", new Object[0]);
                }
            }
        } else {
            resultLog.debug("Method != GET, but {}", new Object[]{endpoint.getMethod()});
        }
    }
}

