/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal;

import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.sling.api.resource.ResourceResolver;

public final class WorkflowRemovalStatus {
    private static final String KEY_CHECKED_COUNT = "checkedCount";
    private static final String KEY_COMPLETED_AT = "completedAt";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_FORCE_QUIT_AT = "forceQuitAt";
    private static final String KEY_ERRED_AT = "erredAt";
    private static final String KEY_INITIATED_BY = "initiatedBy";
    private static final String KEY_REMOVED_COUNT = "removedCount";
    private static final String KEY_RUNNING = "running";
    private static final String KEY_STARTED_AT = "startedAt";
    private static final String DATE_FORMAT = "yyyy/MM/dd 'at' hh:mm:ss a z";
    private static final long MS_IN_SECOND = 1000L;
    private boolean running = true;
    private String initiatedBy;
    private Calendar startedAt;
    private Calendar completedAt;
    private Calendar erredAt;
    private Calendar forceQuitAt;
    private int checked = 0;
    private int removed = 0;

    public WorkflowRemovalStatus(ResourceResolver resourceResolver) {
        this.initiatedBy = resourceResolver.getUserID();
        this.startedAt = Calendar.getInstance();
        this.completedAt = null;
        this.erredAt = null;
        this.checked = 0;
        this.removed = 0;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setRunning(boolean running) {
        this.running = running;
    }

    public final String getInitiatedBy() {
        return this.initiatedBy;
    }

    public final String getStartedAt() {
        if (this.startedAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.startedAt.getTime());
    }

    public Calendar getStartedAtCal() {
        return this.startedAt;
    }

    public final String getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.completedAt.getTime());
    }

    public final void setCompletedAt(Calendar completedAt) {
        this.completedAt = completedAt;
    }

    public final int getChecked() {
        return this.checked;
    }

    public final void setChecked(int checked) {
        this.checked = checked;
    }

    public final int getRemoved() {
        return this.removed;
    }

    public final void setRemoved(int removed) {
        this.removed = removed;
    }

    public String getErredAt() {
        if (this.erredAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.erredAt.getTime());
    }

    public void setErredAt(Calendar erredAt) {
        this.erredAt = erredAt;
    }

    public void setForceQuitAt(Calendar forceQuitAt) {
        this.forceQuitAt = forceQuitAt;
    }

    public String getForceQuitAt() {
        if (this.forceQuitAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.forceQuitAt.getTime());
    }

    private long getDuration(Calendar start, Calendar end) {
        if (start == null || end == null || end.before(start)) {
            return 0L;
        }
        return (end.getTimeInMillis() - start.getTimeInMillis()) / 1000L;
    }

    public JsonObject getJSON() {
        JsonObject json = new JsonObject();
        json.addProperty(KEY_RUNNING, Boolean.valueOf(this.isRunning()));
        json.addProperty(KEY_INITIATED_BY, this.getInitiatedBy());
        json.addProperty(KEY_CHECKED_COUNT, (Number)this.getChecked());
        json.addProperty(KEY_REMOVED_COUNT, (Number)this.getRemoved());
        if (this.getStartedAt() != null) {
            json.addProperty(KEY_STARTED_AT, this.getStartedAt());
        }
        if (this.getErredAt() != null) {
            json.addProperty(KEY_ERRED_AT, this.getErredAt());
            json.addProperty(KEY_DURATION, (Number)this.getDuration(this.startedAt, this.erredAt));
        } else if (this.getForceQuitAt() != null) {
            json.addProperty(KEY_FORCE_QUIT_AT, this.getForceQuitAt());
            json.addProperty(KEY_DURATION, (Number)this.getDuration(this.startedAt, this.forceQuitAt));
        } else if (this.getCompletedAt() != null) {
            json.addProperty(KEY_COMPLETED_AT, this.getCompletedAt());
            json.addProperty(KEY_DURATION, (Number)this.getDuration(this.startedAt, this.completedAt));
        } else {
            json.addProperty(KEY_DURATION, (Number)this.getDuration(this.startedAt, Calendar.getInstance()));
        }
        return json;
    }
}

