/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.wcm.api.AuthoringUIMode;
import com.day.cq.wcm.api.AuthoringUIModeService;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(property={"sling.filter.scope=REQUEST", "sling.filter.methods=GET", "sling.filter.resource.pattern=/etc/acs-commons/.*", "sling.filter.extensions=html", "service.ranking:Integer=-2501"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class AcsCommonsConsoleAuthoringUIModeFilter
implements Filter {
    @Reference
    private AuthoringUIModeService authoringUIModeService;
    private static final String WCM_AUTHORING_MODE_COOKIE = "cq-authoring-mode";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
            if (!WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)slingRequest))) {
                Cookie authoringModeCookie = slingRequest.getCookie(WCM_AUTHORING_MODE_COOKIE);
                if (!(authoringModeCookie != null && authoringModeCookie.getValue() != null && authoringModeCookie.getValue().equals(AuthoringUIMode.TOUCH.name()) || slingResponse.isCommitted())) {
                    authoringModeCookie = new Cookie(WCM_AUTHORING_MODE_COOKIE, AuthoringUIMode.TOUCH.name());
                    authoringModeCookie.setPath(slingRequest.getContextPath() + "/etc/acs-commons");
                    authoringModeCookie.setMaxAge(604800);
                    slingResponse.addCookie(authoringModeCookie);
                }
                slingRequest.setAttribute(AuthoringUIMode.REQUEST_ATTRIBUTE_NAME, (Object)AuthoringUIMode.TOUCH);
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

