/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.ActionBatch;
import com.adobe.acs.commons.functions.CheckedFunction;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.request.builder.SlingHttpServletResponseResult;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;

public class RefreshFolderTumbnails
extends ProcessDefinition {
    public static final String FOLDER_THUMBNAIL = "/jcr:content/folderThumbnail";
    private static final int PLACEHOLDER_SIZE = 1024;
    private SlingRequestProcessor slingProcessor;
    @FormField(name="Starting Path", component=PathfieldComponent.FolderSelectComponent.class)
    private String startingPath = "/content/dam";
    @FormField(name="Mode", component=RadioComponent.EnumerationSelector.class, options={"default=placeholders"})
    private ThumbnailScanLogic scanMode = ThumbnailScanLogic.PLACEHOLDERS;
    @FormField(name="Dry Run", component=CheckboxComponent.class, options={"checked"})
    private boolean dryRun = true;
    private transient List<String> foldersToReplace = Collections.synchronizedList(new ArrayList());
    List<EnumMap<ReportColumns, String>> reportData = Collections.synchronizedList(new ArrayList());
    static ThreadLocal<String> scanResult = new ThreadLocal();

    public RefreshFolderTumbnails(SlingRequestProcessor slingProcessor) {
        this.slingProcessor = slingProcessor;
    }

    @Override
    public void init() {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.defineCriticalAction("Scan folders", rr, this::scanFolders);
        if (!this.dryRun) {
            instance.defineAction("Remove old thumbnails", rr, this::removeOldThumbnails);
            instance.defineAction("Rebuild thumbnails", rr, this::rebuildThumbnails);
        }
    }

    private void record(String path, String action, String description) {
        EnumMap<ReportColumns, String> row = new EnumMap<ReportColumns, String>(ReportColumns.class);
        row.put(ReportColumns.PATH, path);
        row.put(ReportColumns.ACTION, action);
        row.put(ReportColumns.DESCRIPTION, description);
        this.reportData.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericBlobReport report = new GenericBlobReport();
        report.setName("Rebuild thumbnails " + this.startingPath);
        report.setRows(this.reportData, ReportColumns.class);
        report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private void scanFolders(ActionManager manager) {
        TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
        visitor.setBreadthFirstMode();
        visitor.setResourceVisitor((folder, level) -> {
            String path = folder.getPath();
            manager.deferredWithResolver(rr -> {
                if (this.scanMode.shouldReplace(rr.getResource(path))) {
                    String result = scanResult.get();
                    scanResult.remove();
                    this.record(path, "Flagged", result);
                    this.foldersToReplace.add(path);
                }
            });
        });
        manager.deferredWithResolver(rr -> {
            this.record(this.startingPath, "Start", "Starting folder scan");
            visitor.accept(rr.getResource(this.startingPath));
        });
    }

    private void removeOldThumbnails(ActionManager manager) {
        ActionBatch batch = new ActionBatch(manager, 20);
        this.foldersToReplace.forEach(path -> batch.add(rr -> {
            Resource res = rr.getResource(path + FOLDER_THUMBNAIL);
            if (res != null) {
                rr.delete(res);
                this.record((String)path, "Deleted", "Existing thumbnail removed");
            }
        }));
        batch.commitBatch();
    }

    private void rebuildThumbnails(ActionManager manager) {
        this.foldersToReplace.forEach(path -> manager.deferredWithResolver(rr -> this.rebuildThumbnail((ResourceResolver)rr, (String)path)));
    }

    private void rebuildThumbnail(ResourceResolver rr, String folderPath) throws ServletException, IOException {
        Resource resource = rr.getResource(folderPath);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found at " + folderPath);
        }
        SlingHttpServletRequest req = Builders.newRequestBuilder((Resource)resource).withRequestMethod("GET").withSelectors(new String[]{"folderthumbnail"}).withExtension("jpg").withParameter("width", "200").withParameter("height", "120").build();
        SlingHttpServletResponseResult res = Builders.newResponseBuilder().build();
        this.slingProcessor.processRequest((HttpServletRequest)req, (HttpServletResponse)res, rr);
        res.flushBuffer();
        this.record(folderPath, "Rebuild", "Thumbnail was rebuilt");
    }

    protected static boolean isThumbnailMissing(Resource damFolder) {
        if (RefreshFolderTumbnails.isThumbnailManual(damFolder) || RefreshFolderTumbnails.isThumbnailAutomatic(damFolder)) {
            return false;
        }
        scanResult.set("Thumbnail missing");
        return true;
    }

    protected static boolean isPlaceholderThumbnail(Resource damFolder) throws IOException {
        Resource jcrContent = damFolder.getChild("jcr:content");
        if (jcrContent == null) {
            return false;
        }
        Resource thumbnail = jcrContent.getChild("folderThumbnail");
        if (thumbnail == null) {
            return false;
        }
        long size = RefreshFolderTumbnails.getBinarySize(thumbnail);
        if (size <= 1024L) {
            scanResult.set("Placeholder detected, " + (size <= 0L ? "no thumbnail data" : "size is " + size + " bytes"));
            return true;
        }
        return false;
    }

    private static long getBinarySize(Resource res) throws IOException {
        InputStream thumbnailData = (InputStream)res.adaptTo(InputStream.class);
        if (thumbnailData == null) {
            return -1L;
        }
        long size = 0L;
        long count = 0L;
        byte[] buf = new byte[1024];
        while ((count = (long)thumbnailData.read(buf)) > 0L) {
            size += count;
        }
        thumbnailData.close();
        return size;
    }

    protected static boolean isThumbnailContentsOutdated(Resource damFolder) {
        Resource contents = damFolder.getChild("jcr:content/folderThumbnail/jcr:content");
        if (RefreshFolderTumbnails.isThumbnailManual(damFolder)) {
            return false;
        }
        if (contents == null) {
            scanResult.set("No folder metadata, assuming contents outdated");
            return true;
        }
        Date thumbnailModified = (Date)contents.getValueMap().getOrDefault((Object)"jcr:lastModified", Date.class);
        String[] paths = (String[])contents.getValueMap().get("dam:folderThumbnailPaths", String[].class);
        if (thumbnailModified == null || paths == null || paths.length == 0) {
            scanResult.set("No folder thumbnails being tracked, assuming contents outdated");
            return true;
        }
        for (String assetPath : paths) {
            Resource assetResource = damFolder.getResourceResolver().getResource(assetPath);
            if (!RefreshFolderTumbnails.isAssetMissingOrNewer(assetResource, thumbnailModified)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isAssetMissingOrNewer(Resource asset, Date compareDate) {
        if (asset == null) {
            scanResult.set("Referenced asset missing");
            return true;
        }
        Resource content = asset.getChild("jcr:content");
        if (content == null) {
            scanResult.set("Referenced asset has no content node; " + asset.getPath());
            return true;
        }
        Date assetModified = (Date)content.getValueMap().get("jcr:lastModified", Date.class);
        if (assetModified == null) {
            scanResult.set("Referenced asset has no modified date; " + asset.getPath());
            return true;
        }
        if (assetModified.after(compareDate)) {
            scanResult.set("Referenced newer than folder; " + asset.getPath());
            return true;
        }
        return false;
    }

    protected static boolean isThumbnailManual(Resource damFolder) {
        return damFolder.getChild("jcr:content/manualThumbnail.jpg") != null || damFolder.getChild("jcr:content/manualThumbnail.png") != null;
    }

    protected static boolean isThumbnailAutomatic(Resource damFolder) {
        if (RefreshFolderTumbnails.isThumbnailManual(damFolder)) {
            return false;
        }
        if (damFolder.getChild("jcr:content/folderThumbnail") != null) {
            scanResult.set("Detected automatic thumbnail and no manual thumbnail");
            return true;
        }
        return false;
    }

    public static enum ReportColumns {
        PATH,
        ACTION,
        DESCRIPTION;

    }

    protected static enum ThumbnailScanLogic {
        MISSING(RefreshFolderTumbnails::isThumbnailMissing),
        PLACEHOLDERS(RefreshFolderTumbnails::isThumbnailMissing, RefreshFolderTumbnails::isPlaceholderThumbnail),
        OUTDATED(RefreshFolderTumbnails::isThumbnailMissing, RefreshFolderTumbnails::isPlaceholderThumbnail, RefreshFolderTumbnails::isThumbnailContentsOutdated),
        ALL_AUTOMATIC_OR_MISSING(RefreshFolderTumbnails::isThumbnailMissing, RefreshFolderTumbnails::isThumbnailAutomatic),
        ALL(r -> true);

        CheckedFunction<Resource, Boolean> test;

        private ThumbnailScanLogic(CheckedFunction<Resource, Boolean> ... tests) {
            this.test = CheckedFunction.or(tests);
        }

        public boolean shouldReplace(Resource r) throws Exception {
            return this.test.apply(r);
        }
    }
}

