/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.impl;

import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import com.adobe.acs.commons.marketo.MarketoClientConfigurationManager;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={MarketoClientConfigurationManager.class})
public class MarketoClientConfigurationManagerImpl
implements MarketoClientConfigurationManager {
    private static final String SUBSERVICE_NAME = "marketo-conf";
    private static final Logger log = LoggerFactory.getLogger(MarketoClientConfigurationManagerImpl.class);
    private final MarketoClientConfiguration configuration;

    @Inject
    public MarketoClientConfigurationManagerImpl(@Self SlingHttpServletRequest slingRequest, @OSGiService ConfigurationResourceResolver configRsrcRslvr, @OSGiService ResourceResolverFactory resolverFactory) throws LoginException {
        try (ResourceResolver resolver = resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SUBSERVICE_NAME));){
            String resourcePath = null;
            resourcePath = slingRequest.getResource().getPath().startsWith("/content") ? slingRequest.getResource().getPath() : slingRequest.getRequestPathInfo().getSuffixResource().getPath();
            Resource serviceResource = resolver.getResource(resourcePath);
            if (serviceResource != null) {
                log.debug("Using context path: {}", (Object)configRsrcRslvr.getContextPath(serviceResource));
                this.configuration = configRsrcRslvr.getResourceCollection(serviceResource, "settings", "cloudconfigs").stream().filter(c -> {
                    boolean matches = "/apps/acs-commons/templates/utilities/marketocloudconfig".equals(c.getValueMap().get("jcr:content/cq:template", (Object)""));
                    log.debug("Resource: {} matches: {}", c, (Object)matches);
                    return matches;
                }).findFirst().map(c -> c.getChild("jcr:content")).map(c -> (MarketoClientConfiguration)c.adaptTo(MarketoClientConfiguration.class)).orElse(null);
            } else {
                log.warn("Cannot get resource from path: {} for retrieving configuration", (Object)resourcePath);
                this.configuration = null;
            }
        }
    }

    @Override
    public MarketoClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

