/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl.composites.contexts;

import com.adobe.acs.commons.images.transformers.impl.composites.contexts.ColorMask;
import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class MultiplyCompositeContext
implements CompositeContext {
    private static final int ALPHA_MASK = 24;
    private static final int BLEND_SHIFT = 8;
    private final float alpha;

    public MultiplyCompositeContext(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void compose(Raster src, Raster destIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), destIn.getWidth());
        int height = Math.min(src.getHeight(), destIn.getHeight());
        int[] srcPixels = new int[width];
        int[] destPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            src.getDataElements(0, y, width, 1, srcPixels);
            destIn.getDataElements(0, y, width, 1, destPixels);
            for (int x = 0; x < width; ++x) {
                int srcPixel = srcPixels[x];
                int destPixel = destPixels[x];
                int result = 0;
                int tmp = 0;
                for (ColorMask mask : ColorMask.values()) {
                    int srcColor = srcPixel >> mask.getMask() & 0xFF;
                    int destColor = destPixel >> mask.getMask() & 0xFF;
                    tmp = this.blendColor(srcColor, destColor);
                    tmp = this.processColorOpacity(tmp, destColor);
                    result |= tmp << mask.getMask();
                }
                int srcAlpha = srcPixel >> 24 & 0xFF;
                int destAlpha = destPixel >> 24 & 0xFF;
                tmp = this.blendAlpha(srcAlpha, destAlpha);
                tmp = this.processAlphaOpacity(tmp, destAlpha);
                destPixels[x] = result |= tmp << 24;
            }
            dstOut.setDataElements(0, y, width, 1, destPixels);
        }
    }

    private int blendColor(int src, int dest) {
        return src * dest >> 8;
    }

    private int processColorOpacity(int blended, int dest) {
        int tmp = blended - dest;
        tmp = (int)((float)tmp * this.alpha);
        tmp = dest + tmp;
        return tmp &= 0xFF;
    }

    private int blendAlpha(int src, int dest) {
        int tmp = src * dest / 255;
        tmp = src + dest - tmp;
        return Math.min(255, tmp);
    }

    private int processAlphaOpacity(int blended, int dest) {
        int tmp = blended - dest;
        tmp = (int)((float)tmp * this.alpha);
        tmp = dest - tmp;
        return tmp &= 0xFF;
    }

    @Override
    public void dispose() {
    }

    public float getAlpha() {
        return this.alpha;
    }
}

