/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine;

import com.adobe.acs.commons.httpcache.engine.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.store.TempSink;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheContent {
    private int status;
    private String charEncoding;
    private String contentType;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream dataInputStream;
    private TempSink tempSink;
    private HttpCacheServletResponseWrapper.ResponseWriteMethod writeMethod;

    public CacheContent(String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) {
        this(200, charEncoding, contentType, headers, dataInputStream, HttpCacheServletResponseWrapper.ResponseWriteMethod.PRINTWRITER);
    }

    public CacheContent(String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream, HttpCacheServletResponseWrapper.ResponseWriteMethod writeMethod) {
        this(200, charEncoding, contentType, headers, dataInputStream, writeMethod);
    }

    public CacheContent(int status, String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) {
        this.writeMethod = HttpCacheServletResponseWrapper.ResponseWriteMethod.PRINTWRITER;
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers = headers;
        this.dataInputStream = dataInputStream;
    }

    public CacheContent(int status, String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream, HttpCacheServletResponseWrapper.ResponseWriteMethod writeMethod) {
        this.writeMethod = writeMethod;
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers = headers;
        this.dataInputStream = dataInputStream;
    }

    public CacheContent() {
    }

    public CacheContent build(HttpCacheServletResponseWrapper responseWrapper, int status, String charEncoding, String contentType, Map<String, List<String>> headers) throws HttpCacheDataStreamException {
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers.putAll(headers);
        this.tempSink = responseWrapper.getTempSink();
        this.dataInputStream = responseWrapper.getTempSink().createInputStream();
        this.writeMethod = responseWrapper.getWriteMethod();
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getInputDataStream() {
        return this.dataInputStream;
    }

    public TempSink getTempSink() {
        return this.tempSink;
    }

    public HttpCacheServletResponseWrapper.ResponseWriteMethod getWriteMethod() {
        return this.writeMethod;
    }
}

