/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.ResourceBasedDispatcherMaxAgeHeaderFilter;
import java.util.Arrays;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Dispacher Cache Control Header Resource Type Based - Max Age", description="Adds a Cache-Control max-age header to content based on resource type to enable Dispatcher TTL support.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Max Age: {max.age} for Resource Types: [{resource.types}]"}, propertyPrivate=true), @Property(name="dispatcher.filter.engine", value={"sling"}, propertyPrivate=true)})
public class ResourceTypeBasedDispatcherMaxAgeHeaderFilter
extends ResourceBasedDispatcherMaxAgeHeaderFilter {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeBasedDispatcherMaxAgeHeaderFilter.class);
    @Property(label="Resource types", description="Resource types the page should have to use this filter.", cardinality=0x7FFFFFFF)
    public static final String PROP_RESOURCE_TYPES = "resource.types";
    private String[] resourceTypes;

    @Override
    protected boolean accepts(HttpServletRequest request) {
        if (!super.accepts(request)) {
            log.debug("Not accepting request because it is not coming from the dispatcher.");
            return false;
        }
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            Resource resource = this.getResource(slingRequest);
            if (resource == null) {
                log.debug("Could not find resource for request, not accepting");
                return false;
            }
            return this.verifyResourceType(resource);
        }
        return false;
    }

    private boolean verifyResourceType(Resource resource) {
        for (String resourceType : this.resourceTypes) {
            if (!resource.isResourceType(resourceType)) continue;
            log.debug("Accepting request for resource: {} with resource type: {}.", (Object)resource.getPath(), (Object)resourceType);
            return true;
        }
        return false;
    }

    @Override
    protected final void doActivate(ComponentContext context) throws Exception {
        super.doActivate(context);
        Dictionary properties = context.getProperties();
        this.resourceTypes = PropertiesUtil.toStringArray(properties.get(PROP_RESOURCE_TYPES));
        if (this.resourceTypes == null || this.resourceTypes.length == 0) {
            throw new ConfigurationException(PROP_RESOURCE_TYPES, "At least one resource type must be specified.");
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[resource-types:" + Arrays.asList(this.resourceTypes) + ",fallback-max-age:" + super.getHeaderValue(null) + "]";
    }
}

