/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.exporters.impl.users;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class Parameters {
    private String[] customProperties;
    private String[] groups;
    private String groupFilter;

    public Parameters(Resource resource) {
        ValueMap properties = resource.getValueMap();
        this.customProperties = (String[])properties.get("customProperties", (Object)new String[0]);
        this.groups = (String[])properties.get("groups", (Object)new String[0]);
        this.groupFilter = (String)properties.get("groupFilter", (Object)"");
    }

    public Parameters(SlingHttpServletRequest request) throws IOException {
        this.groups = new String[0];
        if (request.getParameter("params") != null) {
            JsonObject json = new JsonParser().parse(request.getParameter("params")).getAsJsonObject();
            ArrayList<String> tmpCustomProperties = new ArrayList<String>();
            ArrayList<String> tmpGroups = new ArrayList<String>();
            this.groupFilter = JsonObjectUtil.getString(json, "groupFilter");
            JsonArray groupsJSON = json.getAsJsonArray("groups");
            for (int i = 0; i < groupsJSON.size(); ++i) {
                tmpGroups.add(groupsJSON.get(i).getAsString());
            }
            this.groups = tmpGroups.toArray(new String[tmpGroups.size()]);
            JsonArray customPropertiesJSON = json.getAsJsonArray("customProperties");
            for (int i = 0; i < customPropertiesJSON.size(); ++i) {
                JsonObject tmp = customPropertiesJSON.get(i).getAsJsonObject();
                if (!tmp.has("relPropertyPath")) continue;
                String relativePropertyPath = JsonObjectUtil.getString(tmp, "relPropertyPath");
                tmpCustomProperties.add(relativePropertyPath);
            }
            this.customProperties = tmpCustomProperties.toArray(new String[tmpCustomProperties.size()]);
        }
    }

    public String[] getCustomProperties() {
        if (this.customProperties != null) {
            return Arrays.copyOf(this.customProperties, this.customProperties.length);
        }
        return new String[0];
    }

    protected JsonArray getCustomPropertiesAsJSON() {
        JsonArray jsonArray = new JsonArray();
        for (String customProperty : this.customProperties) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("relPropertyPath", customProperty);
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public String[] getGroups() {
        return Arrays.copyOf(this.groups, this.groups.length);
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }
}

