/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.impl;

import com.adobe.acs.commons.ccvar.TransformAction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TransformAction.class})
public class UrlEncodeAction
implements TransformAction {
    private static final Logger LOG = LoggerFactory.getLogger(UrlEncodeAction.class);
    private static final String ACTION_NAME = "url";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String execute(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to URL encode value {}", (Object)value);
            return value;
        }
    }

    @Override
    public boolean disableEscaping() {
        return true;
    }
}

