/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushFilter;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusher;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@ServiceRanking(value=-5000)
@Designate(ocd=Config.class)
public class CloudDispatcherFlusher
implements DispatcherFlusher {
    private static final Logger log = LoggerFactory.getLogger(CloudDispatcherFlusher.class);
    @Reference
    private Distributor distributor;
    @Reference
    private AgentManager agentManager;
    private String[] agentNames;

    @Activate
    protected void activate(Config config) {
        this.agentNames = config.agent_names();
    }

    public Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, String ... paths) {
        HashMap<Agent, ReplicationResult> result = new HashMap<Agent, ReplicationResult>();
        SimpleDistributionRequest distributionRequest = new SimpleDistributionRequest(DistributionRequestType.INVALIDATE, false, paths);
        for (String agentName : this.agentNames) {
            DistributionResponse distributionResponse = this.distributor.distribute(agentName, resourceResolver, (DistributionRequest)distributionRequest);
            Agent agent = (Agent)this.agentManager.getAgents().get(agentName);
            if (agent == null) continue;
            result.put(agent, this.toReplicationResult(distributionResponse));
        }
        log.debug("Executed dispatcher flush for paths {}", Arrays.asList(paths));
        return result;
    }

    public Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, ReplicationActionType actionType, boolean synchronous, String ... paths) throws ReplicationException {
        log.warn("Dispatcher flusher in cloud should use INVALIDATE distribution types from author, no custom action type and synchronous should be set, refactor your code to use the DispatcherFlushRules.flush(resourceResolver, paths) method");
        return this.flush(resourceResolver, paths);
    }

    public Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, ReplicationActionType actionType, boolean synchronous, AgentFilter agentFilter, String ... paths) throws ReplicationException {
        log.warn("Dispatcher flusher in cloud should use INVALIDATE distribution types from author, no custom action type and synchronous should be set, refactor your code to use the DispatcherFlushRules.flush(resourceResolver, paths) method");
        return this.flush(resourceResolver, paths);
    }

    public final Agent[] getFlushAgents() {
        return this.getAgents((AgentFilter)new DispatcherFlushFilter());
    }

    public final Agent[] getAgents(AgentFilter agentFilter) {
        ArrayList<Agent> flushAgents = new ArrayList<Agent>();
        for (Agent agent : this.agentManager.getAgents().values()) {
            if (!agentFilter.isIncluded(agent)) continue;
            flushAgents.add(agent);
        }
        return flushAgents.toArray(new Agent[flushAgents.size()]);
    }

    private ReplicationResult toReplicationResult(DistributionResponse distributionResponse) {
        if (distributionResponse.isSuccessful()) {
            return ReplicationResult.OK;
        }
        return new ReplicationResult(false, 500, distributionResponse.getMessage());
    }

    @ObjectClassDefinition
    static @interface Config {
        @AttributeDefinition(description="Agent names to trigger when executing a distribute invalidate (ex. publish, preview)")
        public String[] agent_names() default {"publish"};
    }
}

