/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdjustEvent {
    private static ILogger logger = AdjustFactory.getLogger();
    String eventToken;
    Double revenue;
    String currency;
    Map<String, String> callbackParameters;
    Map<String, String> partnerParameters;
    String orderId;
    String deduplicationId;
    String callbackId;
    String productId;
    String purchaseToken;

    public AdjustEvent(String string) {
        if (!AdjustEvent.checkEventToken(string, logger)) {
            return;
        }
        this.eventToken = string;
    }

    private static boolean checkEventToken(String string, ILogger iLogger) {
        if (string == null) {
            iLogger.error("Missing Event Token", new Object[0]);
            return false;
        }
        if (string.length() <= 0) {
            iLogger.error("Event Token can't be empty", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkRevenue(Double d, String string) {
        if (d != null) {
            if (d < 0.0) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = d;
                logger.error("Invalid amount %.5f", objectArray2);
                return false;
            }
            if (string == null) {
                logger.error("Currency must be set with revenue", new Object[0]);
                return false;
            }
            if (string.equals("")) {
                logger.error("Currency is empty", new Object[0]);
                return false;
            }
        } else if (string != null) {
            logger.error("Revenue must be set with currency", new Object[0]);
            return false;
        }
        return true;
    }

    public void setRevenue(double d, String string) {
        if (!this.checkRevenue(d, string)) {
            return;
        }
        this.revenue = d;
        this.currency = string;
    }

    public void addCallbackParameter(String string, String string2) {
        if (Util.isValidParameter(string, "key", "Callback") && Util.isValidParameter(string2, "value", "Callback")) {
            if (objectArray2.callbackParameters == null) {
                LinkedHashMap<String, String> linkedHashMap;
                LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
                linkedHashMap = new LinkedHashMap<String, String>();
                objectArray2.callbackParameters = linkedHashMap2;
            }
            if (objectArray2.callbackParameters.put(string, string2) != null) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                logger.warn("Key %s was overwritten", objectArray2);
                return;
            }
        }
    }

    public void addPartnerParameter(String string, String string2) {
        if (Util.isValidParameter(string, "key", "Partner") && Util.isValidParameter(string2, "value", "Partner")) {
            if (objectArray2.partnerParameters == null) {
                LinkedHashMap<String, String> linkedHashMap;
                LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
                linkedHashMap = new LinkedHashMap<String, String>();
                objectArray2.partnerParameters = linkedHashMap2;
            }
            if (objectArray2.partnerParameters.put(string, string2) != null) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                logger.warn("Key %s was overwritten", objectArray2);
                return;
            }
        }
    }

    public void setOrderId(String string) {
        this.orderId = string;
    }

    public void setDeduplicationId(String string) {
        this.deduplicationId = string;
    }

    public void setCallbackId(String string) {
        this.callbackId = string;
    }

    public void setProductId(String string) {
        this.productId = string;
    }

    public void setPurchaseToken(String string) {
        this.purchaseToken = string;
    }

    public boolean isValid() {
        return this.eventToken != null;
    }

    public String getEventToken() {
        return this.eventToken;
    }

    public Double getRevenue() {
        return this.revenue;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Map<String, String> getCallbackParameters() {
        return this.callbackParameters;
    }

    public Map<String, String> getPartnerParameters() {
        return this.partnerParameters;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getDeduplicationId() {
        return this.deduplicationId;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getPurchaseToken() {
        return this.purchaseToken;
    }
}

