/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.OnAmazonAdIdReadListener;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

class DeviceInfo {
    private static final String OFFICIAL_FACEBOOK_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";
    String playAdId;
    String playAdIdSource;
    int playAdIdAttempt;
    Boolean isTrackingEnabled;
    private boolean nonGoogleIdsReadOnce;
    private boolean playIdsReadOnce;
    private boolean otherDeviceIdsParamsReadOnce;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String apiLevel;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    String hardwareName;
    String abi;
    String buildName;
    String appInstallTime;
    String appUpdateTime;
    int uiMode;
    String appSetId;
    boolean isGooglePlayGamesForPC;
    Map<String, String> imeiParameters;
    Map<String, String> oaidParameters;
    String fireAdId;
    Boolean fireTrackingEnabled;
    int connectivityType;
    String mcc;
    String mnc;

    public DeviceInfo(AdjustConfig adjustConfig) {
        AdjustConfig adjustConfig2 = adjustConfig;
        this.playAdIdAttempt = -1;
        this.nonGoogleIdsReadOnce = false;
        this.playIdsReadOnce = false;
        this.otherDeviceIdsParamsReadOnce = false;
        adjustConfig = adjustConfig2.context;
        Resources resources = adjustConfig.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = Util.getLocale(configuration);
        PackageInfo packageInfo = this.getPackageInfo((Context)adjustConfig);
        int n = configuration.screenLayout;
        this.isGooglePlayGamesForPC = Util.isGooglePlayGamesForPC((Context)adjustConfig);
        this.packageName = this.getPackageName((Context)adjustConfig);
        this.appVersion = this.getAppVersion(packageInfo);
        this.deviceType = this.getDeviceType(configuration);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.apiLevel = this.getApiLevel();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(n);
        this.screenFormat = this.getScreenFormat(n);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(adjustConfig2.sdkPrefix);
        this.fbAttributionId = this.getFacebookAttributionId((Context)adjustConfig);
        this.hardwareName = this.getHardwareName();
        this.abi = this.getABI();
        this.buildName = this.getBuildName();
        this.appInstallTime = this.getAppInstallTime(packageInfo);
        this.appUpdateTime = this.getAppUpdateTime(packageInfo);
        this.uiMode = this.getDeviceUiMode(configuration);
        if (Util.canReadPlayIds(adjustConfig2)) {
            this.appSetId = Reflection.getAppSetId((Context)adjustConfig);
        }
    }

    public static void getFireAdvertisingIdBypassConditions(ContentResolver contentResolver, OnAmazonAdIdReadListener onAmazonAdIdReadListener) {
        UtilDeviceIds.getFireAdvertisingIdAsync(contentResolver, onAmazonAdIdReadListener);
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private PackageInfo getPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getAppVersion(PackageInfo packageInfo) {
        try {
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getDeviceType(Configuration configuration) {
        if (this.isGooglePlayGamesForPC) {
            return "pc";
        }
        if ((configuration.uiMode & 0xF) == 4) {
            return "tv";
        }
        switch (configuration.screenLayout & 0xF) {
            default: {
                return null;
            }
            case 3: 
            case 4: {
                return "tablet";
            }
            case 1: 
            case 2: 
        }
        return "phone";
    }

    private int getDeviceUiMode(Configuration configuration) {
        return configuration.uiMode & 0xF;
    }

    private String getDeviceName() {
        if (this.isGooglePlayGamesForPC) {
            return null;
        }
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        if (this.isGooglePlayGamesForPC) {
            return "windows";
        }
        return "android";
    }

    private String getOsVersion() {
        if (this.isGooglePlayGamesForPC) {
            return null;
        }
        return Build.VERSION.RELEASE;
    }

    private String getApiLevel() {
        return "" + Build.VERSION.SDK_INT;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getBuildName() {
        return Build.ID;
    }

    private String getHardwareName() {
        return Build.DISPLAY;
    }

    private String getScreenSize(int n) {
        switch (n & 0xF) {
            default: {
                return null;
            }
            case 4: {
                return "xlarge";
            }
            case 3: {
                return "large";
            }
            case 2: {
                return "normal";
            }
            case 1: 
        }
        return "small";
    }

    private String getScreenFormat(int n) {
        int n2 = n & 0x30;
        if (n2 != 16) {
            if (n2 != 32) {
                return null;
            }
            return "long";
        }
        return "normal";
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int n = displayMetrics.densityDpi;
        int n2 = 140;
        int n3 = 200;
        if (n == 0) {
            return null;
        }
        if (n < n2) {
            return "low";
        }
        if (n > n3) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String string) {
        if (string == null) {
            return "android5.3.0";
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = "android5.3.0";
        return Util.formatString("%s@%s", objectArray2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFacebookAttributionId(Context context) {
        block8: {
            Cursor cursor = null;
            try {
                block10: {
                    Cursor cursor2;
                    block11: {
                        block9: {
                            if (Build.VERSION.SDK_INT < 28) break block9;
                            SigningInfo signingInfo = context.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)0x8000000).signingInfo;
                            if (signingInfo == null) break block10;
                            cursor2 = signingInfo.getApkContentsSigners();
                            break block11;
                        }
                        cursor2 = context.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)64).signatures;
                    }
                    cursor = cursor2;
                }
                if (cursor == null) return null;
                if (((Signature[])cursor).length != 1) {
                    return null;
                }
                if (!OFFICIAL_FACEBOOK_SIGNATURE.equals(cursor[0].toCharsString())) {
                    return null;
                }
                cursor = context.getContentResolver().query(Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider"), new String[]{"aid"}, null, null, null);
                if (cursor != null) break block8;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (!cursor.moveToFirst()) {
            cursor.close();
            return null;
        }
        Cursor cursor = cursor;
        String string = cursor.getString(cursor.getColumnIndex("aid"));
        cursor.close();
        return string;
    }

    private String getABI() {
        String[] stringArray = Util.getSupportedAbis();
        if (stringArray != null && stringArray.length != 0) {
            return stringArray[0];
        }
        return Util.getCpuAbi();
    }

    private String getAppInstallTime(PackageInfo packageInfo) {
        try {
            return Util.dateFormatter.format(new Date(packageInfo.firstInstallTime));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getAppUpdateTime(PackageInfo packageInfo) {
        try {
            return Util.dateFormatter.format(new Date(packageInfo.lastUpdateTime));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reloadPlayIds(AdjustConfig object) {
        Object object2;
        int n;
        if (this.playIdsReadOnce && ((AdjustConfig)object).isDeviceIdsReadingOnceEnabled) {
            if (!Util.canReadPlayIds((AdjustConfig)object)) {
                this.playAdId = null;
                this.isTrackingEnabled = null;
                this.playAdIdSource = null;
                this.playAdIdAttempt = -1;
            }
            return;
        }
        this.playAdId = null;
        this.isTrackingEnabled = null;
        this.playAdIdSource = null;
        this.playAdIdAttempt = -1;
        if (!Util.canReadPlayIds((AdjustConfig)object)) {
            return;
        }
        Context context = ((AdjustConfig)object).context;
        if (Reflection.isAppRunningInSamsungCloudEnvironment(context, ((AdjustConfig)object).logger)) {
            this.playAdId = Reflection.getSamsungCloudDevGoogleAdId(context, ((AdjustConfig)object).logger);
            this.playAdIdSource = "samsung_cloud_sdk";
            this.playIdsReadOnce = true;
        }
        object = this.playAdId;
        Boolean bl = this.isTrackingEnabled;
        for (n = 1; n <= 3; ++n) {
            try {
                object2 = GooglePlayServicesClient.getGooglePlayServicesInfo(context, n * 3000);
                if (this.playAdId == null) {
                    this.playAdId = ((GooglePlayServicesClient.GooglePlayServicesInfo)object2).getGpsAdid();
                    this.playIdsReadOnce = true;
                }
            }
            catch (Exception exception) {
                continue;
            }
            {
                if (this.isTrackingEnabled == null) {
                    this.isTrackingEnabled = ((GooglePlayServicesClient.GooglePlayServicesInfo)object2).isTrackingEnabled();
                }
                if (this.playAdId == null || this.isTrackingEnabled == null) continue;
                this.playAdIdSource = "service";
                this.playAdIdAttempt = n;
                return;
            }
        }
        for (n = 1; n <= 3; ++n) {
            object2 = Util.getAdvertisingInfoObject(context, 11000L);
            if (object2 == null) continue;
            if (this.playAdId == null) {
                this.playAdId = Util.getPlayAdId(context, object2, 1000L);
                this.playIdsReadOnce = true;
            }
            if (this.isTrackingEnabled == null) {
                this.isTrackingEnabled = Util.isPlayTrackingEnabled(context, object2, 1000L);
            }
            if (this.playAdId == null || this.isTrackingEnabled == null) continue;
            this.playAdIdSource = "library";
            this.playAdIdAttempt = n;
            return;
        }
        if (this.playAdId == null) {
            this.playAdId = object;
            this.playIdsReadOnce = true;
        }
        if (this.isTrackingEnabled == null) {
            this.isTrackingEnabled = bl;
        }
    }

    public void reloadNonPlayIds(AdjustConfig adjustConfig) {
        if (!Util.canReadNonPlayIds(adjustConfig)) {
            return;
        }
        if (this.nonGoogleIdsReadOnce) {
            return;
        }
        DeviceInfo deviceInfo = this;
        deviceInfo.androidId = Util.getAndroidId(adjustConfig.context);
        deviceInfo.nonGoogleIdsReadOnce = true;
    }

    public void reloadOtherDeviceInfoParams(AdjustConfig adjustConfig, ILogger iLogger) {
        if (adjustConfig.isDeviceIdsReadingOnceEnabled && this.otherDeviceIdsParamsReadOnce) {
            return;
        }
        DeviceInfo deviceInfo = this;
        this.imeiParameters = UtilDeviceIds.getImeiParameters(adjustConfig, iLogger);
        this.oaidParameters = UtilDeviceIds.getOaidParameters(adjustConfig, iLogger);
        this.fireAdId = UtilDeviceIds.getFireAdvertisingId(adjustConfig);
        this.fireTrackingEnabled = UtilDeviceIds.getFireTrackingEnabled(adjustConfig);
        this.connectivityType = UtilDeviceIds.getConnectivityType(adjustConfig.context, iLogger);
        this.mcc = UtilDeviceIds.getMcc(adjustConfig.context, iLogger);
        deviceInfo.mnc = UtilDeviceIds.getMnc(adjustConfig.context, iLogger);
        deviceInfo.otherDeviceIdsParamsReadOnce = true;
    }

    public static class UtilDeviceIds {
        private UtilDeviceIds() {
        }

        private static Map<String, String> getImeiParameters(AdjustConfig adjustConfig, ILogger iLogger) {
            if (!adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled) {
                return Reflection.getImeiParameters(adjustConfig.context, iLogger);
            }
            return null;
        }

        private static Map<String, String> getOaidParameters(AdjustConfig adjustConfig, ILogger iLogger) {
            if (!adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled) {
                return Reflection.getOaidParameters(adjustConfig.context, iLogger);
            }
            return null;
        }

        private static String getFireAdvertisingId(AdjustConfig adjustConfig) {
            if (!adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled) {
                return UtilDeviceIds.getFireAdvertisingId(adjustConfig.context.getContentResolver());
            }
            return null;
        }

        private static String getFireAdvertisingId(ContentResolver contentResolver) {
            if (contentResolver == null) {
                return null;
            }
            try {
                return Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static void getFireAdvertisingIdAsync(ContentResolver contentResolver, OnAmazonAdIdReadListener onAmazonAdIdReadListener) {
            if (contentResolver == null) {
                AdjustFactory.getLogger().error("contentResolver could not be retrieved", new Object[0]);
                return;
            }
            try {
                onAmazonAdIdReadListener.onAmazonAdIdRead(Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id"));
            }
            catch (Exception exception) {
                AdjustFactory.getLogger().error(exception.getMessage(), new Object[0]);
            }
        }

        private static Boolean getFireTrackingEnabled(AdjustConfig adjustConfig) {
            if (!adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled) {
                return UtilDeviceIds.getFireTrackingEnabled(adjustConfig.context.getContentResolver());
            }
            return null;
        }

        private static Boolean getFireTrackingEnabled(ContentResolver contentResolver) {
            boolean bl;
            try {
                bl = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking") == 0;
            }
            catch (Exception exception) {
                return null;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static int getConnectivityType(Context object, ILogger objectArray) {
            Exception exception2;
            block19: {
                int n;
                block18: {
                    Network network;
                    block17: {
                        try {
                            object = (ConnectivityManager)object.getSystemService("connectivity");
                            if (object == null) {
                                return -1;
                            }
                            n = Build.VERSION.SDK_INT;
                            if (n < 23) {
                                return object.getActiveNetworkInfo().getType();
                            }
                            network = object.getActiveNetwork();
                            if (network != null) break block17;
                            return -1;
                        }
                        catch (Exception exception2) {}
                    }
                    object = object.getNetworkCapabilities(network);
                    if (object != null) break block18;
                    return -1;
                }
                if (object.hasTransport(1)) {
                    return 1;
                }
                break block19;
                if (object.hasTransport(0)) {
                    return 0;
                }
                if (object.hasTransport(3)) {
                    return 3;
                }
                if (object.hasTransport(4)) {
                    return 4;
                }
                if (object.hasTransport(2)) {
                    return 2;
                }
                if (n < 26) {
                    return -1;
                }
                if (object.hasTransport(5)) {
                    return 5;
                }
                if (n < 27) {
                    return -1;
                }
                if (!object.hasTransport(6)) return -1;
                return 6;
            }
            object = exception2.getMessage();
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object;
            objectArray2.warn("Couldn't read connectivity type (%s)", objectArray);
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String getMcc(Context object, ILogger iLogger) {
            try {
                object = ((TelephonyManager)object.getSystemService("phone")).getNetworkOperator();
                if (TextUtils.isEmpty((CharSequence)object)) {
                    AdjustFactory.getLogger().warn("Couldn't receive networkOperator string to read MCC", new Object[0]);
                    return null;
                }
                return ((String)object).substring(0, 3);
            }
            catch (Exception exception) {}
            AdjustFactory.getLogger().warn("Couldn't return mcc", new Object[0]);
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String getMnc(Context object, ILogger iLogger) {
            try {
                object = ((TelephonyManager)object.getSystemService("phone")).getNetworkOperator();
                if (TextUtils.isEmpty((CharSequence)object)) {
                    AdjustFactory.getLogger().warn("Couldn't receive networkOperator string to read MNC", new Object[0]);
                    return null;
                }
                return ((String)object).substring(3);
            }
            catch (Exception exception) {}
            iLogger.warn("Couldn't return mnc", new Object[0]);
            return null;
        }
    }
}

