/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrer
implements InvocationHandler {
    private static final String PACKAGE_BASE_NAME = "com.android.installreferrer.";
    private static final int STATUS_SERVICE_DISCONNECTED = -1;
    private static final int STATUS_OK = 0;
    private static final int STATUS_SERVICE_UNAVAILABLE = 1;
    private static final int STATUS_FEATURE_NOT_SUPPORTED = 2;
    private static final int STATUS_DEVELOPER_ERROR = 3;
    private int retryWaitTime;
    private int retries;
    private final AtomicBoolean shouldTryToRead;
    private ILogger logger;
    private Object referrerClient;
    private Context context;
    private TimerOnce retryTimer;
    private final InstallReferrerReadListener referrerCallback;
    private ThreadExecutor executor;

    public InstallReferrer(Context context, InstallReferrerReadListener installReferrerReadListener) {
        InstallReferrer installReferrer = this;
        InstallReferrer installReferrer2 = this;
        this.retryWaitTime = 3000;
        this.logger = AdjustFactory.getLogger();
        installReferrer2.context = context;
        installReferrer2.shouldTryToRead = new AtomicBoolean(true);
        installReferrer2.retries = 0;
        installReferrer2.retryTimer = new TimerOnce(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer.this.startConnection();
            }
        }, "InstallReferrer");
        installReferrer.referrerCallback = installReferrerReadListener;
        installReferrer.executor = new SingleThreadCachedScheduler("InstallReferrer");
    }

    private Object createInstallReferrerClient(Context context) {
        Object[] objectArray;
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        String string2 = "newBuilder";
        Class[] classArray = new Class[1];
        classArray[0] = Context.class;
        Object object = Reflection.invokeStaticMethod(string, string2, classArray, context);
        String string3 = "build";
        try {
            return Reflection.invokeInstanceMethod(object, string3, null, new Object[0]);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = exception.getMessage();
            objectArray2[1] = exception.getClass().getCanonicalName();
            objectArray.referrerCallback.onFail(Util.formatString("createInstallReferrerClient error (%s) from (%s)", objectArray));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = classNotFoundException.getMessage();
            objectArray3[1] = classNotFoundException.getClass().getCanonicalName();
            objectArray.referrerCallback.onFail(Util.formatString("InstallReferrer not integrated in project (%s) thrown by (%s)", objectArray));
        }
        return null;
    }

    private Class getInstallReferrerStateListenerClass() {
        try {
            return Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.referrerCallback.onFail(Util.formatString("getInstallReferrerStateListenerClass error (%s) from (%s)", objectArray2));
            return null;
        }
    }

    private Object createProxyInstallReferrerStateListener(Class clazz) {
        Object object = null;
        try {
            object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        }
        catch (NullPointerException nullPointerException) {
            this.referrerCallback.onFail("Null argument passed to InstallReferrer proxy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.referrerCallback.onFail("InstallReferrer proxy violating parameter restrictions");
        }
        return object;
    }

    private void startConnection(Class objectArray, Object object) {
        block5: {
            Object[] objectArray2;
            Object object2 = objectArray2.referrerClient;
            String string = "startConnection";
            Class[] classArray = new Class[1];
            Class[] classArray2 = classArray;
            classArray[0] = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            try {
                objectArray3[0] = object;
                Reflection.invokeInstanceMethod(object2, string, classArray2, objectArray);
            }
            catch (Exception exception) {
                Object[] objectArray4 = new Object[2];
                objectArray2 = objectArray4;
                objectArray2[0] = exception.getMessage();
                objectArray4[1] = exception.getClass().getCanonicalName();
                objectArray2.referrerCallback.onFail(Util.formatString("startConnection error (%s) thrown by (%s)", objectArray2));
            }
            catch (InvocationTargetException invocationTargetException) {
                if (Util.hasRootCause(invocationTargetException)) {
                    Object[] objectArray5 = new Object[1];
                    objectArray2 = objectArray5;
                    objectArray5[0] = Util.getRootCause(invocationTargetException);
                    objectArray2.referrerCallback.onFail(Util.formatString("InstallReferrer encountered an InvocationTargetException %s", objectArray2));
                    break block5;
                }
                objectArray2.referrerCallback.onFail("InstallReferrer encountered an InvocationTargetException");
            }
        }
    }

    private Object invokeI(Object object, Method objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray == null) {
            objectArray3.referrerCallback.onFail("InstallReferrer invoke method null");
            return null;
        }
        object = objectArray.getName();
        if (object == null) {
            objectArray3.referrerCallback.onFail("InstallReferrer invoke method name null");
            return null;
        }
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        objectArray3.logger.debug("InstallReferrer invoke method name: %s", objectArray);
        if (objectArray2 == null) {
            objectArray3.logger.warn("InstallReferrer invoke args null", new Object[0]);
            objectArray2 = new Object[]{};
        }
        int n2 = objectArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray2[i2];
            Object[] objectArray5 = new Object[1];
            Object[] objectArray6 = objectArray5;
            objectArray5[0] = object2;
            objectArray3.logger.debug("InstallReferrer invoke arg: %s", objectArray6);
        }
        if (((String)object).equals("onInstallReferrerSetupFinished")) {
            if (objectArray2.length != 1) {
                Object[] objectArray7 = new Object[1];
                objectArray3 = objectArray7;
                objectArray7[0] = objectArray2.length;
                objectArray3.referrerCallback.onFail(Util.formatString("InstallReferrer invoke onInstallReferrerSetupFinished args lenght not 1: %d", objectArray3));
                return null;
            }
            object = objectArray2[0];
            if (!(object instanceof Integer)) {
                objectArray3.referrerCallback.onFail("InstallReferrer invoke onInstallReferrerSetupFinished arg not int");
                return null;
            }
            if ((object = (Integer)object) == null) {
                objectArray3.referrerCallback.onFail("InstallReferrer invoke onInstallReferrerSetupFinished responseCode arg is null");
                return null;
            }
            super.onInstallReferrerSetupFinishedIntI((Integer)object);
        } else if (((String)object).equals("onInstallReferrerServiceDisconnected")) {
            objectArray3.logger.debug("Connection to install referrer service was lost. Retrying ...", new Object[0]);
            super.retryI("onInstallReferrerServiceDisconnected");
        } else {
            Object[] objectArray8 = new Object[1];
            objectArray3 = objectArray8;
            objectArray8[0] = object;
            objectArray3.referrerCallback.onFail(Util.formatString("Reflection call method name not expected: %s", objectArray3));
        }
        return null;
    }

    private void onInstallReferrerSetupFinishedIntI(int n2) {
        boolean bl = false;
        switch (n2) {
            default: {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                this.referrerCallback.onFail(Util.formatString("Unexpected response code of install referrer response: %d. Closing connection", objectArray2));
                break;
            }
            case 3: {
                this.logger.debug("Install Referrer API general errors caused by incorrect usage. Retrying...", new Object[0]);
                bl = true;
                break;
            }
            case 2: {
                this.referrerCallback.onFail("Install Referrer API not supported by the installed Play Store app. Closing connection");
                break;
            }
            case 1: {
                this.logger.debug("Could not initiate connection to the Install Referrer service. Retrying...", new Object[0]);
                bl = true;
                break;
            }
            case 0: {
                ReferrerDetails referrerDetails;
                Object object = this.getInstallReferrer();
                String string = this.getStringInstallReferrer(object);
                long l2 = this.getReferrerClickTimestampSeconds(object);
                long l3 = this.getInstallBeginTimestampSeconds(object);
                ILogger iLogger = this.logger;
                String string2 = "installReferrer: %s, clickTime: %d, installBeginTime: %d";
                Object[] objectArray = new Object[3];
                Object[] objectArray3 = objectArray;
                long l4 = l3;
                Object[] objectArray4 = objectArray3;
                long l5 = l2;
                objectArray3[0] = string;
                int n3 = 1;
                objectArray4[n3] = l5;
                n3 = 2;
                objectArray[n3] = l4;
                iLogger.debug(string2, objectArray);
                String string3 = this.getStringInstallVersion(object);
                long l6 = this.getReferrerClickTimestampServerSeconds(object);
                long l7 = this.getInstallBeginTimestampServerSeconds(object);
                object = this.getBooleanGooglePlayInstantParam(object);
                ILogger iLogger2 = this.logger;
                String string4 = "installVersion: %s, clickTimeServer: %d, installBeginServer: %d, googlePlayInstant: %b";
                Object[] objectArray5 = new Object[4];
                Object[] objectArray6 = objectArray5;
                long l8 = l7;
                Object[] objectArray7 = objectArray6;
                long l9 = l6;
                objectArray6[0] = string3;
                int n4 = 1;
                objectArray7[n4] = l9;
                n4 = 2;
                objectArray5[n4] = l8;
                objectArray5[3] = object;
                iLogger2.debug(string4, objectArray5);
                this.logger.debug("Install Referrer read successfully. Closing connection", new Object[0]);
                ReferrerDetails referrerDetails2 = referrerDetails;
                try {
                    referrerDetails = new ReferrerDetails(string, l2, l3, l6, l7, string3, (Boolean)object, null);
                    this.referrerCallback.onInstallReferrerRead(referrerDetails2, "google");
                }
                catch (Exception exception) {
                    Object[] objectArray8 = new Object[1];
                    Object[] objectArray9 = objectArray8;
                    objectArray8[0] = exception.getMessage();
                    this.logger.warn("Couldn't get install referrer from client (%s). Retrying...", objectArray9);
                    bl = true;
                }
                break;
            }
            case -1: {
                this.logger.debug("Play Store service is not connected now. Retrying...", new Object[0]);
                bl = true;
            }
        }
        if (bl) {
            this.retryI("end of onInstallReferrerSetupFinishedIntI");
        } else {
            this.shouldTryToRead.set(false);
            this.closeReferrerClient();
        }
    }

    private Object getInstallReferrer() {
        String string;
        Object object;
        Object object2 = objectArray2.referrerClient;
        if (object2 == null) {
            return null;
        }
        try {
            object = object2;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return Reflection.invokeInstanceMethod(object, string, null, new Object[0]);
    }

    private String getStringInstallReferrer(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getStringInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampSeconds";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getReferrerClickTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampSeconds";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getInstallBeginTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private String getStringInstallVersion(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallVersion";
        }
        catch (Exception exception) {
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private Boolean getBooleanGooglePlayInstantParam(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getGooglePlayInstantParam";
        }
        catch (Exception exception) {
            return null;
        }
        return (boolean)((Boolean)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]));
    }

    private void retryI(String string) {
        int n2;
        Object[] objectArray;
        if (!objectArray.shouldTryToRead.get()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray.referrerCallback.onFail(Util.formatString("Should not try to read Install referrer from %s", objectArray));
            super.closeReferrerClient();
            return;
        }
        if (objectArray.retries + 1 > 2) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = 2;
            objectArray3[1] = string;
            objectArray.referrerCallback.onFail(Util.formatString("Limit number of retry of %d for install referrer surpassed from %s", objectArray));
            return;
        }
        long l2 = objectArray.retryTimer.getFireIn();
        if (l2 > 0L) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = l2;
            objectArray.logger.debug("Already waiting to retry to read install referrer in %d milliseconds", objectArray);
            return;
        }
        objectArray.retries = n2 = objectArray.retries + 1;
        Object[] objectArray5 = new Object[1];
        Object[] objectArray6 = objectArray5;
        objectArray5[0] = n2;
        objectArray.logger.debug("Retry number %d to connect to install referrer API", objectArray6);
        objectArray.retryTimer.startIn(objectArray.retryWaitTime);
    }

    private void closeReferrerClient() {
        Object object = this.referrerClient;
        if (object == null) {
            return;
        }
        InstallReferrer installReferrer = this;
        Object object2 = object;
        String string = "endConnection";
        Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
        try {
            installReferrer.logger.debug("Install Referrer API connection closed", new Object[0]);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            this.logger.error("closeReferrerClient error (%s) thrown by (%s)", objectArray2);
        }
        this.referrerClient = null;
    }

    public void startConnection() {
        if (!AdjustFactory.getTryInstallReferrer()) {
            this.referrerCallback.onFail("Sdk has been configured to not try install referrer");
            return;
        }
        InstallReferrer installReferrer = this;
        installReferrer.closeReferrerClient();
        if (!installReferrer.shouldTryToRead.get()) {
            this.referrerCallback.onFail("Should not try to read the install referrer any longer");
            return;
        }
        Object object = this.context;
        if (object == null) {
            this.referrerCallback.onFail("Requires context to read the install referrer");
            return;
        }
        this.referrerClient = this.createInstallReferrerClient((Context)object);
        if (this.referrerClient == null) {
            return;
        }
        object = this.getInstallReferrerStateListenerClass();
        if (object == null) {
            return;
        }
        Object object2 = this.createProxyInstallReferrerStateListener((Class)object);
        if (object2 == null) {
            return;
        }
        this.startConnection((Class)object, object2);
    }

    @Override
    public Object invoke(final Object object, final Method method, final Object[] objectArray) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer installReferrer = objectArray5.InstallReferrer.this;
                Object[] objectArray6 = objectArray5;
                Object[] objectArray2 = objectArray5;
                Object object2 = objectArray5.object;
                Method method2 = objectArray2.method;
                Object[] objectArray3 = objectArray6.objectArray;
                try {
                    installReferrer.invokeI(object2, method2, objectArray3);
                }
                catch (Throwable throwable) {
                    Object[] objectArray4 = new Object[2];
                    Object[] objectArray5 = objectArray4;
                    objectArray5[0] = throwable.getMessage();
                    objectArray4[1] = throwable.getClass().getCanonicalName();
                    objectArray5.InstallReferrer.this.referrerCallback.onFail(Util.formatString("invoke error (%s) thrown by (%s)", objectArray5));
                }
            }
        });
        return null;
    }
}

