/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UrlStrategy;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPackageSender
implements IActivityPackageSender {
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String purchaseVerificationPath;
    private String clientSdk;
    private ILogger logger;
    private ThreadExecutor executor;
    private UrlStrategy urlStrategy;
    private UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider;
    private UtilNetworking.IConnectionOptions connectionOptions;
    private Context context;

    public ActivityPackageSender(List<String> list, boolean bl, String string, String string2, String string3, String string4, String string5, Context context) {
        ActivityPackageSender activityPackageSender = this;
        this.basePath = string;
        this.gdprPath = string2;
        this.subscriptionPath = string3;
        this.purchaseVerificationPath = string4;
        this.clientSdk = string5;
        activityPackageSender.context = context;
        activityPackageSender.logger = AdjustFactory.getLogger();
        activityPackageSender.executor = new SingleThreadCachedScheduler("ActivityPackageSender");
        activityPackageSender.urlStrategy = new UrlStrategy(AdjustFactory.getBaseUrl(), AdjustFactory.getGdprUrl(), AdjustFactory.getSubscriptionUrl(), AdjustFactory.getPurchaseVerificationUrl(), list, bl);
        activityPackageSender.httpsURLConnectionProvider = AdjustFactory.getHttpsURLConnectionProvider();
        activityPackageSender.connectionOptions = AdjustFactory.getConnectionOptions();
    }

    private Map<String, String> signParameters(ActivityPackage activityPackage, Map<String, String> hashMap) {
        HashMap<String, String> hashMap2;
        HashMap<String, String> hashMap3;
        HashMap<String, String> hashMap4 = hashMap3;
        hashMap4(activityPackage.getParameters());
        hashMap3.putAll(hashMap);
        hashMap = hashMap2;
        hashMap();
        hashMap.put("client_sdk", activityPackage.getClientSdk());
        hashMap.put("activity_kind", activityPackage.getActivityKind().toString());
        hashMap2.put("endpoint", activityPackageSender2.urlStrategy.targetUrlByActivityKind(activityPackage.getActivityKind()));
        activityPackage = SharedPreferencesManager.getDefaultInstance(activityPackageSender2.context).getControlParamsJson();
        if (activityPackage != null) {
            Iterator iterator = activityPackage.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    if (!(activityPackage.get(string) instanceof String)) continue;
                }
                catch (JSONException jSONException) {
                    activityPackageSender2.logger.error("JSONException while iterating control params", new Object[0]);
                    continue;
                }
                hashMap.put(string, (String)activityPackage.get(string));
            }
        }
        ActivityPackageSender activityPackageSender = activityPackageSender2;
        ActivityPackageSender activityPackageSender2 = activityPackageSender.context;
        return AdjustSigner.sign(hashMap4, hashMap, (Context)activityPackageSender2, activityPackageSender.logger);
    }

    private boolean shouldRetryToSend(ResponseData responseData) {
        if (!responseData.willRetry) {
            ActivityPackageSender activityPackageSender = this;
            activityPackageSender.logger.debug("Will not retry with current url strategy", new Object[0]);
            activityPackageSender.urlStrategy.resetAfterSuccess();
            return false;
        }
        if (this.urlStrategy.shouldRetryAfterFailure(responseData.activityKind)) {
            this.logger.error("Failed with current url strategy, but it will retry with new", new Object[0]);
            return true;
        }
        this.logger.error("Failed with current url strategy and it will not retry", new Object[0]);
        return false;
    }

    /*
     * Exception decompiling
     */
    private void tryToGetResponse(ResponseData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void localError(Throwable throwable, String string, ResponseData responseData, int n2) {
        String string2 = this.errorMessage(throwable, string, responseData.activityPackage);
        this.logger.error(string2, new Object[0]);
        responseData.message = string2;
        responseData.willRetry = false;
        responseData.activityPackage.addError(n2);
    }

    private void remoteError(Throwable throwable, String string, ResponseData responseData, Integer n2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        String string2 = stringBuilder.append(this.errorMessage(throwable, string, responseData.activityPackage)).append(" Will retry later").toString();
        this.logger.error(string2, new Object[0]);
        responseData.message = string2;
        responseData.willRetry = true;
        responseData.activityPackage.addError(n2);
    }

    private String errorMessage(Throwable object, String objectArray, ActivityPackage activityPackage) {
        String string = activityPackage.getFailureMessage();
        object = Util.getReasonString((String)objectArray, (Throwable)object);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = object;
        return Util.formatString("%s. (%s)", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private String generateUrlStringForGET(ActivityKind object, String object22, Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        Object object3;
        block5: {
            void var4_10;
            void var3_9;
            block4: {
                Uri.Builder builder;
                URL uRL;
                void var5_11;
                ActivityPackageSender activityPackageSender = object3;
                object3 = activityPackageSender.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), ActivityPackageSender.extractTargetUrl((Map<String, String>)var5_11, (ActivityKind)((Object)object), ((ActivityPackageSender)object3).urlStrategy));
                object = uRL;
                uRL = new URL((String)object3);
                object3 = builder;
                object3();
                object3.scheme(((URL)object).getProtocol());
                object3.encodedAuthority(((URL)object).getAuthority());
                object3.path(((URL)object).getPath());
                builder.appendPath((String)object22);
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = object3.toString();
                activityPackageSender.logger.debug("Making request to url: %s", (Object[])object);
                if (var5_11 == null || var5_11.isEmpty()) break block4;
                for (Map.Entry entry : var5_11.entrySet()) {
                    object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                }
                break block5;
            }
            if (var3_9 != null) {
                for (Map.Entry entry : var3_9.entrySet()) {
                    object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (var4_10 == null) break block5;
            for (Map.Entry entry : var4_10.entrySet()) {
                object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return object3.build().toString();
    }

    private String generateUrlStringForPOST(ActivityKind object, String string, Map<String, String> objectArray) {
        object = objectArray4.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), ActivityPackageSender.extractTargetUrl(objectArray, object, objectArray4.urlStrategy));
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = object;
        objectArray2[1] = string;
        object = Util.formatString("%s%s", objectArray);
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = object;
        objectArray4.logger.debug("Making request to url : %s", objectArray4);
        return object;
    }

    private String urlWithExtraPathByActivityKind(ActivityKind activityKind, String string) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprPath != null) {
                string = string + this.gdprPath;
            }
            return string;
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionPath != null) {
                string = string + this.subscriptionPath;
            }
            return string;
        }
        if (activityKind == ActivityKind.PURCHASE_VERIFICATION) {
            if (this.purchaseVerificationPath != null) {
                string = string + this.purchaseVerificationPath;
            }
            return string;
        }
        if (this.basePath != null) {
            string = string + this.basePath;
        }
        return string;
    }

    private DataOutputStream configConnectionForGET(HttpsURLConnection httpsURLConnection) {
        httpsURLConnection.setRequestMethod("GET");
        return null;
    }

    private DataOutputStream configConnectionForPOST(HttpsURLConnection httpsURLConnection, Map<String, String> object, Map<String, String> map, Map<String, String> map2) {
        HttpsURLConnection httpsURLConnection2 = httpsURLConnection;
        httpsURLConnection2.setRequestMethod("POST");
        httpsURLConnection2.setUseCaches(false);
        httpsURLConnection2.setDoInput(true);
        httpsURLConnection2.setDoOutput(true);
        object = objectArray2.generatePOSTBodyString((Map<String, String>)object, map, map2);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray2.logger.debug("Post body: %s", objectArray2);
        if (object == null) {
            return null;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.writeBytes((String)object);
        return dataOutputStream;
    }

    private String generatePOSTBodyString(Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (map3 != null && !map3.isEmpty()) {
            this.injectParametersToPOSTStringBuilder(map3, stringBuilder2);
        } else {
            if (map != null && !map.isEmpty()) {
                this.injectParametersToPOSTStringBuilder(map, stringBuilder2);
            }
            if (map2 != null && !map2.isEmpty()) {
                this.injectParametersToPOSTStringBuilder(map2, stringBuilder2);
            }
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3.charAt(stringBuilder3.length() - 1) == '&') {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.deleteCharAt(stringBuilder4.length() - 1);
            }
        }
        return stringBuilder2.toString();
    }

    private void injectParametersToPOSTStringBuilder(Map<String, String> object, StringBuilder stringBuilder) {
        if (object != null && !object.isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                object = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                String string = (String)entry.getValue();
                string = string != null ? URLEncoder.encode(string, "UTF-8") : "";
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append((String)object);
                stringBuilder2.append("=");
                stringBuilder2.append(string);
                stringBuilder2.append("&");
            }
            return;
        }
    }

    private void parseResponse(ResponseData responseData, String string) {
        JSONObject jSONObject;
        if (string.length() == 0) {
            this.logger.error("Empty response string", new Object[0]);
            return;
        }
        JSONObject jSONObject2 = null;
        JSONObject jSONObject3 = jSONObject;
        try {
            jSONObject = new JSONObject(string);
            jSONObject2 = jSONObject3;
        }
        catch (JSONException jSONException) {
            ActivityPackageSender activityPackageSender = this;
            string = activityPackageSender.errorMessage(jSONException, "Failed to parse JSON response", responseData.activityPackage);
            activityPackageSender.logger.error(string, new Object[0]);
        }
        if (jSONObject2 == null) {
            return;
        }
        responseData.jsonResponse = jSONObject2;
        responseData.message = UtilNetworking.extractJsonString(jSONObject2, "message");
        responseData.adid = UtilNetworking.extractJsonString(jSONObject2, "adid");
        responseData.timestamp = UtilNetworking.extractJsonString(jSONObject2, "timestamp");
        string = UtilNetworking.extractJsonString(jSONObject2, "tracking_state");
        if (string != null && string.equals("opted_out")) {
            responseData.trackingState = TrackingState.OPTED_OUT;
        }
        responseData.askIn = UtilNetworking.extractJsonLong(jSONObject2, "ask_in");
        responseData.retryIn = UtilNetworking.extractJsonLong(jSONObject2, "retry_in");
        responseData.continueIn = UtilNetworking.extractJsonLong(jSONObject2, "continue_in");
        responseData.attribution = Util.attributionFromJson(jSONObject2.optJSONObject("attribution"), Util.getSdkPrefixPlatform(this.clientSdk));
        responseData.resolvedDeeplink = UtilNetworking.extractJsonString(jSONObject2, "resolved_click_url");
        responseData.controlParams = jSONObject2.optJSONObject("control_params");
    }

    private static String extractAuthorizationHeader(Map<String, String> map) {
        return map.remove("authorization");
    }

    private static String extractTargetUrl(Map<String, String> object, ActivityKind activityKind, UrlStrategy urlStrategy) {
        if ((object = object.remove("endpoint")) != null) {
            return object;
        }
        return urlStrategy.targetUrlByActivityKind(activityKind);
    }

    @Override
    public void sendActivityPackage(final ActivityPackage activityPackage, final Map<String, String> map, final IActivityPackageSender.ResponseDataCallbackSubscriber responseDataCallbackSubscriber) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                a a2 = activityPackage2;
                ActivityPackage activityPackage2 = a2.activityPackage;
                activityPackage2.responseDataCallbackSubscriber.onResponseDataCallback(activityPackage2.ActivityPackageSender.this.sendActivityPackageSync(activityPackage2, a2.map));
            }
        });
    }

    @Override
    public ResponseData sendActivityPackageSync(ActivityPackage activityPackage, Map<String, String> map) {
        ResponseData responseData;
        ActivityPackageSender activityPackageSender;
        do {
            activityPackageSender = this;
            responseData = ResponseData.buildResponseData(activityPackage, map, this.signParameters(activityPackage, map));
            activityPackageSender.tryToGetResponse(responseData);
        } while (activityPackageSender.shouldRetryToSend(responseData));
        return responseData;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer readConnectionResponse(HttpsURLConnection var1_2, ResponseData var2_3) {
        block16: {
            block15: {
                v0 = var1_2;
                var3_4 = v1;
                v1 = new StringBuilder();
                var4_5 = null;
                v0.connect();
                var4_5 = v0.getResponseCode();
                var5_6 = var4_5 >= 400 ? var1_2.getErrorStream() : var1_2.getInputStream();
                var6_9 = v2;
                v2 = new InputStreamReader((InputStream)var5_6);
                var5_6 = v3;
                v3 = new BufferedReader((Reader)var6_9);
                ** while ((var6_9 = var5_6.readLine()) != null)
lbl-1000:
                // 1 sources

                {
                    var3_4.append((String)var6_9);
                    continue;
                }
lbl20:
                // 2 sources

                while (true) {
                    var1_2.disconnect();
                    break block15;
                    break;
                }
                {
                    catch (Throwable var0_1) {
                        break block16;
                    }
                    catch (IOException var5_7) {}
                    {
                        var5_8 = "Connecting and reading response";
                        var5_8 = this.errorMessage(var5_7, var5_8, var2_3.activityPackage);
                        this.logger.error(var5_8, new Object[0]);
                        if (var1_2 != null) ** continue;
                    }
                }
            }
            if (var3_4.length() == 0) {
                this.logger.error("Empty response string buffer", new Object[0]);
                return var4_5;
            }
            if (var4_5 == 429) {
                this.logger.error("Too frequent requests to the endpoint (429)", new Object[0]);
                return var4_5;
            }
            var1_2 = var3_4.toString();
            v4 = new Object[1];
            var3_4 = v4;
            v4[0] = var1_2;
            this.logger.debug("Response string: %s", var3_4);
            this.parseResponse(var2_3, (String)var1_2);
            if (var2_3.controlParams != null) {
                SharedPreferencesManager.getDefaultInstance(this.context).saveControlParams(var2_3.controlParams);
            }
            if ((var1_2 = var2_3.message) == null) {
                return var4_5;
            }
            if (var4_5 == 200) {
                v5 = new Object[1];
                this = v5;
                v5[0] = var1_2;
                this.logger.info("Response message: %s", this);
                return var4_5;
            }
            v6 = new Object[1];
            this = v6;
            v6[0] = var1_2;
            this.logger.error("Response message: %s", this);
            return var4_5;
        }
        if (var1_2 == null) throw var0_1;
        var1_2.disconnect();
        throw var0_1;
    }
}

