/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class SdkClickHandler
extends HandlerThread
implements ISdkClickHandler {
    private Handler internalHandler;
    private ILogger logger;
    private boolean paused;
    private List<ActivityPackage> packageQueue;
    private BackoffStrategy backoffStrategy;

    public SdkClickHandler(boolean startsSending) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.init(startsSending);
        this.logger = AdjustFactory.getLogger();
        this.internalHandler = new Handler(this.getLooper());
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
    }

    @Override
    public void init(boolean startsSending) {
        this.paused = !startsSending;
        this.packageQueue = new ArrayList<ActivityPackage>();
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage sdkClick) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.packageQueue.add(sdkClick);
                SdkClickHandler.this.logger.debug("Added sdk_click %d", SdkClickHandler.this.packageQueue.size());
                SdkClickHandler.this.logger.verbose("%s", sdkClick.getExtendedString());
                SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    private void sendNextSdkClick() {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                if (SdkClickHandler.this.paused) {
                    return;
                }
                if (SdkClickHandler.this.packageQueue.isEmpty()) {
                    return;
                }
                ActivityPackage sdkClickPackage = (ActivityPackage)SdkClickHandler.this.packageQueue.get(0);
                int retries = sdkClickPackage.getRetries();
                if (retries > 0) {
                    long waitTimeMilliSeconds = Util.getWaitingTime(retries, SdkClickHandler.this.backoffStrategy);
                    double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
                    String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
                    SdkClickHandler.this.logger.verbose("Sleeping for %s seconds before retrying sdk_click for the %d time", secondsString, retries);
                    SystemClock.sleep((long)waitTimeMilliSeconds);
                }
                SdkClickHandler.this.sendSdkClickInternal(sdkClickPackage);
                SdkClickHandler.this.packageQueue.remove(0);
                SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    private void sendSdkClickInternal(ActivityPackage sdkClickPackage) {
        String targetURL = "https://app.adjust.com" + sdkClickPackage.getPath();
        try {
            HttpsURLConnection connection = Util.createPOSTHttpsURLConnection(targetURL, sdkClickPackage.getClientSdk(), sdkClickPackage.getParameters(), this.packageQueue.size() - 1);
            ResponseData responseData = Util.readHttpResponse(connection, sdkClickPackage);
            if (responseData.jsonResponse == null) {
                this.retrySending(sdkClickPackage);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logErrorMessage(sdkClickPackage, "Sdk_click failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.logErrorMessage(sdkClickPackage, "Sdk_click request timed out. Will retry later", e);
            this.retrySending(sdkClickPackage);
        }
        catch (IOException e) {
            this.logErrorMessage(sdkClickPackage, "Sdk_click request failed. Will retry later", e);
            this.retrySending(sdkClickPackage);
        }
        catch (Throwable e) {
            this.logErrorMessage(sdkClickPackage, "Sdk_click runtime exception", e);
        }
    }

    private void retrySending(ActivityPackage sdkClickPackage) {
        int retries = sdkClickPackage.increaseRetries();
        this.logger.error("Retrying sdk_click package for the %d time", retries);
        this.sendSdkClick(sdkClickPackage);
    }

    private void logErrorMessage(ActivityPackage sdkClickPackage, String message, Throwable throwable) {
        String packageMessage = sdkClickPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s)", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
    }
}

