/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
extends HandlerThread
implements IPackageHandler {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private Handler internalHandler;
    private IRequestHandler requestHandler;
    private IActivityHandler activityHandler;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;

    public PackageHandler(IActivityHandler activityHandler, Context context, boolean startsSending) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.internalHandler = new Handler(this.getLooper());
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getPackageHandlerBackoffStrategy();
        this.init(activityHandler, context, startsSending);
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.initInternal();
            }
        });
    }

    @Override
    public void init(IActivityHandler activityHandler, Context context, boolean startsSending) {
        this.activityHandler = activityHandler;
        this.context = context;
        this.paused = !startsSending;
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.addInternal(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendFirstInternal();
            }
        });
    }

    @Override
    public void sendNextPackage(ResponseData responseData) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendNextInternal();
            }
        });
        this.activityHandler.finishedTrackingActivity(responseData);
    }

    @Override
    public void closeFirstPackage(ResponseData responseData, ActivityPackage activityPackage) {
        responseData.willRetry = true;
        this.activityHandler.finishedTrackingActivity(responseData);
        if (activityPackage != null) {
            int retries = activityPackage.increaseRetries();
            long waitTime = Util.getWaitingTime(retries, this.backoffStrategy);
            double waitTimeSeconds = (double)waitTime / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.verbose("Sleeping for %s seconds before retrying the %d time", secondsString, retries);
            SystemClock.sleep((long)waitTime);
        }
        this.logger.verbose("Package handler can send", new Object[0]);
        this.isSending.set(false);
        this.sendFirstPackage();
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void initInternal() {
        this.requestHandler = AdjustFactory.getRequestHandler(this);
        this.isSending = new AtomicBoolean();
        this.readPackageQueue();
    }

    private void addInternal(ActivityPackage newPackage) {
        this.packageQueue.add(newPackage);
        this.logger.debug("Added package %d (%s)", this.packageQueue.size(), newPackage);
        this.logger.verbose("%s", newPackage.getExtendedString());
        this.writePackageQueue();
    }

    private void sendFirstInternal() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        ActivityPackage firstPackage = this.packageQueue.get(0);
        this.requestHandler.sendPackage(firstPackage, this.packageQueue.size() - 1);
    }

    private void sendNextInternal() {
        this.packageQueue.remove(0);
        this.writePackageQueue();
        this.isSending.set(false);
        this.logger.verbose("Package handler can send", new Object[0]);
        this.sendFirstInternal();
    }

    private void readPackageQueue() {
        try {
            this.packageQueue = Util.readObject(this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", PACKAGE_QUEUE_NAME, e.getMessage());
            this.packageQueue = null;
        }
        if (this.packageQueue != null) {
            this.logger.debug("Package handler read %d packages", this.packageQueue.size());
        } else {
            this.packageQueue = new ArrayList<ActivityPackage>();
        }
    }

    private void writePackageQueue() {
        Util.writeObject(this.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        this.logger.debug("Package handler wrote %d packages", this.packageQueue.size());
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }
}

