/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;

public class RequestHandler
extends HandlerThread
implements IRequestHandler {
    private InternalHandler internalHandler;
    private IPackageHandler packageHandler;
    private ILogger logger;

    public RequestHandler(IPackageHandler packageHandler) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.logger = AdjustFactory.getLogger();
        this.internalHandler = new InternalHandler(this.getLooper(), this);
        this.init(packageHandler);
    }

    @Override
    public void init(IPackageHandler packageHandler) {
        this.packageHandler = packageHandler;
    }

    @Override
    public void sendPackage(ActivityPackage pack) {
        Message message = Message.obtain();
        message.arg1 = 72400;
        message.obj = pack;
        this.internalHandler.sendMessage(message);
    }

    private void sendInternal(ActivityPackage activityPackage) {
        String targetURL = "https://app.adjust.com" + activityPackage.getPath();
        try {
            HttpsURLConnection connection = Util.createPOSTHttpsURLConnection(targetURL, activityPackage.getClientSdk(), activityPackage.getParameters());
            ResponseData responseData = Util.readHttpResponse(connection, activityPackage);
            this.requestFinished(responseData);
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackage(activityPackage, "Failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.closePackage(activityPackage, "Request timed out", e);
        }
        catch (IOException e) {
            this.closePackage(activityPackage, "Request failed", e);
        }
        catch (Throwable e) {
            this.sendNextPackage(activityPackage, "Runtime exception", e);
        }
    }

    private void requestFinished(ResponseData responseData) throws JSONException {
        if (responseData.jsonResponse == null) {
            this.packageHandler.closeFirstPackage(responseData);
            return;
        }
        this.packageHandler.sendNextPackage(responseData);
    }

    private void closePackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String packageMessage = activityPackage.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s) Will retry later", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        this.packageHandler.closeFirstPackage(responseData);
    }

    private void sendNextPackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s)", failureMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        this.packageHandler.sendNextPackage(responseData);
    }

    private String getReasonString(String message, Throwable throwable) {
        if (throwable != null) {
            return String.format(Locale.US, "%s: %s", message, throwable);
        }
        return String.format(Locale.US, "%s", message);
    }

    private static final class InternalHandler
    extends Handler {
        private static final int SEND = 72400;
        private final WeakReference<RequestHandler> requestHandlerReference;

        protected InternalHandler(Looper looper, RequestHandler requestHandler) {
            super(looper);
            this.requestHandlerReference = new WeakReference<RequestHandler>(requestHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            RequestHandler requestHandler = (RequestHandler)this.requestHandlerReference.get();
            if (requestHandler == null) {
                return;
            }
            switch (message.arg1) {
                case 72400: {
                    ActivityPackage activityPackage = (ActivityPackage)message.obj;
                    requestHandler.sendInternal(activityPackage);
                }
            }
        }
    }
}

