/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustPurchase;
import com.adjust.sdk.AdjustPurchaseVerificationResult;
import com.adjust.sdk.AdjustTestOptions;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.OnPurchaseVerificationFinishedListener;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class AdjustInstance {
    private String pushToken;
    private Boolean startEnabled = null;
    private boolean startOffline = false;
    private IActivityHandler activityHandler;
    private PreLaunchActions preLaunchActions;
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String purchaseVerificationPath;

    public AdjustInstance() {
        PreLaunchActions preLaunchActions;
        PreLaunchActions preLaunchActions2 = preLaunchActions;
        preLaunchActions = new PreLaunchActions();
        v1.preLaunchActions = preLaunchActions2;
    }

    private boolean checkActivityHandler(String string) {
        return this.checkActivityHandler(string, false);
    }

    private boolean checkActivityHandler(boolean bl, String string, String string2) {
        if (bl) {
            return this.checkActivityHandler(string, true);
        }
        return this.checkActivityHandler(string2, true);
    }

    private boolean checkActivityHandler(String string, boolean bl) {
        Object[] objectArray;
        if (objectArray.activityHandler != null) {
            return true;
        }
        if (string == null) {
            AdjustFactory.getLogger().error("Adjust not initialized correctly", new Object[0]);
            return false;
        }
        if (bl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            AdjustFactory.getLogger().warn("Adjust not initialized, but %s saved for launch", objectArray);
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
            AdjustFactory.getLogger().warn("Adjust not initialized, can't perform %s", objectArray);
        }
        return false;
    }

    private void saveRawReferrer(String string, long l2, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveRawReferrer(string, l2);
    }

    private void savePreinstallReferrer(String string, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePreinstallReferrer(string);
    }

    private void savePushToken(String string, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePushToken(string);
    }

    private void saveGdprForgetMe(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setGdprForgetMe();
    }

    private void saveDisableThirdPartySharing(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setDisableThirdPartySharing();
    }

    private void saveDeeplink(Uri uri, long l2, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveDeeplink(uri, l2);
    }

    private void setSendingReferrersAsNotSent(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setSendingReferrersAsNotSent();
    }

    private boolean isInstanceEnabled() {
        Boolean bl = ((AdjustInstance)((Object)bl)).startEnabled;
        return bl == null || bl.booleanValue();
    }

    public void onCreate(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return;
        }
        if (this.activityHandler != null) {
            AdjustFactory.getLogger().error("Adjust already initialized", new Object[0]);
            return;
        }
        adjustConfig.preLaunchActions = this.preLaunchActions;
        adjustConfig.pushToken = this.pushToken;
        adjustConfig.startEnabled = this.startEnabled;
        adjustConfig.startOffline = this.startOffline;
        adjustConfig.basePath = this.basePath;
        adjustConfig.gdprPath = this.gdprPath;
        adjustConfig.subscriptionPath = this.subscriptionPath;
        adjustConfig.purchaseVerificationPath = this.purchaseVerificationPath;
        this.activityHandler = AdjustFactory.getActivityHandler(adjustConfig);
        this.setSendingReferrersAsNotSent(adjustConfig.context);
    }

    public void trackEvent(AdjustEvent adjustEvent) {
        if (!this.checkActivityHandler("trackEvent")) {
            return;
        }
        this.activityHandler.trackEvent(adjustEvent);
    }

    public void onResume() {
        if (!this.checkActivityHandler("onResume")) {
            return;
        }
        this.activityHandler.onResume();
    }

    public void onPause() {
        if (!this.checkActivityHandler("onPause")) {
            return;
        }
        this.activityHandler.onPause();
    }

    public void setEnabled(boolean bl) {
        this.startEnabled = bl;
        if (this.checkActivityHandler(bl, "enabled mode", "disabled mode")) {
            this.activityHandler.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        if (!this.checkActivityHandler("isEnabled")) {
            return this.isInstanceEnabled();
        }
        return this.activityHandler.isEnabled();
    }

    public void appWillOpenUrl(Uri uri) {
        if (!this.checkActivityHandler("appWillOpenUrl")) {
            return;
        }
        long l2 = System.currentTimeMillis();
        this.activityHandler.readOpenUrl(uri, l2);
    }

    public void appWillOpenUrl(Uri uri, Context context) {
        if (uri != null && uri.toString().length() != 0) {
            long l2 = System.currentTimeMillis();
            if (!this.checkActivityHandler("appWillOpenUrl", true)) {
                this.saveDeeplink(uri, l2, context);
                return;
            }
            this.activityHandler.readOpenUrl(uri, l2);
            return;
        }
        AdjustFactory.getLogger().warn("Skipping deep link processing (null or empty)", new Object[0]);
    }

    public void sendReferrer(String string, Context context) {
        long l2 = System.currentTimeMillis();
        if (string != null && string.length() != 0) {
            AdjustInstance adjustInstance = this;
            adjustInstance.saveRawReferrer(string, l2, context);
            if (adjustInstance.checkActivityHandler("referrer", true) && this.activityHandler.isEnabled()) {
                this.activityHandler.sendReftagReferrer();
            }
            return;
        }
        AdjustFactory.getLogger().warn("Skipping INSTALL_REFERRER intent referrer processing (null or empty)", new Object[0]);
    }

    public void sendPreinstallReferrer(String string, Context context) {
        if (string != null && string.length() != 0) {
            AdjustInstance adjustInstance = this;
            adjustInstance.savePreinstallReferrer(string, context);
            if (adjustInstance.checkActivityHandler("preinstall referrer", true) && this.activityHandler.isEnabled()) {
                this.activityHandler.sendPreinstallReferrer();
            }
            return;
        }
        AdjustFactory.getLogger().warn("Skipping SYSTEM_INSTALLER_REFERRER preinstall referrer processing (null or empty)", new Object[0]);
    }

    public void setOfflineMode(boolean bl) {
        if (!this.checkActivityHandler(bl, "offline mode", "online mode")) {
            this.startOffline = bl;
        } else {
            this.activityHandler.setOfflineMode(bl);
        }
    }

    public void sendFirstPackages() {
        if (!this.checkActivityHandler("sendFirstPackages")) {
            return;
        }
        this.activityHandler.sendFirstPackages();
    }

    public void addSessionCallbackParameter(final String string, final String string2) {
        if (this.checkActivityHandler("adding session callback parameter", true)) {
            this.activityHandler.addSessionCallbackParameter(string, string2);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                a a2 = string3;
                String string3 = a2.string;
                activityHandler.addSessionCallbackParameterI(string3, a2.string2);
            }
        });
    }

    public void addSessionPartnerParameter(final String string, final String string2) {
        if (this.checkActivityHandler("adding session partner parameter", true)) {
            this.activityHandler.addSessionPartnerParameter(string, string2);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                b b2 = string3;
                String string3 = b2.string;
                activityHandler.addSessionPartnerParameterI(string3, b2.string2);
            }
        });
    }

    public void removeSessionCallbackParameter(final String string) {
        if (this.checkActivityHandler("removing session callback parameter", true)) {
            this.activityHandler.removeSessionCallbackParameter(string);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionCallbackParameterI(string);
            }
        });
    }

    public void removeSessionPartnerParameter(final String string) {
        if (this.checkActivityHandler("removing session partner parameter", true)) {
            this.activityHandler.removeSessionPartnerParameter(string);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeSessionPartnerParameterI(string);
            }
        });
    }

    public void resetSessionCallbackParameters() {
        if (this.checkActivityHandler("resetting session callback parameters", true)) {
            this.activityHandler.resetSessionCallbackParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionCallbackParametersI();
            }
        });
    }

    public void resetSessionPartnerParameters() {
        if (this.checkActivityHandler("resetting session partner parameters", true)) {
            this.activityHandler.resetSessionPartnerParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.resetSessionPartnerParametersI();
            }
        });
    }

    public void teardown() {
        if (!this.checkActivityHandler("teardown")) {
            return;
        }
        this.activityHandler.teardown();
        this.activityHandler = null;
    }

    public void setPushToken(String string) {
        if (!this.checkActivityHandler("push token", true)) {
            this.pushToken = string;
        } else {
            this.activityHandler.setPushToken(string, false);
        }
    }

    public void setPushToken(String string, Context context) {
        AdjustInstance adjustInstance = this;
        adjustInstance.savePushToken(string, context);
        if (adjustInstance.checkActivityHandler("push token", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.setPushToken(string, true);
        }
    }

    public void gdprForgetMe(Context context) {
        AdjustInstance adjustInstance = this;
        adjustInstance.saveGdprForgetMe(context);
        if (adjustInstance.checkActivityHandler("gdpr", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.gdprForgetMe();
        }
    }

    public void disableThirdPartySharing(Context context) {
        if (!this.checkActivityHandler("disable third party sharing", true)) {
            this.saveDisableThirdPartySharing(context);
            return;
        }
        this.activityHandler.disableThirdPartySharing();
    }

    public void trackThirdPartySharing(AdjustThirdPartySharing adjustThirdPartySharing) {
        if (!this.checkActivityHandler("third party sharing", true)) {
            this.preLaunchActions.preLaunchAdjustThirdPartySharingArray.add(adjustThirdPartySharing);
            return;
        }
        this.activityHandler.trackThirdPartySharing(adjustThirdPartySharing);
    }

    public void trackMeasurementConsent(boolean bl) {
        if (!this.checkActivityHandler("measurement consent", true)) {
            this.preLaunchActions.lastMeasurementConsentTracked = bl;
            return;
        }
        this.activityHandler.trackMeasurementConsent(bl);
    }

    public void trackAdRevenue(String string, JSONObject jSONObject) {
        if (!this.checkActivityHandler("trackAdRevenue")) {
            return;
        }
        this.activityHandler.trackAdRevenue(string, jSONObject);
    }

    public void trackAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        if (!this.checkActivityHandler("trackAdRevenue")) {
            return;
        }
        this.activityHandler.trackAdRevenue(adjustAdRevenue);
    }

    public void trackPlayStoreSubscription(AdjustPlayStoreSubscription adjustPlayStoreSubscription) {
        if (!this.checkActivityHandler("trackPlayStoreSubscription")) {
            return;
        }
        this.activityHandler.trackPlayStoreSubscription(adjustPlayStoreSubscription);
    }

    public String getAdid() {
        if (!this.checkActivityHandler("getAdid")) {
            return null;
        }
        return this.activityHandler.getAdid();
    }

    public AdjustAttribution getAttribution() {
        if (!this.checkActivityHandler("getAttribution")) {
            return null;
        }
        return this.activityHandler.getAttribution();
    }

    public String getSdkVersion() {
        return Util.getSdkVersion();
    }

    public void verifyPurchase(AdjustPurchase adjustPurchase, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        if (!((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).checkActivityHandler("verifyPurchase")) {
            if (onPurchaseVerificationFinishedListener != null) {
                AdjustPurchaseVerificationResult adjustPurchaseVerificationResult;
                AdjustPurchaseVerificationResult adjustPurchaseVerificationResult2 = adjustPurchaseVerificationResult;
                adjustPurchaseVerificationResult = new AdjustPurchaseVerificationResult("not_verified", 100, "SDK needs to be initialized before making purchase verification request");
                onPurchaseVerificationFinishedListener.onVerificationFinished(adjustPurchaseVerificationResult2);
            }
            return;
        }
        ((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).activityHandler.verifyPurchase(adjustPurchase, onPurchaseVerificationFinishedListener);
    }

    public void setTestOptions(AdjustTestOptions adjustTestOptions) {
        String string = adjustTestOptions.basePath;
        if (string != null) {
            ((AdjustInstance)this).basePath = string;
        }
        if ((string = adjustTestOptions.gdprPath) != null) {
            ((AdjustInstance)this).gdprPath = string;
        }
        if ((string = adjustTestOptions.subscriptionPath) != null) {
            ((AdjustInstance)this).subscriptionPath = string;
        }
        if ((string = adjustTestOptions.purchaseVerificationPath) != null) {
            ((AdjustInstance)this).purchaseVerificationPath = string;
        }
        if ((this = adjustTestOptions.baseUrl) != null) {
            AdjustFactory.setBaseUrl((String)this);
        }
        if ((this = adjustTestOptions.gdprUrl) != null) {
            AdjustFactory.setGdprUrl((String)this);
        }
        if ((this = adjustTestOptions.subscriptionUrl) != null) {
            AdjustFactory.setSubscriptionUrl((String)this);
        }
        if ((this = adjustTestOptions.purchaseVerificationUrl) != null) {
            AdjustFactory.setPurchaseVerificationUrl((String)this);
        }
        if ((this = adjustTestOptions.timerIntervalInMilliseconds) != null) {
            AdjustFactory.setTimerInterval((Long)this);
        }
        if (adjustTestOptions.timerStartInMilliseconds != null) {
            AdjustFactory.setTimerStart(adjustTestOptions.timerIntervalInMilliseconds);
        }
        if ((this = adjustTestOptions.sessionIntervalInMilliseconds) != null) {
            AdjustFactory.setSessionInterval((Long)this);
        }
        if ((this = adjustTestOptions.subsessionIntervalInMilliseconds) != null) {
            AdjustFactory.setSubsessionInterval((Long)this);
        }
        if ((this = adjustTestOptions.tryInstallReferrer) != null) {
            AdjustFactory.setTryInstallReferrer((Boolean)this);
        }
        if (adjustTestOptions.noBackoffWait != null) {
            BackoffStrategy backoffStrategy = BackoffStrategy.NO_WAIT;
            AdjustFactory.setPackageHandlerBackoffStrategy(backoffStrategy);
            AdjustFactory.setSdkClickBackoffStrategy(backoffStrategy);
        }
        if ((this = adjustTestOptions.enableSigning) != null && ((Boolean)this).booleanValue()) {
            AdjustFactory.enableSigning();
        }
        if ((this = adjustTestOptions.disableSigning) != null && ((Boolean)this).booleanValue()) {
            AdjustFactory.disableSigning();
        }
    }

    public static class PreLaunchActions {
        public List<IRunActivityHandler> preLaunchActionsArray;
        public List<AdjustThirdPartySharing> preLaunchAdjustThirdPartySharingArray;
        public Boolean lastMeasurementConsentTracked;

        public PreLaunchActions() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.preLaunchActionsArray = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.preLaunchAdjustThirdPartySharingArray = object;
            v1.lastMeasurementConsentTracked = null;
        }
    }
}

