/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import com.adjust.sdk.ActivityKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UrlStrategy {
    private static final String BASE_URL_INDIA = "https://app.adjust.net.in";
    private static final String GDPR_URL_INDIA = "https://gdpr.adjust.net.in";
    private static final String SUBSCRIPTION_URL_INDIA = "https://subscription.adjust.net.in";
    private static final String BASE_URL_CHINA = "https://app.adjust.world";
    private static final String GDPR_URL_CHINA = "https://gdpr.adjust.world";
    private static final String SUBSCRIPTION_URL_CHINA = "https://subscription.adjust.world";
    private static final String BASE_URL_CN = "https://app.adjust.cn";
    private static final String GDPR_URL_CN = "https://gdpr.adjust.com";
    private static final String SUBSCRIPTION_URL_CN = "https://subscription.adjust.com";
    private static final String BASE_URL_EU = "https://app.eu.adjust.com";
    private static final String GDPR_URL_EU = "https://gdpr.eu.adjust.com";
    private static final String SUBSCRIPTION_URL_EU = "https://subscription.eu.adjust.com";
    private static final String BASE_URL_TR = "https://app.tr.adjust.com";
    private static final String GDPR_URL_TR = "https://gdpr.tr.adjust.com";
    private static final String SUBSCRIPTION_URL_TR = "https://subscription.tr.adjust.com";
    private static final String BASE_URL_US = "https://app.us.adjust.com";
    private static final String GDPR_URL_US = "https://gdpr.us.adjust.com";
    private static final String SUBSCRIPTION_URL_US = "https://subscription.us.adjust.com";
    private final String baseUrlOverwrite;
    private final String gdprUrlOverwrite;
    private final String subscriptionUrlOverwrite;
    public final List<String> baseUrlChoicesList;
    public final List<String> gdprUrlChoicesList;
    public final List<String> subscriptionUrlChoicesList;
    public boolean wasLastAttemptSuccess;
    public int choiceIndex;
    public int startingChoiceIndex;
    public boolean wasLastAttemptWithOverwrittenUrl;

    public UrlStrategy(String string, String string2, String string3, String string4) {
        UrlStrategy urlStrategy = this;
        this.baseUrlOverwrite = string;
        this.gdprUrlOverwrite = string2;
        this.subscriptionUrlOverwrite = string3;
        this.baseUrlChoicesList = UrlStrategy.baseUrlChoices(string4);
        this.gdprUrlChoicesList = UrlStrategy.gdprUrlChoices(string4);
        urlStrategy.subscriptionUrlChoicesList = UrlStrategy.subscriptionUrlChoices(string4);
        urlStrategy.wasLastAttemptSuccess = false;
        urlStrategy.choiceIndex = 0;
        urlStrategy.startingChoiceIndex = 0;
        urlStrategy.wasLastAttemptWithOverwrittenUrl = false;
    }

    private static List<String> baseUrlChoices(String string) {
        if ("url_strategy_india".equals(string)) {
            return Arrays.asList(BASE_URL_INDIA, "https://app.adjust.com");
        }
        if ("url_strategy_china".equals(string)) {
            return Arrays.asList(BASE_URL_CHINA, "https://app.adjust.com");
        }
        if ("url_strategy_cn".equals(string)) {
            return Arrays.asList(BASE_URL_CN, "https://app.adjust.com");
        }
        if ("data_residency_eu".equals(string)) {
            return Collections.singletonList(BASE_URL_EU);
        }
        if ("data_residency_tr".equals(string)) {
            return Collections.singletonList(BASE_URL_TR);
        }
        if ("data_residency_us".equals(string)) {
            return Collections.singletonList(BASE_URL_US);
        }
        return Arrays.asList("https://app.adjust.com", BASE_URL_INDIA, BASE_URL_CHINA);
    }

    private static List<String> gdprUrlChoices(String string) {
        if ("url_strategy_india".equals(string)) {
            return Arrays.asList(GDPR_URL_INDIA, GDPR_URL_CN);
        }
        if ("url_strategy_china".equals(string)) {
            return Arrays.asList(GDPR_URL_CHINA, GDPR_URL_CN);
        }
        if ("url_strategy_cn".equals(string)) {
            return Arrays.asList(GDPR_URL_CN, GDPR_URL_CN);
        }
        if ("data_residency_eu".equals(string)) {
            return Collections.singletonList(GDPR_URL_EU);
        }
        if ("data_residency_tr".equals(string)) {
            return Collections.singletonList(GDPR_URL_TR);
        }
        if ("data_residency_us".equals(string)) {
            return Collections.singletonList(GDPR_URL_US);
        }
        return Arrays.asList(GDPR_URL_CN, GDPR_URL_INDIA, GDPR_URL_CHINA);
    }

    private static List<String> subscriptionUrlChoices(String string) {
        if ("url_strategy_india".equals(string)) {
            return Arrays.asList(SUBSCRIPTION_URL_INDIA, SUBSCRIPTION_URL_CN);
        }
        if ("url_strategy_china".equals(string)) {
            return Arrays.asList(SUBSCRIPTION_URL_CHINA, SUBSCRIPTION_URL_CN);
        }
        if ("url_strategy_cn".equals(string)) {
            return Arrays.asList(SUBSCRIPTION_URL_CN, SUBSCRIPTION_URL_CN);
        }
        if ("data_residency_eu".equals(string)) {
            return Collections.singletonList(SUBSCRIPTION_URL_EU);
        }
        if ("data_residency_tr".equals(string)) {
            return Collections.singletonList(SUBSCRIPTION_URL_TR);
        }
        if ("data_residency_us".equals(string)) {
            return Collections.singletonList(SUBSCRIPTION_URL_US);
        }
        return Arrays.asList(SUBSCRIPTION_URL_CN, SUBSCRIPTION_URL_INDIA, SUBSCRIPTION_URL_CHINA);
    }

    public void resetAfterSuccess() {
        this.startingChoiceIndex = this.choiceIndex;
        this.wasLastAttemptSuccess = true;
    }

    public boolean shouldRetryAfterFailure(ActivityKind activityKind) {
        this.wasLastAttemptSuccess = false;
        if (this.wasLastAttemptWithOverwrittenUrl) {
            return false;
        }
        int n2 = activityKind == ActivityKind.GDPR ? this.gdprUrlChoicesList.size() : (activityKind == ActivityKind.SUBSCRIPTION ? this.subscriptionUrlChoicesList.size() : this.baseUrlChoicesList.size());
        this.choiceIndex = n2 = (this.choiceIndex + 1) % n2;
        return n2 != this.startingChoiceIndex;
    }

    public String targetUrlByActivityKind(ActivityKind object) {
        if (object == ActivityKind.GDPR) {
            object = this.gdprUrlOverwrite;
            if (object != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return object;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.gdprUrlChoicesList.get(this.choiceIndex);
        }
        if (object == ActivityKind.SUBSCRIPTION) {
            object = this.subscriptionUrlOverwrite;
            if (object != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return object;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.subscriptionUrlChoicesList.get(this.choiceIndex);
        }
        object = this.baseUrlOverwrite;
        if (object != null) {
            this.wasLastAttemptWithOverwrittenUrl = true;
            return object;
        }
        this.wasLastAttemptWithOverwrittenUrl = false;
        return this.baseUrlChoicesList.get(this.choiceIndex);
    }
}

