/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdjustAdRevenue {
    private static final ILogger logger = AdjustFactory.getLogger();
    public String source;
    public Double revenue;
    public String currency;
    public Integer adImpressionsCount;
    public String adRevenueNetwork;
    public String adRevenueUnit;
    public String adRevenuePlacement;
    public Map<String, String> callbackParameters;
    public Map<String, String> partnerParameters;

    public AdjustAdRevenue(String string) {
        if (!this.isValidSource(string)) {
            return;
        }
        this.source = string;
    }

    private boolean isValidSource(String string) {
        if (string == null) {
            logger.error("Missing source", new Object[0]);
            return false;
        }
        if (string.isEmpty()) {
            logger.error("Source can't be empty", new Object[0]);
            return false;
        }
        return true;
    }

    public void setRevenue(Double d2, String string) {
        AdjustAdRevenue adjustAdRevenue = this;
        adjustAdRevenue.revenue = d2;
        adjustAdRevenue.currency = string;
    }

    public void setAdImpressionsCount(Integer n2) {
        this.adImpressionsCount = n2;
    }

    public void setAdRevenueNetwork(String string) {
        this.adRevenueNetwork = string;
    }

    public void setAdRevenueUnit(String string) {
        this.adRevenueUnit = string;
    }

    public void setAdRevenuePlacement(String string) {
        this.adRevenuePlacement = string;
    }

    public void addCallbackParameter(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Callback")) {
            return;
        }
        if (!Util.isValidParameter(string2, "value", "Callback")) {
            return;
        }
        if (objectArray2.callbackParameters == null) {
            LinkedHashMap<String, String> linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, String>();
            objectArray2.callbackParameters = linkedHashMap2;
        }
        if (objectArray2.callbackParameters.put(string, string2) != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            logger.warn("Key %s was overwritten", objectArray2);
        }
    }

    public void addPartnerParameter(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Partner")) {
            return;
        }
        if (!Util.isValidParameter(string2, "value", "Partner")) {
            return;
        }
        if (objectArray2.partnerParameters == null) {
            LinkedHashMap<String, String> linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, String>();
            objectArray2.partnerParameters = linkedHashMap2;
        }
        if (objectArray2.partnerParameters.put(string, string2) != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            logger.warn("Key %s was overwritten", objectArray2);
        }
    }

    public boolean isValid() {
        AdjustAdRevenue adjustAdRevenue = this;
        return adjustAdRevenue.isValidSource(adjustAdRevenue.source);
    }
}

