/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.util.Log;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.Util;
import java.util.Arrays;
import java.util.Locale;

public class Logger
implements ILogger {
    private static String formatErrorMessage = "Error formating log message: %s, with params: %s";
    private LogLevel logLevel;
    private boolean logLevelLocked;
    private boolean isProductionEnvironment;

    public Logger() {
        Logger logger = this;
        logger.isProductionEnvironment = false;
        logger.logLevelLocked = false;
        logger.setLogLevel(LogLevel.INFO, false);
    }

    @Override
    public void setLogLevel(LogLevel logLevel, boolean bl) {
        if (this.logLevelLocked) {
            return;
        }
        Logger logger = this;
        logger.logLevel = logLevel;
        logger.isProductionEnvironment = bl;
    }

    @Override
    public void setLogLevelString(String string, boolean bl) {
        if (string != null) {
            try {
                objectArray3.setLogLevel(LogLevel.valueOf(string.toUpperCase(Locale.US)), bl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = string;
                objectArray.error("Malformed logLevel '%s', falling back to 'info'", objectArray3);
            }
        }
    }

    @Override
    public void verbose(String string, Object ... objectArray) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 2) {
            try {
                Log.v((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 3) {
            try {
                Log.d((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 4) {
            try {
                Log.i((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 5) {
            try {
                Log.w((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void warnInProduction(String string, Object ... objectArray) {
        if (this.logLevel.androidLogLevel <= 5) {
            try {
                Log.w((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void error(String string, Object ... objectArray) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 6) {
            try {
                Log.e((String)"Adjust", (String)Util.formatString(string, objectArray));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void Assert(String string, Object ... objectArray) {
        if (((Logger)((Object)string3)).isProductionEnvironment) {
            return;
        }
        if (((Logger)((Object)string3)).logLevel.androidLogLevel <= 7) {
            String string2 = string;
            Object[] objectArray2 = objectArray;
            String string3 = "Adjust";
            try {
                Log.println((int)7, (String)string3, (String)Util.formatString(string2, objectArray2));
            }
            catch (Exception exception) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, string, Arrays.toString(objectArray)));
            }
        }
    }

    @Override
    public void lockLogLevel() {
        this.logLevelLocked = true;
    }
}

