/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.adjust.sdk.AdjustFactory;
import org.json.JSONArray;
import org.json.JSONException;

public class SharedPreferencesManager {
    private static final String PREFS_NAME = "adjust_preferences";
    private static final String PREFS_KEY_RAW_REFERRERS = "raw_referrers";
    private static final String PREFS_KEY_PUSH_TOKEN = "push_token";
    private static final String PREFS_KEY_INSTALL_TRACKED = "install_tracked";
    private static final String PREFS_KEY_GDPR_FORGET_ME = "gdpr_forget_me";
    private static final String PREFS_KEY_DISABLE_THIRD_PARTY_SHARING = "disable_third_party_sharing";
    private static final String PREFS_KEY_DEEPLINK_URL = "deeplink_url";
    private static final String PREFS_KEY_DEEPLINK_CLICK_TIME = "deeplink_click_time";
    private static final String PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS = "preinstall_payload_read_status";
    private static final String PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER = "preinstall_system_installer_referrer";
    private static final int INDEX_RAW_REFERRER = 0;
    private static final int INDEX_CLICK_TIME = 1;
    private static final int INDEX_IS_SENDING = 2;
    private static final int REFERRERS_COUNT = 10;
    private static SharedPreferences sharedPreferences;
    private static SharedPreferences.Editor sharedPreferencesEditor;
    private static SharedPreferencesManager defaultInstance;

    private SharedPreferencesManager(Context objectArray) {
        try {
            sharedPreferences = objectArray.getSharedPreferences(PREFS_NAME, 0);
            sharedPreferencesEditor = sharedPreferences.edit();
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception.getMessage();
            AdjustFactory.getLogger().error("Cannot access to SharedPreferences", objectArray);
            sharedPreferences = null;
            sharedPreferencesEditor = null;
        }
    }

    public static synchronized SharedPreferencesManager getDefaultInstance(Context context) {
        if (defaultInstance == null) {
            defaultInstance = new SharedPreferencesManager(context);
        }
        return defaultInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int getRawReferrerIndex(String string, long l2) {
        try {
            SharedPreferencesManager sharedPreferencesManager = sharedPreferencesManager.getRawReferrerArray();
            for (int i2 = 0; i2 < sharedPreferencesManager.length(); ++i2) {
                JSONArray jSONArray = sharedPreferencesManager.getJSONArray(i2);
                String string2 = jSONArray.optString(0, null);
                if (string2 == null || !string2.equals(string) || jSONArray.optLong(1, -1L) != l2) continue;
                return i2;
            }
        }
        catch (JSONException jSONException) {}
        return -1;
    }

    private synchronized void saveString(String string, String string2) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putString(string, string2).apply();
        }
    }

    private synchronized void saveBoolean(String string, boolean bl) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putBoolean(string, bl).apply();
        }
    }

    private synchronized void saveLong(String string, long l2) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putLong(string, l2).apply();
        }
    }

    private synchronized void saveInteger(String string, int n2) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putInt(string, n2).apply();
        }
    }

    private synchronized String getString(String string) {
        SharedPreferences sharedPreferences = SharedPreferencesManager.sharedPreferences;
        if (sharedPreferences != null) {
            try {
                return sharedPreferences.getString(string, null);
            }
            catch (Throwable throwable) {
                if (string.equals(PREFS_KEY_RAW_REFERRERS)) {
                    this.remove(PREFS_KEY_RAW_REFERRERS);
                }
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    private synchronized boolean getBoolean(String string, boolean bl) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferences;
        if (sharedPreferencesManager != null) {
            try {
                return sharedPreferencesManager.getBoolean(string, bl);
            }
            catch (ClassCastException classCastException) {
                return bl;
            }
        }
        return bl;
    }

    private synchronized long getLong(String string, long l2) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferences;
        if (sharedPreferencesManager != null) {
            try {
                return sharedPreferencesManager.getLong(string, l2);
            }
            catch (ClassCastException classCastException) {
                return l2;
            }
        }
        return l2;
    }

    private synchronized void remove(String string) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.remove(string).apply();
        }
    }

    public synchronized void saveRawReferrer(String string, long l2) {
        JSONArray jSONArray;
        JSONArray jSONArray2;
        block10: {
            block9: {
                try {
                    if (this.getRawReferrer(string, l2) == null) break block9;
                    return;
                }
                catch (JSONException jSONException) {}
            }
            jSONArray2 = this.getRawReferrerArray();
            if (jSONArray2.length() != 10) break block10;
            return;
        }
        SharedPreferencesManager sharedPreferencesManager = this;
        JSONArray jSONArray3 = jSONArray2;
        JSONArray jSONArray4 = jSONArray3;
        JSONArray jSONArray5 = jSONArray3;
        JSONArray jSONArray6 = jSONArray;
        JSONArray jSONArray7 = jSONArray;
        jSONArray = new JSONArray();
        JSONArray jSONArray8 = jSONArray;
        jSONArray.put(0, (Object)string);
        jSONArray6.put(1, l2);
        jSONArray7.put(2, 0);
        jSONArray4.put((Object)jSONArray8);
        sharedPreferencesManager.saveRawReferrerArray(jSONArray5);
    }

    public synchronized void saveRawReferrerArray(JSONArray object) {
        SharedPreferencesManager sharedPreferencesManager = this;
        JSONArray jSONArray = object;
        object = PREFS_KEY_RAW_REFERRERS;
        try {
            sharedPreferencesManager.saveString((String)object, jSONArray.toString());
        }
        catch (Throwable throwable) {
            this.remove(PREFS_KEY_RAW_REFERRERS);
        }
    }

    public synchronized void removeRawReferrer(String string, long l2) {
        if (string != null && string.length() != 0) {
            JSONArray jSONArray;
            int n2 = this.getRawReferrerIndex(string, l2);
            if (n2 < 0) {
                return;
            }
            JSONArray jSONArray2 = this.getRawReferrerArray();
            JSONArray jSONArray3 = jSONArray;
            jSONArray = new JSONArray();
            for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                if (i2 == n2) continue;
                try {
                    jSONArray3.put((Object)jSONArray2.getJSONArray(i2));
                }
                catch (JSONException jSONException) {}
            }
            this.saveString(PREFS_KEY_RAW_REFERRERS, jSONArray3.toString());
            return;
        }
    }

    public synchronized JSONArray getRawReferrer(String string, long l2) {
        int n2 = this.getRawReferrerIndex(string, l2);
        if (n2 >= 0) {
            try {
                return this.getRawReferrerArray().getJSONArray(n2);
            }
            catch (JSONException jSONException) {}
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized JSONArray getRawReferrerArray() {
        JSONArray jSONArray;
        JSONArray jSONArray2;
        String string = this.getString(PREFS_KEY_RAW_REFERRERS);
        if (string == null) return new JSONArray();
        JSONArray jSONArray3 = jSONArray2;
        if (new JSONArray(string).length() <= 10) return new JSONArray(string);
        string = jSONArray;
        jSONArray = new JSONArray();
        for (int i2 = 0; i2 < 10; ++i2) {
            string.put(jSONArray3.get(i2));
        }
        try {
            this.saveRawReferrerArray((JSONArray)string);
            return string;
        }
        catch (Throwable throwable) {
            return new JSONArray();
        }
        catch (JSONException jSONException) {}
        return new JSONArray();
    }

    public synchronized void savePreinstallReferrer(String string) {
        this.saveString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER, string);
    }

    public synchronized String getPreinstallReferrer() {
        return this.getString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void removePreinstallReferrer() {
        this.remove(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void setSendingReferrersAsNotSent() {
        block9: {
            JSONArray jSONArray = this.getRawReferrerArray();
            boolean bl = false;
            int n2 = 0;
            while (true) {
                block8: {
                    if (n2 >= jSONArray.length()) break;
                    JSONArray jSONArray2 = jSONArray.getJSONArray(n2);
                    if (jSONArray2.optInt(2, -1) != 1) break block8;
                    jSONArray2.put(2, 0);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) break block9;
            try {
                this.saveRawReferrerArray(jSONArray);
            }
            catch (JSONException jSONException) {}
        }
    }

    public synchronized void savePushToken(String string) {
        this.saveString(PREFS_KEY_PUSH_TOKEN, string);
    }

    public synchronized String getPushToken() {
        return this.getString(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void removePushToken() {
        this.remove(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void setInstallTracked() {
        this.saveBoolean(PREFS_KEY_INSTALL_TRACKED, true);
    }

    public synchronized boolean getInstallTracked() {
        return this.getBoolean(PREFS_KEY_INSTALL_TRACKED, false);
    }

    public synchronized void setGdprForgetMe() {
        this.saveBoolean(PREFS_KEY_GDPR_FORGET_ME, true);
    }

    public synchronized boolean getGdprForgetMe() {
        return this.getBoolean(PREFS_KEY_GDPR_FORGET_ME, false);
    }

    public synchronized void removeGdprForgetMe() {
        this.remove(PREFS_KEY_GDPR_FORGET_ME);
    }

    public synchronized void setDisableThirdPartySharing() {
        this.saveBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, true);
    }

    public synchronized boolean getDisableThirdPartySharing() {
        return this.getBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, false);
    }

    public synchronized void removeDisableThirdPartySharing() {
        this.remove(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING);
    }

    public synchronized void saveDeeplink(Uri uri, long l2) {
        if (uri == null) {
            return;
        }
        SharedPreferencesManager sharedPreferencesManager = this;
        sharedPreferencesManager.saveString(PREFS_KEY_DEEPLINK_URL, uri.toString());
        sharedPreferencesManager.saveLong(PREFS_KEY_DEEPLINK_CLICK_TIME, l2);
    }

    public synchronized String getDeeplinkUrl() {
        return this.getString(PREFS_KEY_DEEPLINK_URL);
    }

    public synchronized long getDeeplinkClickTime() {
        return this.getLong(PREFS_KEY_DEEPLINK_CLICK_TIME, -1L);
    }

    public synchronized void removeDeeplink() {
        SharedPreferencesManager sharedPreferencesManager = this;
        sharedPreferencesManager.remove(PREFS_KEY_DEEPLINK_URL);
        sharedPreferencesManager.remove(PREFS_KEY_DEEPLINK_CLICK_TIME);
    }

    public synchronized void setPreinstallPayloadReadStatus(long l2) {
        this.saveLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, l2);
    }

    public synchronized long getPreinstallPayloadReadStatus() {
        return this.getLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, 0L);
    }

    public synchronized void clear() {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.clear().apply();
        }
    }
}

