/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
implements IPackageHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private ThreadScheduler scheduler;
    private IActivityPackageSender activityPackageSender;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private BackoffStrategy backoffStrategyForInstallSession;

    public static void deleteState(Context context) {
        PackageHandler.deletePackageQueue(context);
    }

    public PackageHandler(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PackageHandler packageHandler = this;
        this.scheduler = new SingleThreadCachedScheduler("PackageHandler");
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getPackageHandlerBackoffStrategy();
        this.backoffStrategyForInstallSession = AdjustFactory.getInstallSessionBackoffStrategy();
        packageHandler.init(iActivityHandler, context, bl, iActivityPackageSender);
        packageHandler.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.initI();
            }
        });
    }

    private void initI() {
        AtomicBoolean atomicBoolean;
        PackageHandler packageHandler = atomicBoolean2;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean();
        packageHandler.isSending = atomicBoolean2;
        packageHandler.readPackageQueueI();
    }

    private void addI(ActivityPackage activityPackage) {
        Object[] objectArray = objectArray6;
        Object[] objectArray2 = objectArray6;
        objectArray.packageQueue.add(activityPackage);
        Object[] objectArray3 = new Object[2];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = objectArray6.packageQueue.size();
        objectArray3[1] = activityPackage;
        objectArray2.logger.debug("Added package %d (%s)", objectArray4);
        Object[] objectArray5 = new Object[1];
        Object[] objectArray6 = objectArray5;
        objectArray5[0] = activityPackage.getExtendedString();
        objectArray.logger.verbose("%s", objectArray6);
        super.writePackageQueueI();
    }

    private void sendFirstI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        PackageHandler packageHandler = this;
        Map<String, String> map = packageHandler.generateSendingParametersI();
        ActivityPackage activityPackage = packageHandler.packageQueue.get(0);
        packageHandler.activityPackageSender.sendActivityPackage(activityPackage, map, this);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        PackageHandler packageHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l2 = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l2));
        int n2 = packageHandler.packageQueue.size() - 1;
        if (n2 > 0) {
            long l3 = n2;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l3);
        }
        return hashMap2;
    }

    private void sendNextI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        PackageHandler packageHandler = this;
        packageHandler.packageQueue.remove(0);
        packageHandler.writePackageQueueI();
        packageHandler.isSending.set(false);
        packageHandler.logger.verbose("Package handler can send", new Object[0]);
        packageHandler.sendFirstI();
    }

    private void flushI() {
        PackageHandler packageHandler = this;
        packageHandler.packageQueue.clear();
        packageHandler.writePackageQueueI();
    }

    private void readPackageQueueI() {
        Object[] objectArray;
        try {
            objectArray.packageQueue = Util.readObject(objectArray.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = PACKAGE_QUEUE_NAME;
            objectArray2[1] = exception.getMessage();
            objectArray.logger.error("Failed to read %s file (%s)", objectArray3);
            objectArray.packageQueue = null;
        }
        List<ActivityPackage> list = objectArray.packageQueue;
        if (list != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = list.size();
            objectArray.logger.debug("Package handler read %d packages", objectArray);
        } else {
            ArrayList arrayList;
            PackageHandler packageHandler = objectArray;
            objectArray = arrayList;
            arrayList = new ArrayList();
            packageHandler.packageQueue = objectArray;
        }
    }

    private void writePackageQueueI() {
        PackageHandler packageHandler = this;
        Util.writeObject(packageHandler.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.packageQueue.size();
        packageHandler.logger.debug("Package handler wrote %d packages", objectArray2);
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }

    @Override
    public void teardown() {
        PackageHandler packageHandler = this;
        packageHandler.logger.verbose("PackageHandler teardown", new Object[0]);
        List<ActivityPackage> list = packageHandler.scheduler;
        if (list != null) {
            list.teardown();
        }
        if ((list = this.activityHandlerWeakRef) != null) {
            ((Reference)((Object)list)).clear();
        }
        if ((list = this.packageQueue) != null) {
            list.clear();
        }
        PackageHandler packageHandler2 = this;
        packageHandler2.scheduler = null;
        packageHandler2.activityHandlerWeakRef = null;
        packageHandler2.packageQueue = null;
        packageHandler2.isSending = null;
        packageHandler2.context = null;
        packageHandler2.logger = null;
        packageHandler2.backoffStrategy = null;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.context = context;
        this.paused = bl ^ true;
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.addI(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendFirstI();
            }
        });
    }

    @Override
    public void onResponseDataCallback(ResponseData responseData) {
        Runnable runnable;
        PackageHandler packageHandler = string;
        packageHandler.logger.debug("Got response in PackageHandler", new Object[0]);
        Object object = (IActivityHandler)packageHandler.activityHandlerWeakRef.get();
        if (object != null && responseData.trackingState == TrackingState.OPTED_OUT) {
            object.gotOptOutResponse();
        }
        if (!responseData.willRetry) {
            ((PackageHandler)((Object)string)).scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    PackageHandler.this.sendNextI();
                }
            });
            if (object != null) {
                object.finishedTrackingActivity(responseData);
            }
            return;
        }
        if (object != null) {
            object.finishedTrackingActivity(responseData);
        }
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                e e2 = this;
                e2.PackageHandler.this.logger.verbose("Package handler can send", new Object[0]);
                e2.PackageHandler.this.isSending.set(false);
                e2.PackageHandler.this.sendFirstPackage();
            }
        };
        Object object2 = responseData.activityPackage;
        if (object2 == null) {
            object.run();
            return;
        }
        int n2 = ((ActivityPackage)object2).increaseRetries();
        object2 = SharedPreferencesManager.getDefaultInstance(((PackageHandler)((Object)string)).context);
        long l2 = responseData.activityPackage.getActivityKind() == ActivityKind.SESSION && !((SharedPreferencesManager)object2).getInstallTracked() ? Util.getWaitingTime(n2, ((PackageHandler)((Object)string)).backoffStrategyForInstallSession) : Util.getWaitingTime(n2, ((PackageHandler)((Object)string)).backoffStrategy);
        PackageHandler packageHandler2 = string;
        double d2 = (double)l2 / 1000.0;
        String string = Util.SecondsDisplayFormat.format(d2);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray[1] = n2;
        packageHandler2.logger.verbose("Waiting for %s seconds before retrying the %d time", objectArray2);
        packageHandler2.scheduler.schedule((Runnable)object, l2);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void updatePackages(final SessionParameters sessionParameters) {
        sessionParameters = sessionParameters != null ? sessionParameters.deepCopy() : null;
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.updatePackagesI(sessionParameters);
            }
        });
    }

    @Override
    public void flush() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.flushI();
            }
        });
    }

    public void updatePackagesI(SessionParameters sessionParameters) {
        if (sessionParameters == null) {
            return;
        }
        PackageHandler packageHandler = this;
        packageHandler.logger.debug("Updating package handler queue", new Object[0]);
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = sessionParameters.callbackParameters;
        packageHandler.logger.verbose("Session callback parameters: %s", (Object[])object);
        Object[] objectArray2 = new Object[1];
        object = objectArray2;
        objectArray2[0] = sessionParameters.partnerParameters;
        packageHandler.logger.verbose("Session partner parameters: %s", (Object[])object);
        for (ActivityPackage activityPackage : packageHandler.packageQueue) {
            Map<String, String> map = activityPackage.getParameters();
            PackageBuilder.addMapJson(map, "callback_params", Util.mergeParameters(sessionParameters.callbackParameters, activityPackage.getCallbackParameters(), "Callback"));
            PackageBuilder.addMapJson(map, "partner_params", Util.mergeParameters(sessionParameters.partnerParameters, activityPackage.getPartnerParameters(), "Partner"));
        }
        this.writePackageQueueI();
    }
}

