/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AdjustLinkResolution {
    private static volatile ExecutorService executor;
    private static final int maxRecursions = 10;
    private static final String[] expectedUrlHostSuffixArray;

    private AdjustLinkResolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void resolveLink(String stringArray, String[] stringArray2, final AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        URL uRL;
        if (adjustLinkResolutionCallback == null) {
            return;
        }
        if (stringArray == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        final URL uRL2 = null;
        URL uRL3 = uRL;
        try {
            uRL = new URL((String)stringArray);
            uRL2 = uRL3;
        }
        catch (MalformedURLException malformedURLException) {}
        if (uRL2 == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        if (!AdjustLinkResolution.urlMatchesSuffix(uRL2.getHost(), stringArray2)) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL2));
            return;
        }
        if (executor == null) {
            stringArray = expectedUrlHostSuffixArray;
            // MONITORENTER : expectedUrlHostSuffixArray
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : stringArray
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                AdjustLinkResolution.requestAndResolve(uRL2, 0, adjustLinkResolutionCallback);
            }
        });
    }

    private static void resolveLink(URL uRL, URL uRL2, int n2, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        if (uRL == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL2));
            return;
        }
        if (AdjustLinkResolution.isTerminalUrl(uRL.getHost())) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL));
            return;
        }
        if (n2 > 10) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL));
            return;
        }
        AdjustLinkResolution.requestAndResolve(uRL, n2, adjustLinkResolutionCallback);
    }

    private static void requestAndResolve(URL uRL, int n2, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        HttpURLConnection httpURLConnection;
        URL uRL2;
        block6: {
            URL uRL3;
            uRL = AdjustLinkResolution.convertToHttps(uRL);
            uRL2 = null;
            httpURLConnection = null;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.connect();
            String string = httpURLConnection.getHeaderField("Location");
            if (string == null) break block6;
            URL uRL4 = uRL3;
            try {
                uRL3 = new URL(string);
                uRL2 = uRL4;
            }
            catch (Throwable throwable) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                AdjustLinkResolution.resolveLink(uRL2, uRL, n2 + 1, adjustLinkResolutionCallback);
            }
        }
        httpURLConnection.disconnect();
        AdjustLinkResolution.resolveLink(uRL2, uRL, n2 + 1, adjustLinkResolutionCallback);
    }

    private static boolean isTerminalUrl(String string) {
        return AdjustLinkResolution.urlMatchesSuffix(string, expectedUrlHostSuffixArray);
    }

    private static boolean urlMatchesSuffix(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.endsWith(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    private static URL convertToHttps(URL uRL) {
        URL uRL2;
        if (uRL == null) {
            return uRL;
        }
        String string = uRL.toExternalForm();
        if (string == null) {
            return uRL;
        }
        if (!string.startsWith("http:")) {
            return uRL;
        }
        URL uRL3 = uRL2;
        try {
            uRL2 = new URL("https:" + string.substring(5));
            uRL = uRL3;
        }
        catch (MalformedURLException malformedURLException) {}
        return uRL;
    }

    private static Uri convertToUri(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return Uri.parse((String)uRL.toString());
    }

    static {
        expectedUrlHostSuffixArray = new String[]{"adjust.com", "adj.st", "go.link"};
    }

    public static interface AdjustLinkResolutionCallback {
        public void resolvedLinkCallback(Uri var1);
    }
}

