/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.scheduler;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AsyncTaskExecutor<Params, Result> {
    protected abstract Result doInBackground(Params[] var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result) {
    }

    @SafeVarargs
    public final AsyncTaskExecutor<Params, Result> execute(final Params ... params) {
        this.onPreExecute();
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                final Object result = AsyncTaskExecutor.this.doInBackground(params);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AsyncTaskExecutor.this.onPostExecute(result);
                    }
                });
            }
        });
        return this;
    }
}

